# Workflow Core 1.2.9

* .Recur() API, define a block of steps to execute on a recurring interval, until a condition becomes true

This following example will execute the block of every day until the `StopRecurring` field on the data object becomes true
```c#
builder                
    .StartWith<HelloWorld>()
    .Recur(data => TimeSpan.FromDays(1), data => data.StopRecurring)
		.Do(recur => recur
			.StartWith<DoSomething>()
			.Then<DoSomethingElse>())
    .Then<GoodbyeWorld>();
```

* Added access to the execution context object when resolving an event key in the .WaitFor API

```c#
.WaitFor("event", (data, context) => context.Workflow.Id)
```

* Deprecated `UserStep` in favour of the new `UserTask` API
* Added basic escalation functionality to `UserTask`

This following example will create a user task with 2 options and 2 resultant paths, as well as escalate the task after 1 day.
```c#
builder
    .StartWith(context => ExecutionResult.Next())
    .UserTask("Do you approve", data => @"domain\bob")
        .WithOption("yes", "I approve").Do(then => then
            .StartWith(context => Console.WriteLine("You approved"))
        )
        .WithOption("no", "I do not approve").Do(then => then
            .StartWith(context => Console.WriteLine("You did not approve"))
        )
        .WithEscalation(x => TimeSpan.FromDays(1), x => @"domain\frank", action => action
            .StartWith(context => Console.WriteLine("Escalated task"))
            .Then(context => Console.WriteLine("Sending notification..."))
            )
    .Then(context => Console.WriteLine("end"));
```
