package com.tumininu.staves.ui.activity

import android.content.Context
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.Navigation
import com.tumininu.staves.R
import com.tumininu.staves.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        setTheme(R.style.Theme_Staves)
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        firstRun()
    }

    private fun firstRun() {
        // Shared Preference storing initial instance an app was first launched
        val isFirstRun: Boolean =
            getSharedPreferences("PREFERENCE", Context.MODE_PRIVATE)
                .getBoolean("isFirstRun", true)

        if (isFirstRun) {
            Navigation.findNavController(this, R.id.nav_host)
                .navigate(R.id.welcomeFragment)
        } else {
            Navigation.findNavController(this, R.id.nav_host)
                .navigate(R.id.action_welcomeFragment_to_noteFragment)
        }

        getSharedPreferences("PREFERENCE", Context.MODE_PRIVATE).edit()
            .putBoolean("isFirstRun", false).apply()
    }

}