# -*- coding: UTF-8 -*-
#
# Copyright 2014 PagerDuty, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

describe LitaGithub do
  describe '::VERSION' do
    subject { LitaGithub::VERSION }
    it { should be_an_instance_of String }
    it { should match(/\d+\.\d+\.\d+(?:\-[a-zA-Z0-9_\.\-]+)?/) }
  end

  describe '::MAJOR_VERSION' do
    subject { LitaGithub::MAJOR_VERSION }
    it { should be_an_instance_of Fixnum }
    it { should be >= 0 }
  end

  describe '::MINOR_VERSION' do
    subject { LitaGithub::MINOR_VERSION }
    it { should be_an_instance_of Fixnum }
    it { should be >= 0 }
  end

  describe '::REVISION' do
    subject { LitaGithub::REVISION }
    it { should be_an_instance_of Fixnum }
    it { should be >= 0 }
  end
end
