from typing import TypeVar

T = TypeVar('T')


def auto_str(cls: T) -> T:
    def __str__(self) -> str:
        return '%s(%s)' % (
            type(self).__name__,
            ', '.join('%s=%s' % item for item in vars(self).items())
        )

    cls.__str__ = __str__
    return cls
