# Empirical Wavelet Transforms Package

This package is the official package that provides the different empirical wavelet transforms published by J.Gilles and his lab.
It does provide the same transforms as the original Matlab toolbox (https://github.com/jegilles/Empirical-Wavelets).

The source code is available at: https://github.com/jegilles/pyewt

The available transforms are:

### 1D transform

- original Littlewood-Paley transform
- transform using different mother wavelets
- tools to extract/plot the time-frequency information

### 2D transform

- tensor approach
- isotropic Littlewood-Paley
- curvelets type I, II, and III
- Voronoi based Littlewood-Paley
- watershed based Littlewood-Paley
- plotting tools for both the filters and the extracted wavelet coefficients

### Partition detection tools

- basic 1D partitioning
- scale-space method in both 1D and 2D
- Voronoi and watershed partitioning

# References

All papers are available in the "Publications" section at: https://jegilles.sdsu.edu/

- J.Gilles, "Empirical Wavelet Transform" in IEEE Trans. Signal Processing, Vol.61, No.16, 3999--4010, August 2013.
- J.Gilles, G.Tran, S.Osher "2D Empirical transforms. Wavelets, Ridgelets and Curvelets Revisited" in SIAM Journal on Imaging Sciences, Vol.7, No.1, 157--186, January 2014.
- J.Gilles, K.Heal, "A parameterless scale-space approach to find meaningful modes in histograms - Application to image and spectrum segmentation". International Journal of Wavelets, Multiresolution and Information Processing, Vol.12, No.6, 1450044-1--1450044-17, December 2014.
- J.Gilles, "Continuous empirical wavelets systems", Advances in Data Science and Adaptive Analysis, Vol. 12, No 03n04, 2050006, 2020.
- B.Hurat, Z.Alvarado, J.Gilles. "The Empirical Watershed Wavelet", Journal of Imaging, Special Issue "2020 Selected Papers from Journal of Imaging Editorial Board Members", Vol.6, No.12, 140, 2020.
- J.Gilles, "Empirical Voronoi wavelets", Constructive Mathematical Analysis, Vol.5, No.4, 183--189, 2022.
