The [pull-tester](/qa/pull-tester/) folder contains a script to call
multiple tests from the [rpc-tests](/qa/rpc-tests/) folder.

Every pull request to the Dash Core repository is built and run through
the regression test suite. You can also run all or only individual
tests locally.

Test dependencies
=================
Before running the tests, the following must be installed.

Unix
----
The python-zmq library is required. On Ubuntu or Debian it can be installed via: 
```
sudo apt-get install python-zmq
```

Running tests
=============

You can run any single test by calling `qa/pull-tester/rpc-tests.py <testname>`.

Or you can run any combination of tests by calling `qa/pull-tester/rpc-tests.py <testname1> <testname2> <testname3> ...`

Run the regression test suite with `qa/pull-tester/rpc-tests.py`

Run all possible tests with `qa/pull-tester/rpc-tests.py -extended`

Possible options:

```
  -h, --help            show this help message and exit
  --nocleanup           Leave dashds and test.* datadir on exit or error
  --noshutdown          Don't stop dashds after the test execution
  --srcdir=SRCDIR       Source directory containing dashd/dash-cli
                        (default: ../../src)
  --tmpdir=TMPDIR       Root directory for datadirs
  --tracerpc            Print out all RPC calls as they are made
  --coveragedir=COVERAGEDIR
                        Write tested RPC commands into this directory
```

If you set the environment variable `PYTHON_DEBUG=1` you will get some debug
output (example: `PYTHON_DEBUG=1 qa/pull-tester/rpc-tests.py wallet`).

A 200-block -regtest blockchain and wallets for four nodes
is created the first time a regression test is run and
is stored in the cache/ directory. Each node has 25 mature
blocks (25*500=12500 DASH) in its wallet.

After the first run, the cache/ blockchain and wallets are
copied into a temporary directory and used as the initial
test state.

If you get into a bad state, you should be able
to recover with:

```bash
rm -rf cache
killall dashd
```

Writing tests
=============
You are encouraged to write tests for new or existing features.
Further information about the test framework and individual rpc
tests is found in [qa/rpc-tests](/qa/rpc-tests).
