/* 
 * Copyright 2015-2024 (c) CoralBlocks LLC - http://www.coralblocks.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package com.coralblocks.coralproto;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.junit.Assert;
import org.junit.Test;

import com.coralblocks.coralproto.field.BooleanField;
import com.coralblocks.coralproto.field.GroupField;
import com.coralblocks.coralproto.field.IntField;
import com.coralblocks.coralproto.field.LongField;
import com.coralblocks.coralproto.field.ProtoField;
import com.coralblocks.coralproto.field.RepeatingGroupField;
import com.coralblocks.coralproto.field.SubtypeField;
import com.coralblocks.coralproto.field.TypeField;
import com.coralblocks.coralproto.util.ByteBufferUtils;


public class RepeatingGroupsTest {
	
	public static class RepeatingGroupProtoMessage extends AbstractProto {
		
		private static final String IDL_CODE = """
				
                TYPE = A
                SUBTYPE = F
				
                myBoolean: boolean 
                myLong: long!
				
                bids:
                   levelId: long!
                   qty: int
                   legs:
                      legId: int
                      legCode: long!
                   orders: int
                				
                """;
		
		public static void main(String[] args) throws IOException {
			IDL idl = new IDL(IDL_CODE, IDL.INDENT + IDL.INDENT);
			String filePath = "src/test/java/com/coralblocks/coralproto/" + RepeatingGroupsTest.class.getSimpleName() + ".java";
			String sourceCode = idl.getCode();
			IDL.replaceAutoGeneratedCode(filePath, sourceCode);
		}
		
		// Auto-generated code. Do not edit or change anything below here
		
		// BEGIN_AUTO_GENERATED_CODE

        public final static char TYPE = 'A';
        public final static char SUBTYPE = 'F';

        public final TypeField typeField = new TypeField(this, TYPE);
        public final SubtypeField subtypeField = new SubtypeField(this, SUBTYPE);

        public final BooleanField myBoolean = new BooleanField(this);

        public final LongField myLong = new LongField(this, true);

        public static class BidsRepeatingGroup extends RepeatingGroupField {

            public LongField levelId;

            public IntField qty;

            public static class LegsRepeatingGroup extends RepeatingGroupField {

                public IntField legId;

                public LongField legCode;

                public LegsRepeatingGroup(AbstractProto proto) {
                    this(proto, new IntField(), new LongField(true));
                }

                public LegsRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
                    super(proto, protoFields);
                }

                @Override
                public GroupField nextElement() {
                    GroupField groupField = super.nextElement();
                    this.legId = (IntField) groupField.internalArray()[0];
                    this.legCode = (LongField) groupField.internalArray()[1];
                    return groupField;
                } 

                @Override
                public GroupField iterNext() {
                    GroupField groupField = super.iterNext();
                    if (groupField != null) {
                        this.legId = (IntField) groupField.internalArray()[0];
                        this.legCode = (LongField) groupField.internalArray()[1];
                    }
                    return groupField;
                } 

                @Override
                protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
                    return new BidsRepeatingGroup.LegsRepeatingGroup(null, protoFields);
                } 

            }

            public BidsRepeatingGroup.LegsRepeatingGroup legs;

            public IntField orders;

            public BidsRepeatingGroup(AbstractProto proto) {
                this(proto, new LongField(true), new IntField(), new BidsRepeatingGroup.LegsRepeatingGroup(null), new IntField());
            }

            public BidsRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
                super(proto, protoFields);
            }

            @Override
            public GroupField nextElement() {
                GroupField groupField = super.nextElement();
                this.levelId = (LongField) groupField.internalArray()[0];
                this.qty = (IntField) groupField.internalArray()[1];
                this.legs = (BidsRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[2];
                this.orders = (IntField) groupField.internalArray()[3];
                return groupField;
            } 

            @Override
            public GroupField iterNext() {
                GroupField groupField = super.iterNext();
                if (groupField != null) {
                    this.levelId = (LongField) groupField.internalArray()[0];
                    this.qty = (IntField) groupField.internalArray()[1];
                    this.legs = (BidsRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[2];
                    this.orders = (IntField) groupField.internalArray()[3];
                }
                return groupField;
            } 

            @Override
            protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
                return new BidsRepeatingGroup(null, protoFields);
            } 

        }

        public final BidsRepeatingGroup bids = new BidsRepeatingGroup(this);


		// END_AUTO_GENERATED_CODE
	}
	
	@Test
	public void testRepeatingGroupFields() {
		
		RepeatingGroupProtoMessage proto = new RepeatingGroupProtoMessage();
		
		Assert.assertEquals(RepeatingGroupProtoMessage.TYPE, proto.getType());
		Assert.assertEquals(RepeatingGroupProtoMessage.SUBTYPE, proto.getSubtype());

		Assert.assertEquals(false, proto.myBoolean.isOptional());
		Assert.assertEquals(true, proto.myBoolean.isPresent());
		Assert.assertEquals(false, proto.myBoolean.get());
		proto.myBoolean.set(true);
		Assert.assertEquals(true, proto.myBoolean.get());
		
		Assert.assertEquals(true, proto.myLong.isOptional());
		Assert.assertEquals(false, proto.myLong.isPresent());
		proto.myLong.set(6123424243345L);
		Assert.assertEquals(true, proto.myLong.isPresent());
		Assert.assertEquals(6123424243345L, proto.myLong.get());
		
		Assert.assertEquals(0, proto.bids.getNumberOfElements());
		
		proto.bids.clear();
		
		Assert.assertEquals(0, proto.bids.getNumberOfElements());
		
		proto.bids.nextElement();
		Assert.assertEquals(true, proto.bids.levelId.isOptional());
		Assert.assertEquals(false, proto.bids.levelId.isPresent());
		proto.bids.levelId.set(1212);
		Assert.assertEquals(true, proto.bids.levelId.isPresent());
		Assert.assertEquals(1212, proto.bids.levelId.get());
		Assert.assertEquals(false, proto.bids.qty.isOptional());
		Assert.assertEquals(true, proto.bids.qty.isPresent());
		Assert.assertEquals(0, proto.bids.qty.get());
		proto.bids.qty.set(200);
		Assert.assertEquals(200, proto.bids.qty.get());
		Assert.assertEquals(false, proto.bids.orders.isOptional());
		Assert.assertEquals(true, proto.bids.orders.isPresent());
		Assert.assertEquals(0, proto.bids.orders.get());
		proto.bids.orders.set(1);
		Assert.assertEquals(1, proto.bids.orders.get());
		
		Assert.assertEquals(0, proto.bids.legs.getNumberOfElements());
		proto.bids.legs.clear();
		Assert.assertEquals(0, proto.bids.legs.getNumberOfElements());
		proto.bids.legs.nextElement();
		Assert.assertEquals(false, proto.bids.legs.legId.isOptional());
		Assert.assertEquals(true, proto.bids.legs.legId.isPresent());
		Assert.assertEquals(0, proto.bids.legs.legId.get());
		proto.bids.legs.legId.set(22321);
		Assert.assertEquals(22321, proto.bids.legs.legId.get());
		Assert.assertEquals(true, proto.bids.legs.legCode.isOptional());
		Assert.assertEquals(false, proto.bids.legs.legCode.isPresent());
		proto.bids.legs.legCode.set(332);
		Assert.assertEquals(true, proto.bids.legs.legCode.isPresent());
		Assert.assertEquals(332, proto.bids.legs.legCode.get());
		Assert.assertEquals(1, proto.bids.legs.getNumberOfElements());
		proto.bids.legs.nextElement();
		Assert.assertEquals(false, proto.bids.legs.legId.isOptional());
		Assert.assertEquals(true, proto.bids.legs.legId.isPresent());
		Assert.assertEquals(0, proto.bids.legs.legId.get());
		proto.bids.legs.legId.set(22322);
		Assert.assertEquals(22322, proto.bids.legs.legId.get());
		Assert.assertEquals(true, proto.bids.legs.legCode.isOptional());
		Assert.assertEquals(false, proto.bids.legs.legCode.isPresent());
		Assert.assertEquals(2, proto.bids.legs.getNumberOfElements());
		
		Assert.assertEquals(1, proto.bids.getNumberOfElements());
		
		proto.bids.nextElement();
		Assert.assertEquals(true, proto.bids.levelId.isOptional());
		Assert.assertEquals(false, proto.bids.levelId.isPresent());
		Assert.assertEquals(false, proto.bids.qty.isOptional());
		Assert.assertEquals(true, proto.bids.qty.isPresent());
		Assert.assertEquals(0, proto.bids.qty.get());
		proto.bids.qty.set(400);
		Assert.assertEquals(400, proto.bids.qty.get());
		Assert.assertEquals(false, proto.bids.orders.isOptional());
		Assert.assertEquals(true, proto.bids.orders.isPresent());
		Assert.assertEquals(0, proto.bids.orders.get());
		proto.bids.orders.set(2);
		Assert.assertEquals(2, proto.bids.orders.get());
		
		Assert.assertEquals(0, proto.bids.legs.getNumberOfElements());
		proto.bids.legs.clear();
		Assert.assertEquals(0, proto.bids.legs.getNumberOfElements());
		proto.bids.legs.nextElement();
		Assert.assertEquals(false, proto.bids.legs.legId.isOptional());
		Assert.assertEquals(true, proto.bids.legs.legId.isPresent());
		Assert.assertEquals(0, proto.bids.legs.legId.get());
		proto.bids.legs.legId.set(22325);
		Assert.assertEquals(22325, proto.bids.legs.legId.get());
		Assert.assertEquals(1, proto.bids.legs.getNumberOfElements());
		proto.bids.legs.nextElement();
		Assert.assertEquals(false, proto.bids.legs.legId.isOptional());
		Assert.assertEquals(true, proto.bids.legs.legId.isPresent());
		Assert.assertEquals(0, proto.bids.legs.legId.get());
		proto.bids.legs.legId.set(22326);
		Assert.assertEquals(22326, proto.bids.legs.legId.get());
		Assert.assertEquals(2, proto.bids.legs.getNumberOfElements());
		
		Assert.assertEquals(2, proto.bids.getNumberOfElements());
		
		proto.bids.beginIteration();
		
		Assert.assertEquals(true, proto.bids.iterHasNext());
			
		proto.bids.iterNext();
		
		Assert.assertEquals(1212, proto.bids.levelId.get());
		Assert.assertEquals(200, proto.bids.qty.get());
		Assert.assertEquals(1, proto.bids.orders.get());
		
		proto.bids.legs.beginIteration();
		
		Assert.assertEquals(true, proto.bids.legs.iterHasNext());
		
		proto.bids.legs.iterNext();
		
		Assert.assertEquals(22321, proto.bids.legs.legId.get());
		Assert.assertEquals(332, proto.bids.legs.legCode.get());
		
		Assert.assertEquals(true, proto.bids.legs.iterHasNext());
		
		proto.bids.legs.iterNext();
		
		Assert.assertEquals(22322, proto.bids.legs.legId.get());
		Assert.assertEquals(false, proto.bids.legs.legCode.isPresent());
		
		Assert.assertEquals(false, proto.bids.legs.iterHasNext());
		
		Assert.assertEquals(true, proto.bids.iterHasNext());
		
		proto.bids.iterNext();
		
		Assert.assertEquals(false, proto.bids.levelId.isPresent());
		Assert.assertEquals(400, proto.bids.qty.get());
		Assert.assertEquals(2, proto.bids.orders.get());
		
		proto.bids.legs.beginIteration();
		
		Assert.assertEquals(true, proto.bids.legs.iterHasNext());
		
		proto.bids.legs.iterNext();
		
		Assert.assertEquals(22325, proto.bids.legs.legId.get());
		Assert.assertEquals(false, proto.bids.legs.legCode.isPresent());
		
		Assert.assertEquals(true, proto.bids.legs.iterHasNext());
		
		proto.bids.legs.iterNext();
		
		Assert.assertEquals(22326, proto.bids.legs.legId.get());
		Assert.assertEquals(false, proto.bids.legs.legCode.isPresent());
		
		Assert.assertEquals(false, proto.bids.legs.iterHasNext());
		
		Assert.assertEquals(false, proto.bids.iterHasNext());
	}
	
	@Test
	public void testSendAndReceive() {
		
		ByteBuffer bb = ByteBuffer.allocate(1024);
		
		RepeatingGroupProtoMessage proto = new RepeatingGroupProtoMessage();
		
		proto.myBoolean.set(true);
		proto.myLong.set(6123424243345L);

		proto.bids.clear();

		proto.bids.nextElement();
		proto.bids.levelId.set(1212);
		proto.bids.qty.set(200);

		proto.bids.legs.clear();

		proto.bids.legs.nextElement();
		proto.bids.legs.legId.set(22321);
		proto.bids.legs.legCode.set(332);

		proto.bids.legs.nextElement();
		proto.bids.legs.legId.set(22322);
		proto.bids.legs.legCode.markAsNotPresent();
		
		proto.bids.orders.set(3);
		
		proto.bids.nextElement();
		proto.bids.levelId.markAsNotPresent();
		proto.bids.qty.set(400);
		
		proto.bids.legs.clear();

		proto.bids.legs.nextElement();
		proto.bids.legs.legId.set(22325);
		proto.bids.legs.legCode.markAsNotPresent();
		
		proto.bids.legs.nextElement();
		proto.bids.legs.legId.set(22326);
		proto.bids.legs.legCode.markAsNotPresent();
		
		proto.bids.orders.set(2);
		
		proto.write(bb);
		
		bb.flip();
		
		RepeatingGroupProtoMessage received = new RepeatingGroupProtoMessage();
		
		Assert.assertEquals(RepeatingGroupProtoMessage.TYPE, bb.get());
		Assert.assertEquals(RepeatingGroupProtoMessage.SUBTYPE, bb.get());
		
		received.read(bb);
		
		Assert.assertEquals(true, received.myBoolean.get());
		Assert.assertEquals(6123424243345L, received.myLong.get());
		
		received.bids.beginIteration();
		
		Assert.assertEquals(true, received.bids.iterHasNext());
		
		received.bids.iterNext();
		
		Assert.assertEquals(1212, received.bids.levelId.get());
		Assert.assertEquals(200, received.bids.qty.get());
		
		received.bids.legs.beginIteration();
		
		Assert.assertEquals(true, received.bids.legs.iterHasNext());
		
		received.bids.legs.iterNext();
		
		Assert.assertEquals(22321, received.bids.legs.legId.get());
		Assert.assertEquals(332, received.bids.legs.legCode.get());
		
		Assert.assertEquals(true, received.bids.legs.iterHasNext());
		
		received.bids.legs.iterNext();
		
		Assert.assertEquals(22322, received.bids.legs.legId.get());
		Assert.assertEquals(false, received.bids.legs.legCode.isPresent());
		
		Assert.assertEquals(false, received.bids.legs.iterHasNext());

		Assert.assertEquals(3, received.bids.orders.get());
		
		Assert.assertEquals(true, received.bids.iterHasNext());
		
		received.bids.iterNext();
		
		Assert.assertEquals(false, received.bids.levelId.isPresent());
		Assert.assertEquals(400, received.bids.qty.get());
		
		received.bids.legs.beginIteration();
		
		Assert.assertEquals(true, received.bids.legs.iterHasNext());
		
		received.bids.legs.iterNext();
		
		Assert.assertEquals(22325, received.bids.legs.legId.get());
		Assert.assertEquals(false, received.bids.legs.legCode.isPresent());
		
		Assert.assertEquals(true, received.bids.legs.iterHasNext());
		
		received.bids.legs.iterNext();
		
		Assert.assertEquals(22326, received.bids.legs.legId.get());
		Assert.assertEquals(false, received.bids.legs.legCode.isPresent());
		
		Assert.assertEquals(false, received.bids.legs.iterHasNext());
		
		Assert.assertEquals(2, received.bids.orders.get());
		
		Assert.assertEquals(false, received.bids.iterHasNext());
		
		bb.clear();
		
		received.writeAscii(true, bb);
		
		bb.flip();
		
		Assert.assertEquals("AF|Y|6123424243345|2=[1212,200,2=[22321,332;22322,BLANK],3;BLANK,400,2=[22325,BLANK;22326,BLANK],2]", ByteBufferUtils.parseString(bb));

		bb.clear();
		
		received.writeAscii(false, bb);
		
		bb.flip();
		
		Assert.assertEquals("AF (RepeatingGroupProtoMessage)|Y|6123424243345|2=[1212,200,2=[22321,332;22322,BLANK],3;BLANK,400,2=[22325,BLANK;22326,BLANK],2]", ByteBufferUtils.parseString(bb));
	}
	
}
