/* 
 * Copyright 2015-2024 (c) CoralBlocks LLC - http://www.coralblocks.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package com.coralblocks.coralproto.example;

import java.io.IOException;

import com.coralblocks.coralproto.AbstractProto;
import com.coralblocks.coralproto.IDL;
import com.coralblocks.coralproto.field.BooleanField;
import com.coralblocks.coralproto.field.LongField;
import com.coralblocks.coralproto.field.SubtypeField;
import com.coralblocks.coralproto.field.TypeField;
import com.coralblocks.coralproto.field.VarCharsField;

public class ProtoMessage2 extends AbstractProto {
	
	private static final String TEXT = """
			
			TYPE = P
			SUBTYPE = B
			
			orderId: long
			symbolDesc: varchars(128)!
			isMine: boolean!
	""";
	
	public static void main(String[] args) throws IOException {
		IDL idl = new IDL(TEXT);
		String filePath = "src/main/java/com/coralblocks/coralproto/example/" + ProtoMessage2.class.getSimpleName() + ".java";
		String sourceCode = idl.getCode();
		IDL.replaceAutoGeneratedCode(filePath, sourceCode);
	}

	// Auto-generated code. Do not edit or change anything below here
	
	// BEGIN_AUTO_GENERATED_CODE

    public static final char TYPE = 'P';
    public static final char SUBTYPE = 'B';

    public final TypeField typeField = new TypeField(this, TYPE);
    public final SubtypeField subtypeField = new SubtypeField(this, SUBTYPE);

    public final LongField orderId = new LongField(this);

    public final VarCharsField symbolDesc = new VarCharsField(this, 128, true);

    public final BooleanField isMine = new BooleanField(this, true);


	// END_AUTO_GENERATED_CODE

}
