/* 
 * Copyright 2015-2024 (c) CoralBlocks LLC - http://www.coralblocks.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package com.coralblocks.coralproto.example;

import java.io.IOException;

import com.coralblocks.coralproto.AbstractProto;
import com.coralblocks.coralproto.IDL;
import com.coralblocks.coralproto.field.BooleanField;
import com.coralblocks.coralproto.field.CharsField;
import com.coralblocks.coralproto.field.DoubleField;
import com.coralblocks.coralproto.field.GroupField;
import com.coralblocks.coralproto.field.IntField;
import com.coralblocks.coralproto.field.LongField;
import com.coralblocks.coralproto.field.ProtoField;
import com.coralblocks.coralproto.field.RepeatingGroupField;
import com.coralblocks.coralproto.field.SubtypeField;
import com.coralblocks.coralproto.field.TypeField;
import com.coralblocks.coralproto.field.VarCharsField;

public class PriceChangeMessage extends AbstractProto {
	
	private static final String TEXT = """
			
		  TYPE = P
		  SUBTYPE = C
		  
		  symbolId: long
		  symbolDesc: varchars(128)
		  mqReqId: long!
		  
		  orders:
		      side: boolean
		      levelId: long!
		      priceLevel: double
		      qty: int
		      legs:
		        legId: int
		        legDesc: chars(8)!
		      orderId: long
		  
		  lastTradeQty: long!
		  lastTradePrice: double!
			
	""";
	
	public static void main(String[] args) throws IOException {
		IDL idl = new IDL(TEXT, IDL.INDENT + IDL.INDENT);
		String filePath = "src/main/java/com/coralblocks/coralproto/example/" + PriceChangeMessage.class.getSimpleName() + ".java";
		String sourceCode = idl.getCode();
		IDL.replaceAutoGeneratedCode(filePath, sourceCode);
	}

	// Auto-generated code. Do not edit or change anything below here
	
	// BEGIN_AUTO_GENERATED_CODE

        public static final char TYPE = 'P';
        public static final char SUBTYPE = 'C';

        public final TypeField typeField = new TypeField(this, TYPE);
        public final SubtypeField subtypeField = new SubtypeField(this, SUBTYPE);

        public final LongField symbolId = new LongField(this);

        public final VarCharsField symbolDesc = new VarCharsField(this, 128);

        public final LongField mqReqId = new LongField(this, true);

        public static class OrdersRepeatingGroup extends RepeatingGroupField {

            public BooleanField side;

            public LongField levelId;

            public DoubleField priceLevel;

            public IntField qty;

            public static class LegsRepeatingGroup extends RepeatingGroupField {

                public IntField legId;

                public CharsField legDesc;

                public LegsRepeatingGroup(AbstractProto proto) {
                    this(proto, new IntField(), new CharsField(8, true));
                }

                public LegsRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
                    super(proto, protoFields);
                }

                @Override
                public GroupField nextElement() {
                    GroupField groupField = super.nextElement();
                    this.legId = (IntField) groupField.internalArray()[0];
                    this.legDesc = (CharsField) groupField.internalArray()[1];
                    return groupField;
                } 

                @Override
                public GroupField iterNext() {
                    GroupField groupField = super.iterNext();
                    if (groupField != null) {
                        this.legId = (IntField) groupField.internalArray()[0];
                        this.legDesc = (CharsField) groupField.internalArray()[1];
                    }
                    return groupField;
                } 

                @Override
                protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
                    return new OrdersRepeatingGroup.LegsRepeatingGroup(null, protoFields);
                } 

            }

            public OrdersRepeatingGroup.LegsRepeatingGroup legs;

            public LongField orderId;

            public OrdersRepeatingGroup(AbstractProto proto) {
                this(proto, new BooleanField(), new LongField(true), new DoubleField(), new IntField(), new OrdersRepeatingGroup.LegsRepeatingGroup(null), new LongField());
            }

            public OrdersRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
                super(proto, protoFields);
            }

            @Override
            public GroupField nextElement() {
                GroupField groupField = super.nextElement();
                this.side = (BooleanField) groupField.internalArray()[0];
                this.levelId = (LongField) groupField.internalArray()[1];
                this.priceLevel = (DoubleField) groupField.internalArray()[2];
                this.qty = (IntField) groupField.internalArray()[3];
                this.legs = (OrdersRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[4];
                this.orderId = (LongField) groupField.internalArray()[5];
                return groupField;
            } 

            @Override
            public GroupField iterNext() {
                GroupField groupField = super.iterNext();
                if (groupField != null) {
                    this.side = (BooleanField) groupField.internalArray()[0];
                    this.levelId = (LongField) groupField.internalArray()[1];
                    this.priceLevel = (DoubleField) groupField.internalArray()[2];
                    this.qty = (IntField) groupField.internalArray()[3];
                    this.legs = (OrdersRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[4];
                    this.orderId = (LongField) groupField.internalArray()[5];
                }
                return groupField;
            } 

            @Override
            protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
                return new OrdersRepeatingGroup(null, protoFields);
            } 

        }

        public final OrdersRepeatingGroup orders = new OrdersRepeatingGroup(this);

        public final LongField lastTradeQty = new LongField(this, true);

        public final DoubleField lastTradePrice = new DoubleField(this, true);


	// END_AUTO_GENERATED_CODE

}
