/* 
 * Copyright 2015-2024 (c) CoralBlocks LLC - http://www.coralblocks.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package com.coralblocks.coralproto.example;

import java.io.IOException;

import com.coralblocks.coralproto.AbstractProto;
import com.coralblocks.coralproto.IDL;
import com.coralblocks.coralproto.field.GroupField;
import com.coralblocks.coralproto.field.IntField;
import com.coralblocks.coralproto.field.LongField;
import com.coralblocks.coralproto.field.ProtoField;
import com.coralblocks.coralproto.field.RepeatingGroupField;
import com.coralblocks.coralproto.field.SubtypeField;
import com.coralblocks.coralproto.field.TypeField;
import com.coralblocks.coralproto.field.VarCharsField;

public class MarketDataMessage extends AbstractProto {
	
	private static final String TEXT = """
			
			TYPE = P
			SUBTYPE = M
			
			symbolId: long
			symbolDesc: varchars(128)
			mqReqId: long!
			
			bids:
			    levelId: long!
			    priceLevel: long
			    qty: int
			    legs:
			      legId: int
			      legDesc: varchars(128)!
			    orders: int
			
			asks:
			    levelId: long!
			    priceLevel: long
			    qty: int
			    legs:
			      legId: int
			      legDesc: varchars(128)!
			    orders: int
			
			lastTradeQty: long!
			lastTradePrice: long!
			
	""";
	
	public static void main(String[] args) throws IOException {
		IDL idl = new IDL(TEXT);
		String filePath = "src/main/java/com/coralblocks/coralproto/example/" + MarketDataMessage.class.getSimpleName() + ".java";
		String sourceCode = idl.getCode();
		IDL.replaceAutoGeneratedCode(filePath, sourceCode);
	}

	// Auto-generated code. Do not edit or change anything below here
	
	// BEGIN_AUTO_GENERATED_CODE

    public static final char TYPE = 'P';
    public static final char SUBTYPE = 'M';

    public final TypeField typeField = new TypeField(this, TYPE);
    public final SubtypeField subtypeField = new SubtypeField(this, SUBTYPE);

    public final LongField symbolId = new LongField(this);

    public final VarCharsField symbolDesc = new VarCharsField(this, 128);

    public final LongField mqReqId = new LongField(this, true);

    public static class BidsRepeatingGroup extends RepeatingGroupField {

        public LongField levelId;

        public LongField priceLevel;

        public IntField qty;

        public static class LegsRepeatingGroup extends RepeatingGroupField {

            public IntField legId;

            public VarCharsField legDesc;

            public LegsRepeatingGroup(AbstractProto proto) {
                this(proto, new IntField(), new VarCharsField(128, true));
            }

            public LegsRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
                super(proto, protoFields);
            }

            @Override
            public GroupField nextElement() {
                GroupField groupField = super.nextElement();
                this.legId = (IntField) groupField.internalArray()[0];
                this.legDesc = (VarCharsField) groupField.internalArray()[1];
                return groupField;
            } 

            @Override
            public GroupField iterNext() {
                GroupField groupField = super.iterNext();
                if (groupField != null) {
                    this.legId = (IntField) groupField.internalArray()[0];
                    this.legDesc = (VarCharsField) groupField.internalArray()[1];
                }
                return groupField;
            } 

            @Override
            protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
                return new BidsRepeatingGroup.LegsRepeatingGroup(null, protoFields);
            } 

        }

        public BidsRepeatingGroup.LegsRepeatingGroup legs;

        public IntField orders;

        public BidsRepeatingGroup(AbstractProto proto) {
            this(proto, new LongField(true), new LongField(), new IntField(), new BidsRepeatingGroup.LegsRepeatingGroup(null), new IntField());
        }

        public BidsRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
            super(proto, protoFields);
        }

        @Override
        public GroupField nextElement() {
            GroupField groupField = super.nextElement();
            this.levelId = (LongField) groupField.internalArray()[0];
            this.priceLevel = (LongField) groupField.internalArray()[1];
            this.qty = (IntField) groupField.internalArray()[2];
            this.legs = (BidsRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[3];
            this.orders = (IntField) groupField.internalArray()[4];
            return groupField;
        } 

        @Override
        public GroupField iterNext() {
            GroupField groupField = super.iterNext();
            if (groupField != null) {
                this.levelId = (LongField) groupField.internalArray()[0];
                this.priceLevel = (LongField) groupField.internalArray()[1];
                this.qty = (IntField) groupField.internalArray()[2];
                this.legs = (BidsRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[3];
                this.orders = (IntField) groupField.internalArray()[4];
            }
            return groupField;
        } 

        @Override
        protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
            return new BidsRepeatingGroup(null, protoFields);
        } 

    }

    public final BidsRepeatingGroup bids = new BidsRepeatingGroup(this);

    public static class AsksRepeatingGroup extends RepeatingGroupField {

        public LongField levelId;

        public LongField priceLevel;

        public IntField qty;

        public static class LegsRepeatingGroup extends RepeatingGroupField {

            public IntField legId;

            public VarCharsField legDesc;

            public LegsRepeatingGroup(AbstractProto proto) {
                this(proto, new IntField(), new VarCharsField(128, true));
            }

            public LegsRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
                super(proto, protoFields);
            }

            @Override
            public GroupField nextElement() {
                GroupField groupField = super.nextElement();
                this.legId = (IntField) groupField.internalArray()[0];
                this.legDesc = (VarCharsField) groupField.internalArray()[1];
                return groupField;
            } 

            @Override
            public GroupField iterNext() {
                GroupField groupField = super.iterNext();
                if (groupField != null) {
                    this.legId = (IntField) groupField.internalArray()[0];
                    this.legDesc = (VarCharsField) groupField.internalArray()[1];
                }
                return groupField;
            } 

            @Override
            protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
                return new AsksRepeatingGroup.LegsRepeatingGroup(null, protoFields);
            } 

        }

        public AsksRepeatingGroup.LegsRepeatingGroup legs;

        public IntField orders;

        public AsksRepeatingGroup(AbstractProto proto) {
            this(proto, new LongField(true), new LongField(), new IntField(), new AsksRepeatingGroup.LegsRepeatingGroup(null), new IntField());
        }

        public AsksRepeatingGroup(AbstractProto proto, ProtoField ... protoFields) {
            super(proto, protoFields);
        }

        @Override
        public GroupField nextElement() {
            GroupField groupField = super.nextElement();
            this.levelId = (LongField) groupField.internalArray()[0];
            this.priceLevel = (LongField) groupField.internalArray()[1];
            this.qty = (IntField) groupField.internalArray()[2];
            this.legs = (AsksRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[3];
            this.orders = (IntField) groupField.internalArray()[4];
            return groupField;
        } 

        @Override
        public GroupField iterNext() {
            GroupField groupField = super.iterNext();
            if (groupField != null) {
                this.levelId = (LongField) groupField.internalArray()[0];
                this.priceLevel = (LongField) groupField.internalArray()[1];
                this.qty = (IntField) groupField.internalArray()[2];
                this.legs = (AsksRepeatingGroup.LegsRepeatingGroup) groupField.internalArray()[3];
                this.orders = (IntField) groupField.internalArray()[4];
            }
            return groupField;
        } 

        @Override
        protected final RepeatingGroupField newInstance(ProtoField[] protoFields) {
            return new AsksRepeatingGroup(null, protoFields);
        } 

    }

    public final AsksRepeatingGroup asks = new AsksRepeatingGroup(this);

    public final LongField lastTradeQty = new LongField(this, true);

    public final LongField lastTradePrice = new LongField(this, true);


	// END_AUTO_GENERATED_CODE

}
