# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.

from .aws import Action as BaseAction
from .aws import BaseARN

service_name = "AWS IoT"
prefix = "iot"


class Action(BaseAction):
    def __init__(self, action: str = None) -> None:
        super().__init__(prefix, action)


class ARN(BaseARN):
    def __init__(self, resource: str = "", region: str = "", account: str = "") -> None:
        super().__init__(
            service=prefix, resource=resource, region=region, account=account
        )


AcceptCertificateTransfer = Action("AcceptCertificateTransfer")
AddThingToBillingGroup = Action("AddThingToBillingGroup")
AddThingToThingGroup = Action("AddThingToThingGroup")
AssociateTargetsWithJob = Action("AssociateTargetsWithJob")
AttachPolicy = Action("AttachPolicy")
AttachPrincipalPolicy = Action("AttachPrincipalPolicy")
AttachSecurityProfile = Action("AttachSecurityProfile")
AttachThingPrincipal = Action("AttachThingPrincipal")
CancelAuditMitigationActionsTask = Action("CancelAuditMitigationActionsTask")
CancelAuditTask = Action("CancelAuditTask")
CancelCertificateTransfer = Action("CancelCertificateTransfer")
CancelDetectMitigationActionsTask = Action("CancelDetectMitigationActionsTask")
CancelJob = Action("CancelJob")
CancelJobExecution = Action("CancelJobExecution")
ClearDefaultAuthorizer = Action("ClearDefaultAuthorizer")
CloseTunnel = Action("CloseTunnel")
ConfirmTopicRuleDestination = Action("ConfirmTopicRuleDestination")
Connect = Action("Connect")
CreateAuditSuppression = Action("CreateAuditSuppression")
CreateAuthorizer = Action("CreateAuthorizer")
CreateBillingGroup = Action("CreateBillingGroup")
CreateCertificateFromCsr = Action("CreateCertificateFromCsr")
CreateCustomMetric = Action("CreateCustomMetric")
CreateDimension = Action("CreateDimension")
CreateDomainConfiguration = Action("CreateDomainConfiguration")
CreateDynamicThingGroup = Action("CreateDynamicThingGroup")
CreateFleetMetric = Action("CreateFleetMetric")
CreateJob = Action("CreateJob")
CreateJobTemplate = Action("CreateJobTemplate")
CreateKeysAndCertificate = Action("CreateKeysAndCertificate")
CreateMitigationAction = Action("CreateMitigationAction")
CreateOTAUpdate = Action("CreateOTAUpdate")
CreateOTAUpdateJob = Action("CreateOTAUpdateJob")
CreatePolicy = Action("CreatePolicy")
CreatePolicyVersion = Action("CreatePolicyVersion")
CreateProvisioningClaim = Action("CreateProvisioningClaim")
CreateProvisioningTemplate = Action("CreateProvisioningTemplate")
CreateProvisioningTemplateVersion = Action("CreateProvisioningTemplateVersion")
CreateRoleAlias = Action("CreateRoleAlias")
CreateScheduledAudit = Action("CreateScheduledAudit")
CreateSecurityProfile = Action("CreateSecurityProfile")
CreateStream = Action("CreateStream")
CreateThing = Action("CreateThing")
CreateThingGroup = Action("CreateThingGroup")
CreateThingType = Action("CreateThingType")
CreateTopicRule = Action("CreateTopicRule")
CreateTopicRuleDestination = Action("CreateTopicRuleDestination")
DeleteAccountAuditConfiguration = Action("DeleteAccountAuditConfiguration")
DeleteAuditSuppression = Action("DeleteAuditSuppression")
DeleteAuthorizer = Action("DeleteAuthorizer")
DeleteBillingGroup = Action("DeleteBillingGroup")
DeleteCACertificate = Action("DeleteCACertificate")
DeleteCertificate = Action("DeleteCertificate")
DeleteCustomMetric = Action("DeleteCustomMetric")
DeleteDimension = Action("DeleteDimension")
DeleteDomainConfiguration = Action("DeleteDomainConfiguration")
DeleteDynamicThingGroup = Action("DeleteDynamicThingGroup")
DeleteFleetMetric = Action("DeleteFleetMetric")
DeleteJob = Action("DeleteJob")
DeleteJobExecution = Action("DeleteJobExecution")
DeleteJobTemplate = Action("DeleteJobTemplate")
DeleteMitigationAction = Action("DeleteMitigationAction")
DeleteOTAUpdate = Action("DeleteOTAUpdate")
DeleteOTAUpdateJob = Action("DeleteOTAUpdateJob")
DeletePolicy = Action("DeletePolicy")
DeletePolicyVersion = Action("DeletePolicyVersion")
DeleteProvisioningTemplate = Action("DeleteProvisioningTemplate")
DeleteProvisioningTemplateVersion = Action("DeleteProvisioningTemplateVersion")
DeleteRegistrationCode = Action("DeleteRegistrationCode")
DeleteRoleAlias = Action("DeleteRoleAlias")
DeleteScheduledAudit = Action("DeleteScheduledAudit")
DeleteSecurityProfile = Action("DeleteSecurityProfile")
DeleteStream = Action("DeleteStream")
DeleteThing = Action("DeleteThing")
DeleteThingGroup = Action("DeleteThingGroup")
DeleteThingShadow = Action("DeleteThingShadow")
DeleteThingType = Action("DeleteThingType")
DeleteTopicRule = Action("DeleteTopicRule")
DeleteTopicRuleDestination = Action("DeleteTopicRuleDestination")
DeleteV2LoggingLevel = Action("DeleteV2LoggingLevel")
DeprecateThingType = Action("DeprecateThingType")
DescribeAccountAuditConfiguration = Action("DescribeAccountAuditConfiguration")
DescribeAuditFinding = Action("DescribeAuditFinding")
DescribeAuditMitigationActionsTask = Action("DescribeAuditMitigationActionsTask")
DescribeAuditSuppression = Action("DescribeAuditSuppression")
DescribeAuditTask = Action("DescribeAuditTask")
DescribeAuthorizer = Action("DescribeAuthorizer")
DescribeBillingGroup = Action("DescribeBillingGroup")
DescribeCACertificate = Action("DescribeCACertificate")
DescribeCertificate = Action("DescribeCertificate")
DescribeCustomMetric = Action("DescribeCustomMetric")
DescribeDefaultAuthorizer = Action("DescribeDefaultAuthorizer")
DescribeDetectMitigationActionsTask = Action("DescribeDetectMitigationActionsTask")
DescribeDimension = Action("DescribeDimension")
DescribeDomainConfiguration = Action("DescribeDomainConfiguration")
DescribeEndpoint = Action("DescribeEndpoint")
DescribeEventConfigurations = Action("DescribeEventConfigurations")
DescribeFleetMetric = Action("DescribeFleetMetric")
DescribeIndex = Action("DescribeIndex")
DescribeJob = Action("DescribeJob")
DescribeJobExecution = Action("DescribeJobExecution")
DescribeJobTemplate = Action("DescribeJobTemplate")
DescribeManagedJobTemplate = Action("DescribeManagedJobTemplate")
DescribeMitigationAction = Action("DescribeMitigationAction")
DescribeProvisioningTemplate = Action("DescribeProvisioningTemplate")
DescribeProvisioningTemplateVersion = Action("DescribeProvisioningTemplateVersion")
DescribeRoleAlias = Action("DescribeRoleAlias")
DescribeScheduledAudit = Action("DescribeScheduledAudit")
DescribeSecurityProfile = Action("DescribeSecurityProfile")
DescribeStream = Action("DescribeStream")
DescribeThing = Action("DescribeThing")
DescribeThingGroup = Action("DescribeThingGroup")
DescribeThingRegistrationTask = Action("DescribeThingRegistrationTask")
DescribeThingType = Action("DescribeThingType")
DescribeTunnel = Action("DescribeTunnel")
DetachPolicy = Action("DetachPolicy")
DetachPrincipalPolicy = Action("DetachPrincipalPolicy")
DetachSecurityProfile = Action("DetachSecurityProfile")
DetachThingPrincipal = Action("DetachThingPrincipal")
DisableTopicRule = Action("DisableTopicRule")
EnableTopicRule = Action("EnableTopicRule")
GetBehaviorModelTrainingSummaries = Action("GetBehaviorModelTrainingSummaries")
GetBucketsAggregation = Action("GetBucketsAggregation")
GetCardinality = Action("GetCardinality")
GetEffectivePolicies = Action("GetEffectivePolicies")
GetIndexingConfiguration = Action("GetIndexingConfiguration")
GetJobDocument = Action("GetJobDocument")
GetLoggingOptions = Action("GetLoggingOptions")
GetOTAUpdate = Action("GetOTAUpdate")
GetOTAUpdateJob = Action("GetOTAUpdateJob")
GetPendingJobExecutions = Action("GetPendingJobExecutions")
GetPercentiles = Action("GetPercentiles")
GetPolicy = Action("GetPolicy")
GetPolicyVersion = Action("GetPolicyVersion")
GetRegistrationCode = Action("GetRegistrationCode")
GetRetainedMessage = Action("GetRetainedMessage")
GetStatistics = Action("GetStatistics")
GetThingShadow = Action("GetThingShadow")
GetTopicRule = Action("GetTopicRule")
GetTopicRuleDestination = Action("GetTopicRuleDestination")
GetV2LoggingOptions = Action("GetV2LoggingOptions")
ListActiveViolations = Action("ListActiveViolations")
ListAttachedPolicies = Action("ListAttachedPolicies")
ListAuditFindings = Action("ListAuditFindings")
ListAuditMitigationActionsExecutions = Action("ListAuditMitigationActionsExecutions")
ListAuditMitigationActionsTasks = Action("ListAuditMitigationActionsTasks")
ListAuditSuppressions = Action("ListAuditSuppressions")
ListAuditTasks = Action("ListAuditTasks")
ListAuthorizers = Action("ListAuthorizers")
ListBillingGroups = Action("ListBillingGroups")
ListCACertificates = Action("ListCACertificates")
ListCertificates = Action("ListCertificates")
ListCertificatesByCA = Action("ListCertificatesByCA")
ListCustomMetrics = Action("ListCustomMetrics")
ListDetectMitigationActionsExecutions = Action("ListDetectMitigationActionsExecutions")
ListDetectMitigationActionsTasks = Action("ListDetectMitigationActionsTasks")
ListDimensions = Action("ListDimensions")
ListDomainConfigurations = Action("ListDomainConfigurations")
ListFleetMetrics = Action("ListFleetMetrics")
ListIndices = Action("ListIndices")
ListJobExecutionsForJob = Action("ListJobExecutionsForJob")
ListJobExecutionsForThing = Action("ListJobExecutionsForThing")
ListJobTemplates = Action("ListJobTemplates")
ListJobs = Action("ListJobs")
ListManagedJobTemplates = Action("ListManagedJobTemplates")
ListMetricValues = Action("ListMetricValues")
ListMitigationActions = Action("ListMitigationActions")
ListNamedShadowsForThing = Action("ListNamedShadowsForThing")
ListOTAUpdateJobs = Action("ListOTAUpdateJobs")
ListOTAUpdates = Action("ListOTAUpdates")
ListOutgoingCertificates = Action("ListOutgoingCertificates")
ListPolicies = Action("ListPolicies")
ListPolicyPrincipals = Action("ListPolicyPrincipals")
ListPolicyVersions = Action("ListPolicyVersions")
ListPrincipalPolicies = Action("ListPrincipalPolicies")
ListPrincipalThings = Action("ListPrincipalThings")
ListProvisioningTemplateVersions = Action("ListProvisioningTemplateVersions")
ListProvisioningTemplates = Action("ListProvisioningTemplates")
ListRetainedMessages = Action("ListRetainedMessages")
ListRoleAliases = Action("ListRoleAliases")
ListScheduledAudits = Action("ListScheduledAudits")
ListSecurityProfiles = Action("ListSecurityProfiles")
ListSecurityProfilesForTarget = Action("ListSecurityProfilesForTarget")
ListStreams = Action("ListStreams")
ListTagsForResource = Action("ListTagsForResource")
ListTargetsForPolicy = Action("ListTargetsForPolicy")
ListTargetsForSecurityProfile = Action("ListTargetsForSecurityProfile")
ListThingGroups = Action("ListThingGroups")
ListThingGroupsForThing = Action("ListThingGroupsForThing")
ListThingPrincipals = Action("ListThingPrincipals")
ListThingRegistrationTaskReports = Action("ListThingRegistrationTaskReports")
ListThingRegistrationTasks = Action("ListThingRegistrationTasks")
ListThingTypes = Action("ListThingTypes")
ListThings = Action("ListThings")
ListThingsInBillingGroup = Action("ListThingsInBillingGroup")
ListThingsInThingGroup = Action("ListThingsInThingGroup")
ListTopicRuleDestinations = Action("ListTopicRuleDestinations")
ListTopicRules = Action("ListTopicRules")
ListTunnels = Action("ListTunnels")
ListV2LoggingLevels = Action("ListV2LoggingLevels")
ListViolationEvents = Action("ListViolationEvents")
OpenTunnel = Action("OpenTunnel")
Publish = Action("Publish")
PutVerificationStateOnViolation = Action("PutVerificationStateOnViolation")
Receive = Action("Receive")
RegisterCACertificate = Action("RegisterCACertificate")
RegisterCertificate = Action("RegisterCertificate")
RegisterCertificateWithoutCA = Action("RegisterCertificateWithoutCA")
RegisterThing = Action("RegisterThing")
RejectCertificateTransfer = Action("RejectCertificateTransfer")
RemoveThingFromBillingGroup = Action("RemoveThingFromBillingGroup")
RemoveThingFromThingGroup = Action("RemoveThingFromThingGroup")
ReplaceTopicRule = Action("ReplaceTopicRule")
RetainPublish = Action("RetainPublish")
RotateTunnelAccessToken = Action("RotateTunnelAccessToken")
SearchIndex = Action("SearchIndex")
SetDefaultAuthorizer = Action("SetDefaultAuthorizer")
SetDefaultPolicyVersion = Action("SetDefaultPolicyVersion")
SetLoggingOptions = Action("SetLoggingOptions")
SetV2LoggingLevel = Action("SetV2LoggingLevel")
SetV2LoggingOptions = Action("SetV2LoggingOptions")
StartAuditMitigationActionsTask = Action("StartAuditMitigationActionsTask")
StartDetectMitigationActionsTask = Action("StartDetectMitigationActionsTask")
StartNextPendingJobExecution = Action("StartNextPendingJobExecution")
StartOnDemandAuditTask = Action("StartOnDemandAuditTask")
StartThingRegistrationTask = Action("StartThingRegistrationTask")
StopThingRegistrationTask = Action("StopThingRegistrationTask")
Subscribe = Action("Subscribe")
TagResource = Action("TagResource")
TestAuthorization = Action("TestAuthorization")
TestInvokeAuthorizer = Action("TestInvokeAuthorizer")
TransferCertificate = Action("TransferCertificate")
UntagResource = Action("UntagResource")
UpdateAccountAuditConfiguration = Action("UpdateAccountAuditConfiguration")
UpdateAuditSuppression = Action("UpdateAuditSuppression")
UpdateAuthorizer = Action("UpdateAuthorizer")
UpdateBillingGroup = Action("UpdateBillingGroup")
UpdateCACertificate = Action("UpdateCACertificate")
UpdateCertificate = Action("UpdateCertificate")
UpdateCustomMetric = Action("UpdateCustomMetric")
UpdateDimension = Action("UpdateDimension")
UpdateDomainConfiguration = Action("UpdateDomainConfiguration")
UpdateDynamicThingGroup = Action("UpdateDynamicThingGroup")
UpdateEventConfigurations = Action("UpdateEventConfigurations")
UpdateFleetMetric = Action("UpdateFleetMetric")
UpdateIndexingConfiguration = Action("UpdateIndexingConfiguration")
UpdateJob = Action("UpdateJob")
UpdateJobExecution = Action("UpdateJobExecution")
UpdateMitigationAction = Action("UpdateMitigationAction")
UpdateProvisioningTemplate = Action("UpdateProvisioningTemplate")
UpdateRoleAlias = Action("UpdateRoleAlias")
UpdateScheduledAudit = Action("UpdateScheduledAudit")
UpdateSecurityProfile = Action("UpdateSecurityProfile")
UpdateStream = Action("UpdateStream")
UpdateThing = Action("UpdateThing")
UpdateThingGroup = Action("UpdateThingGroup")
UpdateThingGroupsForThing = Action("UpdateThingGroupsForThing")
UpdateThingShadow = Action("UpdateThingShadow")
UpdateTopicRuleDestination = Action("UpdateTopicRuleDestination")
ValidateSecurityProfileBehaviors = Action("ValidateSecurityProfileBehaviors")
