# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.

from .aws import Action as BaseAction
from .aws import BaseARN

service_name = "Amazon EMR Serverless"
prefix = "emr-serverless"


class Action(BaseAction):
    def __init__(self, action: str = None) -> None:
        super().__init__(prefix, action)


class ARN(BaseARN):
    def __init__(self, resource: str = "", region: str = "", account: str = "") -> None:
        super().__init__(
            service=prefix, resource=resource, region=region, account=account
        )


CancelJobRun = Action("CancelJobRun")
CreateApplication = Action("CreateApplication")
DeleteApplication = Action("DeleteApplication")
GetApplication = Action("GetApplication")
GetDashboardForJobRun = Action("GetDashboardForJobRun")
GetJobRun = Action("GetJobRun")
ListApplications = Action("ListApplications")
ListJobRuns = Action("ListJobRuns")
ListTagsForResource = Action("ListTagsForResource")
StartApplication = Action("StartApplication")
StartJobRun = Action("StartJobRun")
StopApplication = Action("StopApplication")
TagResource = Action("TagResource")
UntagResource = Action("UntagResource")
UpdateApplication = Action("UpdateApplication")
