<!--
{% comment %}
Copyright 2018-2020 IBM Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->


## Using the Elyra Pipeline Editor

<img src="https://github.com/elyra/community/blob/master/resources/github-homepage/AIW-1.gif" width="800">

* In the Jupyter Lab Launcher, click the `Pipeline Editor` Icon to create a new pipeline.
* On left side of the screen, navigate to your file browser, you should see a list of notebooks available.
* Drag each notebook, each representing a step in your pipeline to the canvas. Repeat until all notebooks
needed for the pipeline are present.
* Define your notebook execution order by connecting them together to form a graph.

<img src="https://github.com/elyra/community/blob/master/resources/github-homepage/AIW-2.gif" width="800">

* Define the properties for each node / notebook in your pipeline

|Parameter   | Description  | Example |
|:---:|:------|:---:|
|Docker Image| The docker image you want to use to run your notebook |  `TensorFlow 2.0`   |
|Output Files|  A list of files generated by the notebook, inside the image, to be passed as inputs to the next step of the pipeline.  One file per line.  | `contributions.csv` |
|Env Vars| A list of Environmental variables to be set inside in the container.  One variable per line. |  `GITHUB_TOKEN = sometokentobeused` |
|File Dependencies|  A list of files to be passed from the `LOCAL` working environment into each respective step of the pipeline. Files should be in the same directory as the notebook it is associated with. One file per line. | `dependent-script.py` |

<img src="https://github.com/elyra/community/blob/master/resources/github-homepage/AIW-3.gif" width="800">

* Click on the `RUN` Icon and give your pipeline a name.
* Hit `OK` to start your pipeline.
* Use the link provided in the response to your experiment in Kubeflow. By default, Elyra will create the pipeline template for you as well as start an experiment and run.
## Using the Python Runner
<img src="https://github.com/elyra/community/blob/master/resources/github-homepage/AIW-4.gif" width="800">

* In the Jupyter Lab Launcher, click the `Python File` Icon to create a new Python Script.
* When used in conjunction with `Jupyter Enterprise Gateway` the dropdown will be populated with more kernel options,
allowing users to run their scripts with remote kernels with more specialized resources.
* To run your script locally, select the `python3` option in the dropdown menu, and click the `Run` Icon.

## Integration with Jupyter Enterprise Gateway

Elyra integrates easily with `Jupyter Enterprise Gateway` allowing users to deploy remote kernels for more
resource intensive development. Simply include the `--gateway-url` when starting `Elyra`

```bash
jupyter lab -gateway-url=http://<GATEWAY_HOST>:<PORT>
```

[Jupyter Enterprise Gateway Github](https://github.com/jupyter/enterprise_gateway)

[More Details](https://jupyter-notebook.readthedocs.io/en/stable/public_server.html#using-a-gateway-server-for-kernel-management)
