// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package pb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// LocalRouterClient is the client API for LocalRouter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LocalRouterClient interface {
	// Route method routes a stanza to a local available resource.
	Route(ctx context.Context, in *LocalRouteRequest, opts ...grpc.CallOption) (*LocalRouteResponse, error)
	// Disconnect performs disconnection over a local available resource.
	Disconnect(ctx context.Context, in *LocalDisconnectRequest, opts ...grpc.CallOption) (*LocalDisconnectResponse, error)
}

type localRouterClient struct {
	cc grpc.ClientConnInterface
}

func NewLocalRouterClient(cc grpc.ClientConnInterface) LocalRouterClient {
	return &localRouterClient{cc}
}

func (c *localRouterClient) Route(ctx context.Context, in *LocalRouteRequest, opts ...grpc.CallOption) (*LocalRouteResponse, error) {
	out := new(LocalRouteResponse)
	err := c.cc.Invoke(ctx, "/cluster.v1.LocalRouter/Route", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localRouterClient) Disconnect(ctx context.Context, in *LocalDisconnectRequest, opts ...grpc.CallOption) (*LocalDisconnectResponse, error) {
	out := new(LocalDisconnectResponse)
	err := c.cc.Invoke(ctx, "/cluster.v1.LocalRouter/Disconnect", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LocalRouterServer is the server API for LocalRouter service.
// All implementations must embed UnimplementedLocalRouterServer
// for forward compatibility
type LocalRouterServer interface {
	// Route method routes a stanza to a local available resource.
	Route(context.Context, *LocalRouteRequest) (*LocalRouteResponse, error)
	// Disconnect performs disconnection over a local available resource.
	Disconnect(context.Context, *LocalDisconnectRequest) (*LocalDisconnectResponse, error)
	mustEmbedUnimplementedLocalRouterServer()
}

// UnimplementedLocalRouterServer must be embedded to have forward compatible implementations.
type UnimplementedLocalRouterServer struct {
}

func (UnimplementedLocalRouterServer) Route(context.Context, *LocalRouteRequest) (*LocalRouteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Route not implemented")
}
func (UnimplementedLocalRouterServer) Disconnect(context.Context, *LocalDisconnectRequest) (*LocalDisconnectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Disconnect not implemented")
}
func (UnimplementedLocalRouterServer) mustEmbedUnimplementedLocalRouterServer() {}

// UnsafeLocalRouterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LocalRouterServer will
// result in compilation errors.
type UnsafeLocalRouterServer interface {
	mustEmbedUnimplementedLocalRouterServer()
}

func RegisterLocalRouterServer(s grpc.ServiceRegistrar, srv LocalRouterServer) {
	s.RegisterService(&LocalRouter_ServiceDesc, srv)
}

func _LocalRouter_Route_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LocalRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalRouterServer).Route(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cluster.v1.LocalRouter/Route",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalRouterServer).Route(ctx, req.(*LocalRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalRouter_Disconnect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LocalDisconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalRouterServer).Disconnect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cluster.v1.LocalRouter/Disconnect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalRouterServer).Disconnect(ctx, req.(*LocalDisconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LocalRouter_ServiceDesc is the grpc.ServiceDesc for LocalRouter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LocalRouter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "cluster.v1.LocalRouter",
	HandlerType: (*LocalRouterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Route",
			Handler:    _LocalRouter_Route_Handler,
		},
		{
			MethodName: "Disconnect",
			Handler:    _LocalRouter_Disconnect_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/cluster/v1/cluster.proto",
}

// ComponentRouterClient is the client API for ComponentRouter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ComponentRouterClient interface {
	// Route method routes a stanza to a local registered component.
	Route(ctx context.Context, in *ComponentRouteRequest, opts ...grpc.CallOption) (*ComponentRouteResponse, error)
}

type componentRouterClient struct {
	cc grpc.ClientConnInterface
}

func NewComponentRouterClient(cc grpc.ClientConnInterface) ComponentRouterClient {
	return &componentRouterClient{cc}
}

func (c *componentRouterClient) Route(ctx context.Context, in *ComponentRouteRequest, opts ...grpc.CallOption) (*ComponentRouteResponse, error) {
	out := new(ComponentRouteResponse)
	err := c.cc.Invoke(ctx, "/cluster.v1.ComponentRouter/Route", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ComponentRouterServer is the server API for ComponentRouter service.
// All implementations must embed UnimplementedComponentRouterServer
// for forward compatibility
type ComponentRouterServer interface {
	// Route method routes a stanza to a local registered component.
	Route(context.Context, *ComponentRouteRequest) (*ComponentRouteResponse, error)
	mustEmbedUnimplementedComponentRouterServer()
}

// UnimplementedComponentRouterServer must be embedded to have forward compatible implementations.
type UnimplementedComponentRouterServer struct {
}

func (UnimplementedComponentRouterServer) Route(context.Context, *ComponentRouteRequest) (*ComponentRouteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Route not implemented")
}
func (UnimplementedComponentRouterServer) mustEmbedUnimplementedComponentRouterServer() {}

// UnsafeComponentRouterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ComponentRouterServer will
// result in compilation errors.
type UnsafeComponentRouterServer interface {
	mustEmbedUnimplementedComponentRouterServer()
}

func RegisterComponentRouterServer(s grpc.ServiceRegistrar, srv ComponentRouterServer) {
	s.RegisterService(&ComponentRouter_ServiceDesc, srv)
}

func _ComponentRouter_Route_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComponentRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComponentRouterServer).Route(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cluster.v1.ComponentRouter/Route",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComponentRouterServer).Route(ctx, req.(*ComponentRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ComponentRouter_ServiceDesc is the grpc.ServiceDesc for ComponentRouter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ComponentRouter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "cluster.v1.ComponentRouter",
	HandlerType: (*ComponentRouterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Route",
			Handler:    _ComponentRouter_Route_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/cluster/v1/cluster.proto",
}
