/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonPointerEvaluator;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONObject;

class ReferenceLookup {
    private LoadingState ls;
    private SchemaClient httpClient;

    @Deprecated
    static JSONObject extend(JSONObject additional, JSONObject original) {
        return new JSONObject(ReferenceLookup.extend(OrgJsonUtil.toMap(additional), OrgJsonUtil.toMap(original)));
    }

    static Map<String, Object> extend(Map<String, Object> additional, Map<String, Object> original) {
        if (additional.keySet().isEmpty()) {
            return original;
        }
        if (original.keySet().isEmpty()) {
            return additional;
        }
        HashMap<String, Object> rawObj = new HashMap<String, Object>();
        original.forEach(rawObj::put);
        additional.forEach(rawObj::put);
        return rawObj;
    }

    public ReferenceLookup(LoadingState ls) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.httpClient = ls.config.httpClient;
    }

    private Map<String, Object> doExtend(Map<String, Object> additional, Map<String, Object> original) {
        if (this.ls.specVersion() == SpecificationVersion.DRAFT_4) {
            return ReferenceLookup.extend(additional, original);
        }
        return original;
    }

    static URI withoutFragment(String fullUri) {
        int hashmarkIdx = fullUri.indexOf(35);
        String rval = hashmarkIdx == -1 ? fullUri : fullUri.substring(0, hashmarkIdx);
        try {
            return new URI(rval);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, Object> withoutRef(JsonObject original) {
        HashMap<String, Object> rawObj = new HashMap<String, Object>();
        original.keySet().stream().filter(name -> !"$ref".equals(name)).forEach(name -> rawObj.put((String)name, original.get((String)name)));
        return rawObj;
    }

    private JsonObject lookupObjById(JsonValue val, String idAttrVal) {
        block4: {
            block3: {
                if (!(val instanceof JsonObject)) break block3;
                JsonObject obj = (JsonObject)val;
                if (obj.containsKey("$id") && obj.require("$id").requireString().equals(idAttrVal)) {
                    return obj;
                }
                for (String key : obj.keySet()) {
                    JsonObject maybeFound = this.lookupObjById(obj.require(key), idAttrVal);
                    if (maybeFound == null) continue;
                    return maybeFound;
                }
                break block4;
            }
            if (!(val instanceof JsonArray)) break block4;
            JsonArray arr = (JsonArray)val;
            for (int i = 0; i < arr.length(); ++i) {
                JsonObject maybeFound = this.lookupObjById(arr.at(i), idAttrVal);
                if (maybeFound == null) continue;
                return maybeFound;
            }
        }
        return null;
    }

    private Schema.Builder<?> performQueryEvaluation(String mapKey, JsonPointerEvaluator pointerEvaluator) {
        String absolutePointer = ReferenceResolver.resolve(this.ls.id, mapKey).toString();
        if (this.ls.pointerSchemas.containsKey(absolutePointer)) {
            return this.ls.pointerSchemas.get(absolutePointer);
        }
        JsonValue rawInternalReferenced = pointerEvaluator.query().getQueryResult();
        ReferenceSchema.Builder refBuilder = ReferenceSchema.builder().refValue(mapKey);
        this.ls.pointerSchemas.put(absolutePointer, refBuilder);
        Object referredSchema = new SchemaLoader(rawInternalReferenced.ls).load().build();
        refBuilder.build().setReferredSchema((Schema)referredSchema);
        return refBuilder;
    }

    Schema.Builder<?> lookup(String relPointerString, JsonObject ctx) {
        if (this.isSameDocumentRef(relPointerString)) {
            return this.performQueryEvaluation(relPointerString, JsonPointerEvaluator.forDocument(this.ls.rootSchemaJson(), relPointerString));
        }
        String absPointerString = ReferenceResolver.resolve(this.ls.id, relPointerString).toString();
        if (this.ls.pointerSchemas.containsKey(absPointerString)) {
            return this.ls.pointerSchemas.get(absPointerString);
        }
        JsonObject rawInternalRefereced = this.lookupObjById(this.ls.rootSchemaJson, absPointerString);
        if (rawInternalRefereced != null) {
            ReferenceSchema.Builder refBuilder = ReferenceSchema.builder().refValue(relPointerString);
            this.ls.pointerSchemas.put(absPointerString, refBuilder);
            Object referredSchema = new SchemaLoader(rawInternalRefereced.ls).load().build();
            refBuilder.build().setReferredSchema((Schema)referredSchema);
            return refBuilder;
        }
        boolean isInternal = this.isSameDocumentRef(absPointerString);
        JsonPointerEvaluator pointer = isInternal ? JsonPointerEvaluator.forDocument(this.ls.rootSchemaJson(), absPointerString) : JsonPointerEvaluator.forURL(this.httpClient, absPointerString, this.ls);
        ReferenceSchema.Builder refBuilder = ReferenceSchema.builder().refValue(relPointerString);
        this.ls.pointerSchemas.put(absPointerString, refBuilder);
        JsonPointerEvaluator.QueryResult result = pointer.query();
        SchemaLoader childLoader = this.ls.initChildLoader().resolutionScope(!isInternal ? ReferenceLookup.withoutFragment(absPointerString) : this.ls.id).schemaJson(result.getQueryResult()).rootSchemaJson(result.getContainingDocument()).build();
        Object referredSchema = childLoader.load().build();
        refBuilder.build().setReferredSchema((Schema)referredSchema);
        return refBuilder;
    }

    private boolean isSameDocumentRef(String ref) {
        return ref.startsWith("#");
    }
}

