/*
 * #%L
 * gitools-ui-app
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.app.heatmap.header.wizard.coloredlabels;

import org.gitools.heatmap.header.HeatmapColoredLabelsHeader;
import org.gitools.ui.core.utils.FontUtils;
import org.gitools.ui.platform.dialog.FontChooserDialog;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ColoredLabelsConfigPage extends AbstractWizardPage {

    private HeatmapColoredLabelsHeader header;

    private Font labelFont;

    public ColoredLabelsConfigPage() {
        this(new HeatmapColoredLabelsHeader(null));
    }

    /**
     * Creates new form ColoredClustersConfigPage
     */
    public ColoredLabelsConfigPage(HeatmapColoredLabelsHeader header) {
        super();

        this.header = header;

        initComponents();

        labelVisibleChk.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                labelVisibleChanged();
            }
        });

        forceLabelColorChk.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                labelVisibleChanged();
            }
        });

        labelFontBtn.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                selectFont();
            }
        });

        setTitle("Header configuration");
        setComplete(true);
    }

    @Override
    public void updateControls() {
        super.updateControls();

        titleField.setText(header.getTitle());
        marginSpin.setValue(header.getMargin());
        separationGridChk.setSelected(header.isSeparationGrid());

        labelVisibleChk.setSelected(header.isLabelVisible());
        labelFont = header.getLabelFont();
        fontChanged();
        labelRotatedChk.setSelected(header.isLabelRotated());
        forceLabelColorChk.setSelected(header.isForceLabelColor());
        labelColor.setColor(header.getLabelColor());
        labelVisibleChanged();

    }

    private void labelVisibleChanged() {
        boolean e = labelVisibleChk.isSelected();
        labelFontField.setEnabled(e);
        fontLabel.setEnabled(e);
        labelFontBtn.setEnabled(e);
        forceLabelColorChk.setEnabled(e);
        labelColor.setEnabled(forceLabelColorChk.isSelected() && e);
        labelRotatedChk.setEnabled(false);
        labelRotatedChk.setVisible(false);
    }

    private void fontChanged() {
        labelFontField.setText(FontUtils.fontText(labelFont));
        labelFontField.setFont(labelFont);
    }

    private void selectFont() {
        FontChooserDialog dlg = new FontChooserDialog(null, header.getLabelFont(), false);
        dlg.setVisible(true);

        if (dlg.isCancelled()) {
            return;
        }

        labelFont = dlg.getFont();
        fontChanged();
    }

    @Override
    public void updateModel() {
        super.updateModel();

        header.setTitle(titleField.getText());
        header.setMargin((Integer) marginSpin.getValue());
        header.setSeparationGrid(separationGridChk.isSelected());
        header.setLabelVisible(labelVisibleChk.isSelected());
        header.setLabelFont(labelFont);
        header.setLabelColor(labelColor.getColor());
        header.setForceLabelColor(forceLabelColorChk.isSelected());
        header.setLabelRotated(labelRotatedChk.isSelected());
        header.setLabelColor(labelColor.getColor());
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        colorGroup = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        titleField = new javax.swing.JTextField();
        labelVisibleChk = new javax.swing.JCheckBox();
        fontLabel = new javax.swing.JLabel();
        labelFontField = new javax.swing.JTextField();
        labelFontBtn = new javax.swing.JButton();
        labelRotatedChk = new javax.swing.JCheckBox();
        separationGridChk = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        marginSpin = new javax.swing.JSpinner();
        labelColor = new org.gitools.ui.platform.component.ColorChooserLabel();
        forceLabelColorChk = new javax.swing.JCheckBox();

        jLabel1.setText("Title");

        labelVisibleChk.setText("Show cluster names");

        fontLabel.setText("Font");
        fontLabel.setEnabled(false);

        labelFontField.setEditable(false);

        labelFontBtn.setText("...");

        labelRotatedChk.setText("Rotated text");

        separationGridChk.setText("Grid between different clusters");

        jLabel3.setText("Margin");

        marginSpin.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(5), Integer.valueOf(0), null, Integer.valueOf(1)));

        labelColor.setColor(new java.awt.Color(1, 1, 1));
        labelColor.setPreferredSize(new java.awt.Dimension(28, 28));

        forceLabelColorChk.setSelected(true);
        forceLabelColorChk.setText("All cluster names with the same color");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(titleField, javax.swing.GroupLayout.DEFAULT_SIZE, 588, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(jLabel3).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(marginSpin, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE)).addComponent(separationGridChk).addComponent(labelVisibleChk))).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(24, 24, 24).addComponent(fontLabel).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(labelFontField, javax.swing.GroupLayout.DEFAULT_SIZE, 544, Short.MAX_VALUE).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(labelFontBtn)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(forceLabelColorChk).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(labelColor, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(labelRotatedChk))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(titleField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(marginSpin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)).addGap(18, 18, 18).addComponent(separationGridChk).addGap(18, 18, 18).addComponent(labelVisibleChk).addGap(18, 18, 18).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(fontLabel).addComponent(labelFontField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE).addComponent(labelFontBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(forceLabelColorChk).addComponent(labelColor, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)).addGap(18, 18, 18).addComponent(labelRotatedChk).addGap(14, 14, 14)));
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup colorGroup;
    private javax.swing.JLabel fontLabel;
    private javax.swing.JCheckBox forceLabelColorChk;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private org.gitools.ui.platform.component.ColorChooserLabel labelColor;
    private javax.swing.JButton labelFontBtn;
    private javax.swing.JTextField labelFontField;
    private javax.swing.JCheckBox labelRotatedChk;
    private javax.swing.JCheckBox labelVisibleChk;
    private javax.swing.JSpinner marginSpin;
    private javax.swing.JCheckBox separationGridChk;
    private javax.swing.JTextField titleField;
    // End of variables declaration//GEN-END:variables


    public HeatmapColoredLabelsHeader getHeader() {
        return header;
    }

    public void setHeader(HeatmapColoredLabelsHeader header) {
        this.header = header;
    }
}
