/*
 * #%L
 * gitools-ui-app
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.app.datasources.biomart.filter;

import org.gitools.datasources.biomart.restful.model.Filter;
import org.gitools.datasources.biomart.restful.model.FilterCollection;
import org.gitools.datasources.biomart.restful.model.FilterDescription;
import org.gitools.ui.app.datasources.biomart.wizard.BiomartFilterConfigurationPage;

import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @noinspection ALL
 */
public class FilterCollectionPanel extends JPanel {

    private BiomartFilterConfigurationPage filterConfigurationPage;

    private Integer currentHeight = 0;

    private final Integer DEFAULT_COLLECTION_PANEL_HEIGHT = 60;

    private Boolean rendered; //Controls if collectionPanel contains any component

    /**
     * Creates new form FilterCollectionPanel1
     */
    public FilterCollectionPanel(FilterCollection fc, BiomartFilterConfigurationPage parent) {

        initComponents();

        rendered = false;

        filterConfigurationPage = parent;

        buildDescriptions(fc);

    }

    private void buildDescriptions(FilterCollection fc) {

        collectionCheckBox.setText(fc.getDisplayName());

        descriptionsPanel.removeAll();

        descriptionsPanel.setLayout(new BoxLayout(descriptionsPanel, BoxLayout.Y_AXIS));

        FilterDescriptionPanel description = null;

        Boolean doLblDescription = renderLabelDescription(fc);

        for (FilterDescription d : fc.getFilterDescriptions()) {

            if (!d.isHideDisplay()) {

                description = new FilterDescriptionPanel(d, this, doLblDescription);

                rendered = description.getRenderPanel();
                descriptionsPanel.add(description);
                currentHeight += description.getCurrentHeight();
            }
        }


        validate();
    }

    public JPanel getDescriptionsPanel() {
        return descriptionsPanel;
    }

    /**
     * Render Label descriptions when more than 1 descriptions per collection
     *
     * @param fc
     * @return
     */

    private Boolean renderLabelDescription(FilterCollection fc) {
        Integer components = 0;

        for (FilterDescription d : fc.getFilterDescriptions())
            if (!d.isHideDisplay()) {
                components++;
            }

        return components > 1;
    }

    public Boolean isPanelRendered() {

        return rendered;

    }

    public FilterCollectionPanel() {

        initComponents();
    }


    public Integer getCurrentHeigh() {
        return currentHeight + DEFAULT_COLLECTION_PANEL_HEIGHT;
    }


    public List<Filter> getFilters() {

        List<Filter> filters = new ArrayList<Filter>();
        List<Filter> filtersAux = null;

        if (collectionCheckBox.isSelected()) {
            // Obtain the filters involved for this event
            for (Component compo : descriptionsPanel.getComponents()) {
                filtersAux = ((FilterDescriptionPanel) compo).getFilters();

                for (Filter f : filtersAux)
                    if (f.getName() != null && f.getValue() != null && !f.getValue().isEmpty()) {
                        filters.add(f);
                    }
            }
        }
        return filters;
    }

    public BiomartFilterConfigurationPage getFilterConfigurationPage() {
        return filterConfigurationPage;
    }


    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        descriptionsPanel = new javax.swing.JPanel();
        collectionCheckBox = new javax.swing.JCheckBox();

        setBorder(javax.swing.BorderFactory.createEtchedBorder());

        descriptionsPanel.setBorder(javax.swing.BorderFactory.createCompoundBorder());

        javax.swing.GroupLayout descriptionsPanelLayout = new javax.swing.GroupLayout(descriptionsPanel);
        descriptionsPanel.setLayout(descriptionsPanelLayout);
        descriptionsPanelLayout.setHorizontalGroup(descriptionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 374, Short.MAX_VALUE));
        descriptionsPanelLayout.setVerticalGroup(descriptionsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 247, Short.MAX_VALUE));

        collectionCheckBox.setText("name");
        collectionCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                stateChangedAction(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(collectionCheckBox).addComponent(descriptionsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)).addGap(16, 16, 16)));
        layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(collectionCheckBox).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(descriptionsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE).addContainerGap(16, Short.MAX_VALUE)));
    }// </editor-fold>//GEN-END:initComponents

    private void stateChangedAction(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_stateChangedAction
    }//GEN-LAST:event_stateChangedAction

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox collectionCheckBox;
    private javax.swing.JPanel descriptionsPanel;
    // End of variables declaration//GEN-END:variables


}
