/*
 * #%L
 * gitools-ui-app
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.app.datasources.biomart.dialog;

import org.gitools.datasources.biomart.BiomartService;
import org.gitools.datasources.biomart.restful.model.AttributeDescription;
import org.gitools.datasources.biomart.restful.model.AttributePage;
import org.gitools.datasources.biomart.restful.model.DatasetInfo;
import org.gitools.datasources.biomart.restful.model.MartLocation;
import org.gitools.ui.app.datasources.biomart.panel.BiomartAttributePanel.AttributeSelectionListener;

import java.util.List;

/**
 * @noinspection ALL
 */
public class BiomartAttributeDialog extends javax.swing.JDialog {

    private boolean cancelled;

    public BiomartAttributeDialog(java.awt.Frame parent, List<AttributePage> attrPages) {

        super(parent, true);

        initComponents();

        setTitle("Select attributes");

        updateButtons();

        biomartAttrPanel.addAttributeSelectionListener(new AttributeSelectionListener() {
            @Override
            public void selectionChanged() {
                updateButtons();
            }
        });

        cancelled = false;

        biomartAttrPanel.setAttributePages(attrPages);
    }

    public void open() {
        setVisible(true);
    }

    public boolean isCancelled() {
        return cancelled;
    }

    public List<AttributeDescription> getSelectedAttributes() {
        return biomartAttrPanel.getSelectedAttributes();
    }

    public List<String> getSelectedAttributeNames() {
        return biomartAttrPanel.getSelectedAttributeNames();
    }

    void updateButtons() {
        acceptBtn.setEnabled(biomartAttrPanel.getSelectedAttributes().size() > 0);
    }

    /*
        public void setBiomartParameters(
                MartServiceSoap port,
                Mart mart,
                DatasetInfo dataset) {

            biomartAttrPanel.setBiomartParameters(port, mart, dataset);
        }
    */
    public void setBiomartParameters(BiomartService port, MartLocation mart, DatasetInfo dataset) {

        biomartAttrPanel.setBiomartParameters(port, mart, dataset);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        biomartAttrPanel = new org.gitools.ui.app.datasources.biomart.panel.BiomartAttributePanel();
        cancelBtn = new javax.swing.JButton();
        acceptBtn = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBtnActionPerformed(evt);
            }
        });

        acceptBtn.setText("Accept");
        acceptBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                acceptBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(389, Short.MAX_VALUE).addComponent(acceptBtn).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(cancelBtn).addContainerGap()).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 506, Short.MAX_VALUE).addContainerGap()).addComponent(biomartAttrPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 518, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(biomartAttrPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(cancelBtn).addComponent(acceptBtn)).addContainerGap()));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void acceptBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_acceptBtnActionPerformed
        setVisible(false);
    }//GEN-LAST:event_acceptBtnActionPerformed

    private void cancelBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
        cancelled = true;
        setVisible(false);
    }//GEN-LAST:event_cancelBtnActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton acceptBtn;
    private org.gitools.ui.app.datasources.biomart.panel.BiomartAttributePanel biomartAttrPanel;
    private javax.swing.JButton cancelBtn;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

}
