/*
 * #%L
 * gitools-ui-app
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.app.analysis.combination.wizard;

import org.gitools.api.matrix.IMatrixLayer;
import org.gitools.api.matrix.view.IMatrixViewLayers;
import org.gitools.matrix.model.MatrixLayer;
import org.gitools.ui.platform.IconUtils;
import org.gitools.ui.platform.icons.IconNames;
import org.gitools.ui.platform.wizard.AbstractWizardPage;

import javax.swing.*;
import java.util.Vector;

public class CombinationAnalysisParamsPage extends AbstractWizardPage {

    private static IMatrixLayer ALL_COLUMNS = new MatrixLayer("null-selection", Void.class, "All columns with the same weight", "");

    public CombinationAnalysisParamsPage(IMatrixViewLayers<?> layers) {

        initComponents();

        setTitle("Configure combination options");
        setLogo(IconUtils.getImageIconResourceScaledByHeight(IconNames.LOGO_METHOD, 96));
        setComplete(true);

        Vector<IMatrixLayer> pvalueLayers = new Vector<>();
        Vector<IMatrixLayer> sizeLayers = new Vector<>();

        sizeLayers.add(ALL_COLUMNS);
        for (IMatrixLayer layer : layers) {
            //TODO Add only valid layers. Ex: skip 'string' layers
            sizeLayers.add(layer);
            pvalueLayers.add(layer);
        }

        sizeAttrCb.setModel(new DefaultComboBoxModel(sizeLayers));
        pvalueAttrCb.setModel(new DefaultComboBoxModel(pvalueLayers));
        pvalueAttrCb.setSelectedItem(layers.getTopLayer());

/*        sizeAttrLabel.setEnabled(true);
        sizeAttrCb.setEnabled(true);
        pvalueAttrLabel.setEnabled(true);
        pvalueAttrCb.setEnabled(true); */

    }

    public String getSizeLayerId() {
        IMatrixLayer sizeLayer = (IMatrixLayer) sizeAttrCb.getSelectedItem();
        return (sizeLayer == ALL_COLUMNS ? null : sizeLayer.getId());
    }

    public String getPvalueLayerId() {
        return ((IMatrixLayer) pvalueAttrCb.getSelectedItem()).getId();
    }

    public boolean isTransposeEnabled() {
        return applyToRowsRb.isSelected();
    }

    public void setTransposeEnabled(boolean transpose) {
        applyToColumnsRb.setSelected(!transpose);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        applyButtonGroup = new javax.swing.ButtonGroup();
        sizeAttrLabel = new javax.swing.JLabel();
        sizeAttrCb = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        applyToColumnsRb = new javax.swing.JRadioButton();
        applyToRowsRb = new javax.swing.JRadioButton();
        pvalueAttrLabel = new javax.swing.JLabel();
        pvalueAttrCb = new javax.swing.JComboBox();

        sizeAttrLabel.setText("Size layer");

        jLabel2.setText("Apply to:");

        applyButtonGroup.add(applyToColumnsRb);
        applyToColumnsRb.setSelected(true);
        applyToColumnsRb.setText("Columns");

        applyButtonGroup.add(applyToRowsRb);
        applyToRowsRb.setText("Rows");

        pvalueAttrLabel.setText("P-value layer");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false).addComponent(sizeAttrLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE).addComponent(pvalueAttrLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING).addComponent(sizeAttrCb, 0, 304, Short.MAX_VALUE).addComponent(pvalueAttrCb, javax.swing.GroupLayout.Alignment.LEADING, 0, 304, Short.MAX_VALUE))).addComponent(jLabel2).addComponent(applyToColumnsRb).addComponent(applyToRowsRb)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(sizeAttrLabel).addComponent(sizeAttrCb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(pvalueAttrLabel).addComponent(pvalueAttrCb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)).addGap(18, 18, 18).addComponent(jLabel2).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED).addComponent(applyToColumnsRb).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(applyToRowsRb).addContainerGap(125, Short.MAX_VALUE)));
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup applyButtonGroup;
    private javax.swing.JRadioButton applyToColumnsRb;
    private javax.swing.JRadioButton applyToRowsRb;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JComboBox pvalueAttrCb;
    private javax.swing.JLabel pvalueAttrLabel;
    private javax.swing.JComboBox sizeAttrCb;
    private javax.swing.JLabel sizeAttrLabel;
    // End of variables declaration//GEN-END:variables

}
