/*
 * #%L
 * gitools-core
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.persistence.locators.filters.cache;


import org.gitools.api.resource.IResourceLocator;
import org.gitools.persistence.locators.filters.FilterResourceLocator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CacheResourceManager {

    // Singleton pattern
    private static CacheResourceManager INSTANCE = new CacheResourceManager();

    public static CacheResourceManager get() {
        return INSTANCE;
    }

    private Map<URL, IResourceLocator> cache = new HashMap<>();

    private CacheResourceManager() {
    }

    public IResourceLocator getCacheResourceLocator(IResourceLocator locator) {

        if (locator instanceof FilterResourceLocator) {
            return locator;
        }

        URL remoteURL = locator.getURL();

        if (remoteURL.getProtocol().equals("file")) {
            return locator;
        }

        if (cache.containsKey(remoteURL)) {
            return cache.get(remoteURL);
        }

        File tmpFile;
        try {
            tmpFile = File.createTempFile("gitools-cache-", locator.getName());
            tmpFile.deleteOnExit();
        } catch (IOException e) {
            return locator;
        }

        IResourceLocator cachedLocator = new CacheResourceLocator(tmpFile, locator);
        cache.put(remoteURL, cachedLocator);

        return cachedLocator;
    }


}
