#!/bin/bash

###
# #%L
# gitools-cli
# %%
# Copyright (C) 2013 Biomedical Genomics Lab
# %%
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the 
# License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public 
# License along with this program.  If not, see
# <http://www.gnu.org/licenses/gpl-3.0.html>.
# #L%
###
#
# ---------------------------------------------------------------------
# Gitools startup script.
# ---------------------------------------------------------------------
#

APPDIR="$BINDIR/.."
LIBDIR=$APPDIR/lib

UNAME=`which uname`
GREP=`which egrep`
GREP_OPTIONS=""
CUT=`which cut`
READLINK=`which readlink`
MKTEMP=`which mktemp`
RM=`which rm`
CAT=`which cat`
TR=`which tr`

echo "DETECTING JAVA VERSION"
echo ""

if [ -z "$UNAME" -o -z "$GREP" -o -z "$CUT" -o -z "$MKTEMP" -o -z "$RM" -o -z "$CAT" -o -z "$TR" ]; then
  echo "ERROR: required tools are missing - check beginning of \"$0\" file for details."
  exit 1
fi

OS_TYPE=`"$UNAME" -s`

# ---------------------------------------------------------------------
# Locate a JDK installation directory which will be used to run the IDE.
# Try (in order): GITOOLS_JDK, JDK_HOME, JAVA_HOME, "java" in PATH.
# ---------------------------------------------------------------------
if [ -n "$GITOOLS_JDK" -a -x "$GITOOLS_JDK/bin/java" ]; then
  JDK="$GITOOLS_JDK"
elif [ -n "$JDK_HOME" -a -x "$JDK_HOME/bin/java" ]; then
  JDK="$JDK_HOME"
elif [ -n "$JAVA_HOME" -a -x "$JAVA_HOME/bin/java" ]; then
  JDK="$JAVA_HOME"
else
  JAVA_BIN_PATH=`which java`
  if [ -n "$JAVA_BIN_PATH" ]; then
    if [ "$OS_TYPE" = "FreeBSD" ]; then
      JAVA_LOCATION=`JAVAVM_DRYRUN=yes java | "$GREP" '^JAVA_HOME' | "$CUT" -c11-`
      if [ -x "$JAVA_LOCATION/bin/java" ]; then
        JDK="$JAVA_LOCATION"
      fi
    elif [ "$OS_TYPE" = "SunOS" ]; then
      JAVA_LOCATION="/usr/jdk/latest"
      if [ -x "$JAVA_LOCATION/bin/java" ]; then
        JDK="$JAVA_LOCATION"
      fi
    elif [ "$OS_TYPE" = "Darwin" ]; then
      JAVA_LOCATION=`/usr/libexec/java_home`
      if [ -x "$JAVA_LOCATION/bin/java" ]; then
        JDK="$JAVA_LOCATION"
      fi
    fi

    if [ -z "$JDK" -a -x "$READLINK" ]; then
      JAVA_LOCATION=`"$READLINK" -f "$JAVA_BIN_PATH"`
      case "$JAVA_LOCATION" in
        */jre/bin/java)
          JAVA_LOCATION=`echo "$JAVA_LOCATION" | xargs dirname | xargs dirname | xargs dirname` ;;
        *)
          JAVA_LOCATION=`echo "$JAVA_LOCATION" | xargs dirname | xargs dirname` ;;
      esac
      if [ -x "$JAVA_LOCATION/bin/java" ]; then
        JDK="$JAVA_LOCATION"
      fi
    fi
  fi
fi

if [ -z "$JDK" ]; then
  echo "ERROR: cannot start Gitools."
  echo "No JDK found. Please validate either GITOOLS_JDK, JDK_HOME or JAVA_HOME environment variable points to valid JDK installation."
  echo
  echo "Press Enter to continue."
  read IGNORE
  exit 1
fi

VERSION_LOG=`"$MKTEMP" -t java.version.log.XXXXXX`
"$JDK/bin/java" -version 2> "$VERSION_LOG"
"$GREP" 'OpenJDK' "$VERSION_LOG"
OPEN_JDK=$?
"$GREP" "64-Bit|x86_64" "$VERSION_LOG"
BITS=$?
"$RM" -f "$VERSION_LOG"

if [[ "$JDK" ]]; then
    echo $($JDK/bin/java -version)
    ## added grep -v "_JAVA_OPTIONS" in order prevent proxy settings being used as java version
    JAVA_VER=$($JDK/bin/java -version 2>&1 | grep -v '_JAVA_OPTIONS' | sed 's/java version "\(.*\)\.\(.*\)\..*"/\1\2/; 1q')
    [ "$JAVA_VER" -ge 17 ] && echo "Satisfactory Java version found" || echo "Old Java version found - please upgrade to 1.7"
    [ "$JAVA_VER" -ge 17 ] && echo "" || exit
fi

if [ $BITS -eq 0 ]; then
  BITS=64
else
  BITS=32
fi

source "$BINDIR/freemem.sh"

javacmd="$JDK/bin/java $VMOPTIONS"
echo $javacmd
echo ""

