/*
 * #%L
 * gitools-ui-platform
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.platform.progress;

import org.gitools.ui.platform.help.Tips;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

class JobProgressGlassPane extends GitoolsGlassPane implements IProgressComponent {

    public JobProgressGlassPane(Window parent, boolean showGitoolsTips) {
        super(parent);

        initComponents();

        msgLabel.setText("");
        msgLabel.setFont(msgLabel.getFont().deriveFont(23f));
        infoLabel.setText("");
        infoLabel.setFont(infoLabel.getFont().deriveFont(19f));
        tipsLabel.setFont(tipsLabel.getFont().deriveFont(19f));

        if (showGitoolsTips) {
            setTimerLoop();
        }

        progressBar.setMinimum(0);
        progressBar.setIndeterminate(true);

        //glassPane
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);

        this.setBorder(new EmptyBorder(50, 20, 50, 20));

    }


    private final List<CancelListener> listeners = new ArrayList<>();

    /**
     * Creates new form ProgressDialog
     */

    private void setTimerLoop() {
        timer = new Timer();
        timer.schedule(new ShowNewTip(), 3000, //initial delay
                1 * 10000); //subsequent rate
    }

    class ShowNewTip extends TimerTask {
        public void run() {
            if (infoLabel.getText().equals("")) {
                tipsLabel.setText(Tips.get().getRandomTip());
            }
        }
    }


    @Override
    public void addCancelListener(CancelListener listener) {
        listeners.add(listener);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        msgLabel = new JLabel();
        progressBar = new JProgressBar();
        cancelBtn = new JButton();
        infoLabel = new JLabel();
        tipsLabel = new JLabel();


        msgLabel.setHorizontalAlignment(SwingConstants.LEFT);
        msgLabel.setText("Working...");

        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBtnActionPerformed(evt);
            }
        });

        infoLabel.setText("info");
        tipsLabel.setText("");

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).
                addGroup(layout.createSequentialGroup().addContainerGap().
                        addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).
                                addComponent(progressBar, GroupLayout.DEFAULT_SIZE, 551, Short.MAX_VALUE).
                                addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 551, GroupLayout.PREFERRED_SIZE).
                                addComponent(infoLabel, GroupLayout.PREFERRED_SIZE, 551, GroupLayout.PREFERRED_SIZE).
                                addComponent(tipsLabel, GroupLayout.PREFERRED_SIZE, 551, GroupLayout.PREFERRED_SIZE).
                                addComponent(cancelBtn, GroupLayout.Alignment.TRAILING)).addContainerGap()));

        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).
                addGroup(
                        layout.createSequentialGroup().addContainerGap()
                                .addComponent(msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(progressBar, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(tipsLabel, GroupLayout.PREFERRED_SIZE, 60, GroupLayout.PREFERRED_SIZE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(cancelBtn).addContainerGap()));


    }// </editor-fold>//GEN-END:initComponents

    private void cancelBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
        for (CancelListener listener : listeners)
            listener.cancelled();
    }//GEN-LAST:event_cancelBtnActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JButton cancelBtn;
    private JLabel infoLabel;
    private JLabel msgLabel;
    private JLabel tipsLabel;
    private Timer timer;
    private JProgressBar progressBar;
    // End of variables declaration//GEN-END:variables


    @Override
    protected void escapePressed() {
        // do nothing
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void setMessage(String msg) {
        msgLabel.setText(msg);
        infoLabel.setText("");
    }

    @Override
    public void setMessage(String msg, String info) {
        msgLabel.setText(msg);
        infoLabel.setText(info);
    }

    @Override
    public void setInfo(String info) {
        tipsLabel.setText("");
        infoLabel.setText(info);
    }

    @Override
    public void setWork(int work) {
        progressBar.setMaximum(work);
    }

    @Override
    public void setProgress(int progress) {
        if (progress == 0) {
            progressBar.setIndeterminate(true);
        } else {
            progressBar.setIndeterminate(false);
            progressBar.setValue(progress);
        }
    }


    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }


}
