/*
 * #%L
 * gitools-ui-app
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.app.datasources.biomart.wizard;

import org.gitools.ui.platform.wizard.AbstractWizardPage;

import javax.swing.*;

public class BiomartTableFilteringPage extends AbstractWizardPage {

    /**
     * Creates new form BiomartTableFilteringPage
     */
    public BiomartTableFilteringPage() {
        initComponents();

        setTitle("Rows filtering");
        setComplete(true);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        emptyValuesButtonGroup = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        emptyValuesSkipRb = new javax.swing.JRadioButton();
        emptyValuesReplaceRb = new javax.swing.JRadioButton();
        emptyValuesReplaceText = new javax.swing.JTextField();

        jLabel1.setText("Empty values filtering:");

        emptyValuesButtonGroup.add(emptyValuesSkipRb);
        emptyValuesSkipRb.setSelected(true);
        emptyValuesSkipRb.setText("Skip rows with empty values");

        emptyValuesButtonGroup.add(emptyValuesReplaceRb);
        emptyValuesReplaceRb.setText("Allow rows with empty values and replace them with");

        emptyValuesReplaceText.setColumns(4);
        emptyValuesReplaceText.setText("-");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(jLabel1).addComponent(emptyValuesSkipRb).addGroup(layout.createSequentialGroup().addComponent(emptyValuesReplaceRb).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(emptyValuesReplaceText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))).addContainerGap(126, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED).addComponent(emptyValuesSkipRb).addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(emptyValuesReplaceRb).addComponent(emptyValuesReplaceText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)).addContainerGap(337, Short.MAX_VALUE)));
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup emptyValuesButtonGroup;
    private javax.swing.JRadioButton emptyValuesReplaceRb;
    private javax.swing.JTextField emptyValuesReplaceText;
    private javax.swing.JRadioButton emptyValuesSkipRb;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables


    @Override
    public JComponent createControls() {
        return this;
    }

    public boolean isSkipRowsWithEmptyValuesEnabled() {
        return emptyValuesSkipRb.isSelected();
    }

    public String emptyValuesReplacement() {
        return emptyValuesReplaceText.getText();
    }

}
