/*
 * #%L
 * gitools-ui-app
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.ui.app.actions.edit;

import org.gitools.api.matrix.MatrixDimensionKey;
import org.gitools.heatmap.HeatmapDimension;
import org.gitools.ui.app.actions.HeatmapDimensionAction;
import org.gitools.ui.core.Application;
import org.gitools.ui.core.HeatmapPosition;
import org.gitools.ui.core.actions.dynamicactions.IHeatmapDimensionAction;

import java.awt.event.ActionEvent;

import static com.google.common.base.Predicates.in;
import static com.google.common.base.Predicates.not;

public class InvertSelectionAction extends HeatmapDimensionAction implements IHeatmapDimensionAction {

    public InvertSelectionAction(MatrixDimensionKey dimension) {
        super(dimension, "<html><i>Invert</i> " + dimension.getLabel() + " selection</html>");
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        getDimension().select(not(in(getDimension().getSelected())));
        Application.get().showNotification("Selection of " + getDimension().getId().getLabel() + "s inverted");
    }

    @Override
    public void onConfigure(HeatmapDimension dimension, HeatmapPosition position) {

        // Enable only if there is at least one item selected
        setEnabled(dimension.getSelected().size() > 0);
    }
}
