/*
 * #%L
 * gitools-core
 * %%
 * Copyright (C) 2013 Universitat Pompeu Fabra - Biomedical Genomics group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.gitools.analysis.stats.calc;

public class MeanStatistic implements Statistic {

    @Override
    public String getName() {
        return "mean";
    }

    @Override
    public Double calc(Iterable<Double> values) {

        double sum = 0.0;
        int size = 0;

        for (Double value : values) {
            if (value != null) {
                sum += value;
                size++;
            }
        }

        if (size == 0) {
            return null;
        }

        return sum / size;
    }
}
