/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.ColorUtils;
import com.alee.utils.collection.ValuesTable;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Color;

public class ColorConverter
extends AbstractSingleValueConverter {
    public static final String NULL_COLOR = "null";
    private static final ValuesTable<String, Color> defaultColors = new ValuesTable();

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Color.class);
    }

    @Override
    public Object fromString(String color) {
        return defaultColors.containsKey(color) ? defaultColors.get(color) : (color.contains("#") ? ColorUtils.parseHexColor(color) : ColorUtils.parseRgbColor(color));
    }

    @Override
    public String toString(Object object) {
        Color color = (Color)object;
        return defaultColors.containsValue(color) ? defaultColors.getKey(color) : color.getRed() + "," + color.getGreen() + "," + color.getBlue() + (color.getAlpha() < 255 ? "," + color.getAlpha() : "");
    }

    static {
        defaultColors.put(NULL_COLOR, null);
        defaultColors.put("black", Color.BLACK);
        defaultColors.put("white", Color.WHITE);
        defaultColors.put("red", Color.RED);
        defaultColors.put("green", Color.GREEN);
        defaultColors.put("blue", Color.BLUE);
        defaultColors.put("lightGray", Color.LIGHT_GRAY);
        defaultColors.put("gray", Color.GRAY);
        defaultColors.put("darkGray", Color.DARK_GRAY);
        defaultColors.put("pink", Color.PINK);
        defaultColors.put("orange", Color.ORANGE);
        defaultColors.put("yellow", Color.YELLOW);
        defaultColors.put("magenta", Color.MAGENTA);
        defaultColors.put("cyan", Color.CYAN);
    }
}

