/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.ButtonGroupListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class UnselectableButtonGroup
extends ButtonGroup {
    private final List<ButtonGroupListener> listeners = new ArrayList<ButtonGroupListener>(1);
    private boolean unselectable = true;

    public UnselectableButtonGroup() {
    }

    public UnselectableButtonGroup(AbstractButton ... buttons) {
        this.add(buttons);
    }

    public UnselectableButtonGroup(List<AbstractButton> buttons) {
        this.add(buttons);
    }

    public UnselectableButtonGroup(boolean unselectable) {
        this.setUnselectable(unselectable);
    }

    public boolean isUnselectable() {
        return this.unselectable;
    }

    public void setUnselectable(boolean unselectable) {
        this.unselectable = unselectable;
    }

    @Override
    public void setSelected(ButtonModel model, boolean selected) {
        if (selected || !this.unselectable) {
            super.setSelected(model, selected);
        } else {
            this.clearSelection();
        }
        this.fireSelectionChanged();
    }

    public List<AbstractButton> getButtons() {
        return CollectionUtils.copy(this.buttons);
    }

    public void addButtonGroupListener(ButtonGroupListener listener) {
        this.listeners.add(listener);
    }

    public void removeButtonGroupListener(ButtonGroupListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSelectionChanged() {
        for (ButtonGroupListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged();
        }
    }

    public void add(AbstractButton ... b) {
        for (AbstractButton button : b) {
            this.add(button);
        }
    }

    public void add(List<AbstractButton> b) {
        for (AbstractButton button : b) {
            this.add(button);
        }
    }

    public static UnselectableButtonGroup group(AbstractButton ... buttons) {
        return new UnselectableButtonGroup(buttons);
    }

    public static UnselectableButtonGroup group(List<AbstractButton> buttons) {
        return new UnselectableButtonGroup(buttons);
    }
}

