/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.utils.MapUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DoubleMap<K, V>
implements Map<K, V> {
    protected Map<K, V> valuesByKeys;
    protected Map<V, K> keysByValues;

    public DoubleMap() {
        this(10);
    }

    public DoubleMap(int initialCapacity) {
        this.valuesByKeys = new HashMap(initialCapacity);
        this.keysByValues = new HashMap<V, K>(initialCapacity);
    }

    public DoubleMap(Map<K, V> map) {
        this(map.size());
        this.putAll(map);
    }

    public V getValue(K key) {
        return this.valuesByKeys.get(key);
    }

    public K getKey(V value) {
        return this.keysByValues.get(value);
    }

    public V removeByKey(K key) {
        V removed = this.valuesByKeys.remove(key);
        if (removed != null) {
            this.keysByValues.remove(removed);
        }
        return removed;
    }

    public K removeByValue(V value) {
        K removed = this.keysByValues.remove(value);
        if (removed != null) {
            this.valuesByKeys.remove(removed);
        }
        return removed;
    }

    @Override
    public V put(K key, V value) {
        V v;
        if (this.valuesByKeys.containsKey(key)) {
            v = this.valuesByKeys.get(key);
            this.valuesByKeys.remove(key);
            this.keysByValues.remove(v);
        } else {
            v = null;
        }
        if (this.keysByValues.containsKey(value)) {
            K k = this.keysByValues.get(value);
            this.valuesByKeys.remove(k);
            this.keysByValues.remove(value);
        }
        this.valuesByKeys.put(key, value);
        this.keysByValues.put(value, key);
        return v;
    }

    @Override
    public int size() {
        return this.valuesByKeys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.valuesByKeys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valuesByKeys.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keysByValues.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.valuesByKeys.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.removeByKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.valuesByKeys.clear();
        this.keysByValues.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.valuesByKeys.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.valuesByKeys.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.valuesByKeys.entrySet();
    }

    public Map<K, V> getValuesByKeys() {
        return MapUtils.copyMap(this.valuesByKeys);
    }

    public Map<V, K> getKeysByValues() {
        return MapUtils.copyMap(this.keysByValues);
    }
}

