/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateField;
import com.alee.extended.filechooser.WebFileChooserField;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ThreadUtils;
import com.alee.utils.laf.WeblafBorder;
import com.alee.utils.swing.EventPump;
import com.alee.utils.swing.SizeMethods;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public final class SwingUtils {
    public static final String HANDLES_ENABLE_STATE = "HANDLES_ENABLE_STATE";
    private static Integer systemShortcutModifier = null;
    private static JLabel label = null;
    private static String[] fontNames;
    private static Font[] fonts;
    private static Thread scrollThread1;
    private static Thread scrollThread2;
    private static final int STRONG_BEARING_CACHE_SIZE = 10;
    private static final BearingCacheEntry[] strongBearingCache;
    private static int strongBearingCacheNextIndex;
    private static final Set<SoftReference<BearingCacheEntry>> softBearingCache;

    public static boolean isPreserveBorders(JComponent component) {
        if (SwingUtils.getHonorUserBorders(component)) {
            Border border = component.getBorder();
            return border != null && !(border instanceof UIResource) && !(border instanceof WeblafBorder);
        }
        return false;
    }

    public static boolean getHonorUserBorders(JComponent component) {
        return Boolean.getBoolean("WebLookAndFeel.honorUserBorders") || Boolean.TRUE.equals(component.getClientProperty("WebLookAndFeel.honorUserBorder"));
    }

    public static boolean isLafDecorated(Component component) {
        RootPaneUI ui;
        JRootPane rootPane = SwingUtils.getRootPane(component);
        if (rootPane != null && (ui = rootPane.getUI()) instanceof WebRootPaneUI) {
            return ((WebRootPaneUI)ui).isStyled();
        }
        return false;
    }

    public static boolean isLeftMouseButton(MouseEvent e) {
        return (e.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent e) {
        return (e.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent e) {
        return (e.getModifiers() & 4) == 4;
    }

    public static void packRowHeights(JTable table) {
        for (int row = 0; row < table.getRowCount(); ++row) {
            int maxHeight = 0;
            for (int column = 0; column < table.getColumnCount(); ++column) {
                Object valueAt;
                TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
                Component renderer = cellRenderer.getTableCellRendererComponent(table, valueAt = table.getValueAt(row, column), false, false, row, column);
                int heightPreferable = renderer != null ? renderer.getPreferredSize().height : 0;
                maxHeight = Math.max(heightPreferable, maxHeight);
            }
            table.setRowHeight(row, maxHeight);
        }
    }

    public static void packColumnWidths(JTable table) {
        SwingUtils.packColumnWidths(table, StyleConstants.spacing);
    }

    public static void packColumnWidths(JTable table, int margin) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            SwingUtils.packColumnWidth(table, i, margin);
        }
    }

    public static void packColumnWidth(JTable table, int col) {
        SwingUtils.packColumnWidth(table, col, StyleConstants.spacing);
    }

    public static void packColumnWidth(JTable table, int col, int margin) {
        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn column = columnModel.getColumn(col);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, col);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, col), false, false, r, col);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        column.setPreferredWidth(width += 2 * margin);
        column.setWidth(width);
    }

    public static boolean isPopupTrigger(MouseEvent e) {
        return e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e);
    }

    /*
     * Could not resolve type clashes
     */
    public static void destroyContainer(Container container) {
        for (Container toDestroy : SwingUtils.collectAllContainers(container)) {
            toDestroy.removeAll();
            toDestroy.setLayout(null);
            for (EventListener listener : toDestroy.getMouseListeners()) {
                toDestroy.removeMouseListener((MouseListener)listener);
            }
            for (EventListener listener : toDestroy.getMouseMotionListeners()) {
                toDestroy.removeMouseMotionListener((MouseMotionListener)listener);
            }
            for (EventListener listener : toDestroy.getMouseWheelListeners()) {
                toDestroy.removeMouseWheelListener((MouseWheelListener)listener);
            }
            for (EventListener listener : toDestroy.getKeyListeners()) {
                toDestroy.removeKeyListener((KeyListener)listener);
            }
            for (EventListener listener : toDestroy.getComponentListeners()) {
                toDestroy.removeComponentListener((ComponentListener)listener);
            }
            for (EventListener listener : toDestroy.getContainerListeners()) {
                toDestroy.removeContainerListener((ContainerListener)listener);
            }
            if (!(toDestroy instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)toDestroy;
            for (AncestorListener listener : jComponent.getAncestorListeners()) {
                jComponent.removeAncestorListener(listener);
            }
        }
    }

    public static List<Container> collectAllContainers(Container container) {
        return SwingUtils.collectAllContainers(container, new ArrayList<Container>());
    }

    public static List<Container> collectAllContainers(Container container, List<Container> containers) {
        containers.add(container);
        for (Component component : container.getComponents()) {
            if (!(component instanceof Container)) continue;
            SwingUtils.collectAllContainers((Container)component, containers);
        }
        return containers;
    }

    public static Component getTopComponentAt(Component component, int x, int y) {
        Component child = component.getComponentAt(x, y);
        if (child == component || !(child instanceof Container)) {
            return component;
        }
        Rectangle b = child.getBounds();
        return SwingUtils.getTopComponentAt(child, x - b.x, y - b.y);
    }

    public static void showAsModal(final Frame frame, final Frame owner) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                owner.setEnabled(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                owner.setEnabled(true);
                frame.removeWindowListener(this);
            }
        });
        owner.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (frame.isShowing()) {
                    frame.setExtendedState(0);
                    frame.toFront();
                } else {
                    owner.removeWindowListener(this);
                }
            }
        });
        frame.setVisible(true);
        try {
            new EventPump(frame).start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static ButtonGroup groupButtons(Container container) {
        return SwingUtils.groupButtons(container, false);
    }

    public static ButtonGroup groupButtons(Container container, boolean recursive) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SwingUtils.groupButtons(container, recursive, buttonGroup);
        return buttonGroup;
    }

    public static void groupButtons(Container container, boolean recursive, ButtonGroup buttonGroup) {
        for (Component component : container.getComponents()) {
            if (component instanceof AbstractButton) {
                buttonGroup.add((AbstractButton)component);
            }
            if (!recursive || !(component instanceof Container)) continue;
            SwingUtils.groupButtons(container, true);
        }
    }

    public static ButtonGroup groupButtons(AbstractButton ... buttons) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SwingUtils.groupButtons(buttonGroup, buttons);
        return buttonGroup;
    }

    public static void groupButtons(ButtonGroup buttonGroup, AbstractButton ... buttons) {
        for (AbstractButton button : buttons) {
            buttonGroup.add(button);
        }
    }

    public static void copyOrientation(Component from, Component to) {
        ComponentOrientation fo = from.getComponentOrientation();
        if (fo.isLeftToRight() != to.getComponentOrientation().isLeftToRight()) {
            to.applyComponentOrientation(fo);
        }
    }

    public static void updateGlobalOrientations() {
        SwingUtils.updateGlobalOrientations(WebLookAndFeel.getOrientation());
    }

    public static void updateGlobalOrientations(ComponentOrientation orientation) {
        for (Window window : Window.getWindows()) {
            window.applyComponentOrientation(orientation);
            JRootPane rootPane = SwingUtils.getRootPane(window);
            if (rootPane != null) {
                rootPane.revalidate();
                rootPane.repaint();
                continue;
            }
            window.invalidate();
            window.repaint();
        }
    }

    public static void setOrientation(Component component) {
        SwingUtils.setOrientation(component, false);
    }

    public static void setOrientation(Component component, boolean forced) {
        ComponentOrientation orientation = WebLookAndFeel.getOrientation();
        if (forced || orientation.isLeftToRight() != component.getComponentOrientation().isLeftToRight()) {
            component.setComponentOrientation(orientation);
        }
    }

    public static void applyOrientation(Component component) {
        SwingUtils.applyOrientation(component, false);
    }

    public static void applyOrientation(Component component, boolean forced) {
        ComponentOrientation orientation = WebLookAndFeel.getOrientation();
        if (forced || orientation.isLeftToRight() != component.getComponentOrientation().isLeftToRight()) {
            component.applyComponentOrientation(orientation);
        }
    }

    public static int maxWidth(Component ... components) {
        int max = 0;
        for (Component component : components) {
            max = Math.max(max, component.getPreferredSize().width);
        }
        return max;
    }

    public static int maxHeight(Component ... components) {
        int max = 0;
        for (Component component : components) {
            max = Math.max(max, component.getPreferredSize().height);
        }
        return max;
    }

    public static boolean isHeavyWeightWindow(Window window) {
        if (window == null) {
            return false;
        }
        String can = window.getClass().getCanonicalName();
        return can != null && can.endsWith("HeavyWeightWindow");
    }

    public static <T> T getFirstParent(Component component, Class<T> parentClass) {
        Container parent;
        for (parent = component.getParent(); !parentClass.isInstance(parent) && parent != null; parent = parent.getParent()) {
        }
        return (T)parent;
    }

    public static Window getWindowAncestor(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public static JRootPane getRootPane(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JFrame) {
            return ((JFrame)component).getRootPane();
        }
        if (component instanceof JDialog) {
            return ((JDialog)component).getRootPane();
        }
        if (component instanceof JWindow) {
            return ((JWindow)component).getRootPane();
        }
        if (component instanceof JApplet) {
            return ((JApplet)component).getRootPane();
        }
        if (component instanceof JRootPane) {
            return (JRootPane)component;
        }
        return SwingUtils.getRootPane(component.getParent());
    }

    public static Container getContentPane(Component component) {
        JRootPane rootPane = SwingUtils.getRootPane(component);
        return rootPane != null ? rootPane.getContentPane() : null;
    }

    public static JLayeredPane getLayeredPane(Component component) {
        JRootPane rootPane = SwingUtils.getRootPane(component);
        return rootPane != null ? rootPane.getLayeredPane() : null;
    }

    public static Component getGlassPane(Component component) {
        JRootPane rootPane = SwingUtils.getRootPane(component);
        return rootPane != null ? rootPane.getGlassPane() : null;
    }

    public static <C extends JComponent> C setBorder(C component, int border) {
        return SwingUtils.setBorder(component, LafUtils.createWebBorder(border));
    }

    public static <C extends JComponent> C setBorder(C component, int top, int left, int bottom, int right) {
        return SwingUtils.setBorder(component, LafUtils.createWebBorder(top, left, bottom, right));
    }

    public static <C extends JComponent> C setBorder(C component, Border border) {
        component.setBorder(border);
        return component;
    }

    public static boolean isPlainFont(Component component) {
        return component == null || component.getFont() == null || component.getFont().isPlain();
    }

    public static <C extends Component> C setPlainFont(C component) {
        return SwingUtils.setPlainFont(component, true);
    }

    public static <C extends Component> C setPlainFont(C component, boolean apply) {
        if (apply && component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(0));
        }
        return component;
    }

    public static boolean isBoldFont(Component component) {
        return component != null && component.getFont() != null && component.getFont().isBold();
    }

    public static <C extends Component> C setBoldFont(C component) {
        return SwingUtils.setBoldFont(component, true);
    }

    public static <C extends Component> C setBoldFont(C component, boolean apply) {
        if (apply && component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(1));
        }
        return component;
    }

    public static boolean isItalicFont(Component component) {
        return component != null && component.getFont() != null && component.getFont().isItalic();
    }

    public static <C extends Component> C setItalicFont(C component) {
        return SwingUtils.setItalicFont(component, true);
    }

    public static <C extends Component> C setItalicFont(C component, boolean apply) {
        if (apply && component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(2));
        }
        return component;
    }

    public static <C extends Component> C setFontSize(C component, int fontSize) {
        if (component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont((float)fontSize));
        }
        return component;
    }

    public static <C extends Component> C changeFontSize(C component, int change) {
        if (component != null && component.getFont() != null) {
            Font font = component.getFont();
            component.setFont(font.deriveFont((float)font.getSize() + (float)change));
        }
        return component;
    }

    public static int getFontSize(Component component) {
        if (component != null && component.getFont() != null) {
            return component.getFont().getSize();
        }
        return -1;
    }

    public static <C extends Component> C setFontStyle(C component, boolean bold, boolean italic) {
        int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
        return SwingUtils.setFontStyle(component, style);
    }

    public static <C extends Component> C setFontStyle(C component, int style) {
        if (component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(style));
        }
        return component;
    }

    public static <C extends Component> C setFontSizeAndStyle(C component, int fontSize, boolean bold, boolean italic) {
        int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
        return SwingUtils.setFontSizeAndStyle(component, fontSize, style);
    }

    public static <C extends Component> C setFontSizeAndStyle(C component, int fontSize, int style) {
        if (component != null && component.getFont() != null) {
            component.setFont(component.getFont().deriveFont(style, fontSize));
        }
        return component;
    }

    public static <C extends Component> C setFontName(C component, String fontName) {
        if (component != null && component.getFont() != null) {
            Font oldFont = component.getFont();
            component.setFont(new Font(fontName, oldFont.getStyle(), oldFont.getSize()));
        }
        return component;
    }

    public static String getFontName(Component component) {
        if (component != null && component.getFont() != null) {
            return component.getFont().getFontName();
        }
        return null;
    }

    public static Dimension copy(Dimension dimension) {
        return new Dimension(dimension);
    }

    public static Point copy(Point point) {
        return new Point(point);
    }

    public static Rectangle copy(Rectangle rectangle) {
        return new Rectangle(rectangle);
    }

    public static Insets copy(Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Color copy(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Rectangle size(Component component) {
        return new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public static Rectangle contentSize(Component component) {
        if (component instanceof JComponent) {
            Insets i = ((JComponent)component).getInsets();
            return new Rectangle(i.left, i.top, component.getWidth() - i.left - i.right, component.getHeight() - i.top - i.bottom);
        }
        return SwingUtils.size(component);
    }

    public static Insets max(Insets insets1, Insets insets2) {
        if (insets1 != null && insets2 != null) {
            return new Insets(Math.max(insets1.top, insets2.top), Math.max(insets1.left, insets2.left), Math.max(insets1.bottom, insets2.bottom), Math.max(insets1.right, insets2.right));
        }
        if (insets1 != null) {
            return insets1;
        }
        if (insets2 != null) {
            return insets2;
        }
        return null;
    }

    public static Insets min(Insets insets1, Insets insets2) {
        if (insets1 != null && insets2 != null) {
            return new Insets(Math.min(insets1.top, insets2.top), Math.min(insets1.left, insets2.left), Math.min(insets1.bottom, insets2.bottom), Math.min(insets1.right, insets2.right));
        }
        if (insets1 != null) {
            return insets1;
        }
        if (insets2 != null) {
            return insets2;
        }
        return null;
    }

    public static Dimension max(Component component1, Component component2) {
        return SwingUtils.max(component1.getPreferredSize(), component2.getPreferredSize());
    }

    public static Dimension max(Component ... components) {
        Dimension max = components.length > 0 ? components[0].getPreferredSize() : new Dimension(0, 0);
        for (int i = 1; i < components.length; ++i) {
            max = SwingUtils.max(max, components[i].getPreferredSize());
        }
        return max;
    }

    public static Dimension max(Dimension dimension1, Dimension dimension2) {
        if (dimension1 == null && dimension2 == null) {
            return null;
        }
        if (dimension1 == null) {
            return dimension2;
        }
        if (dimension2 == null) {
            return dimension1;
        }
        return new Dimension(Math.max(dimension1.width, dimension2.width), Math.max(dimension1.height, dimension2.height));
    }

    public static Dimension min(Component component1, Component component2) {
        return SwingUtils.min(component1.getPreferredSize(), component2.getPreferredSize());
    }

    public static Dimension min(Dimension dimension1, Dimension dimension2) {
        if (dimension1 == null || dimension2 == null) {
            return null;
        }
        return new Dimension(Math.min(dimension1.width, dimension2.width), Math.min(dimension1.height, dimension2.height));
    }

    public static void setOpaqueRecursively(Component component, boolean opaque) {
        SwingUtils.setOpaqueRecursively(component, opaque, false);
    }

    public static void setOpaqueRecursively(Component component, boolean opaque, boolean childsOnly) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (!childsOnly) {
                jComponent.setOpaque(opaque);
            }
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setOpaqueRecursively(child, opaque, false);
            }
        }
    }

    public static void setDoubleBufferedRecursively(Component component, boolean doubleBuffered) {
        SwingUtils.setDoubleBufferedRecursively(component, doubleBuffered, false);
    }

    public static void setDoubleBufferedRecursively(Component component, boolean doubleBuffered, boolean childsOnly) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (!childsOnly) {
                jComponent.setDoubleBuffered(doubleBuffered);
            }
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setDoubleBufferedRecursively(child, doubleBuffered, false);
            }
        }
    }

    public static void setHandlesEnableStateMark(JComponent component) {
        component.putClientProperty(HANDLES_ENABLE_STATE, Boolean.TRUE);
    }

    public static void removeHandlesEnableStateMark(JComponent component) {
        component.putClientProperty(HANDLES_ENABLE_STATE, Boolean.FALSE);
    }

    public static boolean isHandlesEnableState(Component component) {
        Object handlesEnabledState;
        return component instanceof JComponent && (handlesEnabledState = ((JComponent)component).getClientProperty(HANDLES_ENABLE_STATE)) != null && handlesEnabledState instanceof Boolean && (Boolean)handlesEnabledState != false;
    }

    public static void setEnabledRecursively(Component component, boolean enabled) {
        SwingUtils.setEnabledRecursively(component, enabled, false);
    }

    public static void setEnabledRecursively(Component component, boolean enabled, boolean startFromChilds) {
        if (!startFromChilds) {
            component.setEnabled(enabled);
        }
        if (component instanceof Container) {
            if (!startFromChilds && SwingUtils.isHandlesEnableState(component)) {
                return;
            }
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setEnabledRecursively(child, enabled, false);
            }
        }
    }

    public static List<Component> disableRecursively(Component component, boolean startFromChilds, boolean excludePanels, Component ... excluded) {
        return SwingUtils.disableRecursively(component, startFromChilds, excludePanels, Arrays.asList(excluded));
    }

    public static List<Component> disableRecursively(Component component, boolean startFromChilds, boolean excludePanels, List<Component> excluded) {
        ArrayList<Component> disabled = new ArrayList<Component>();
        SwingUtils.disableRecursively(component, startFromChilds, excludePanels, excluded, disabled);
        return disabled;
    }

    private static void disableRecursively(Component component, boolean startFromChilds, boolean excludePanels, List<Component> excluded, List<Component> disabled) {
        boolean b;
        boolean bl = b = !startFromChilds && !excluded.contains(component) && (!(component instanceof JPanel) || !excludePanels);
        if (b && component.isEnabled()) {
            component.setEnabled(false);
            disabled.add(component);
        }
        if (component instanceof Container) {
            if (b && SwingUtils.isHandlesEnableState(component)) {
                return;
            }
            Container container = (Container)component;
            for (Component child : container.getComponents()) {
                SwingUtils.disableRecursively(child, false, excludePanels, excluded, disabled);
            }
        }
    }

    public static void enable(List<Component> disabled) {
        for (Component component : disabled) {
            component.setEnabled(true);
        }
    }

    public static void setFocusableRecursively(JComponent component, boolean focusable) {
        SwingUtils.setFocusableRecursively(component, focusable, false);
    }

    public static void setFocusableRecursively(JComponent component, boolean focusable, boolean childsOnly) {
        if (!childsOnly) {
            component.setFocusable(focusable);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setFocusableRecursively((JComponent)component.getComponent(i), focusable, false);
        }
    }

    public static void setBackgroundRecursively(Component component, Color bg) {
        SwingUtils.setBackgroundRecursively(component, bg, false);
    }

    public static void setBackgroundRecursively(Component component, Color bg, boolean childsOnly) {
        if (!childsOnly) {
            component.setBackground(bg);
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                SwingUtils.setBackgroundRecursively(child, bg, false);
            }
        }
    }

    public static void setForegroundRecursively(JComponent component, Color foreground) {
        SwingUtils.setForegroundRecursively(component, foreground, false);
    }

    public static void setForegroundRecursively(JComponent component, Color foreground, boolean childsOnly) {
        if (!childsOnly) {
            component.setForeground(foreground);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setForegroundRecursively((JComponent)component.getComponent(i), foreground, false);
        }
    }

    public static void setFontRecursively(JComponent component, Font font) {
        SwingUtils.setFontRecursively(component, font, false);
    }

    public static void setFontRecursively(JComponent component, Font font, boolean childsOnly) {
        if (!childsOnly) {
            component.setFont(font);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            SwingUtils.setFontRecursively((JComponent)component.getComponent(i), font, false);
        }
    }

    public static BufferedImage createComponentSnapshot(Component content) {
        return SwingUtils.createComponentSnapshot(content, content.getWidth(), content.getHeight());
    }

    public static BufferedImage createComponentSnapshot(Component content, int width, int height) {
        BufferedImage bi = ImageUtils.createCompatibleImage(width, height, 3);
        if (content != null) {
            Graphics2D g2d = bi.createGraphics();
            content.setSize(width, height);
            content.paintAll(g2d);
            g2d.dispose();
        }
        return bi;
    }

    public static void setAccelerator(JMenuItem menuItem, HotkeyData hotkey) {
        if (hotkey != null && hotkey.isHotkeySet()) {
            int ctrl = hotkey.isCtrl() ? SwingUtils.getSystemShortcutModifier() : 0;
            int alt = hotkey.isAlt() ? 8 : 0;
            int shift = hotkey.isShift() ? 1 : 0;
            menuItem.setAccelerator(KeyStroke.getKeyStroke(hotkey.getKeyCode(), ctrl | alt | shift));
        }
    }

    public static Window getActiveWindow() {
        Window[] windows = Window.getWindows();
        Window window = null;
        for (Window w : windows) {
            if (!w.isVisible() || !w.isActive() || !w.isFocused()) continue;
            window = w;
            break;
        }
        return window;
    }

    public static boolean isShortcut(InputEvent event) {
        return (event.getModifiers() & SwingUtils.getSystemShortcutModifier()) != 0;
    }

    public static int getSystemShortcutModifier() {
        if (systemShortcutModifier == null) {
            systemShortcutModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return systemShortcutModifier;
    }

    public static String hotkeyToString(KeyEvent keyEvent) {
        return SwingUtils.hotkeyToString(SwingUtils.isCtrl(keyEvent), SwingUtils.isAlt(keyEvent), SwingUtils.isShift(keyEvent), keyEvent.getKeyCode());
    }

    public static String hotkeyToString(HotkeyData hotkeyData) {
        return SwingUtils.hotkeyToString(hotkeyData.isCtrl(), hotkeyData.isAlt(), hotkeyData.isShift(), hotkeyData.getKeyCode());
    }

    public static String hotkeyToString(KeyStroke keyStroke) {
        return SwingUtils.hotkeyToString(SwingUtils.isCtrl(keyStroke.getModifiers()), SwingUtils.isAlt(keyStroke.getModifiers()), SwingUtils.isShift(keyStroke.getModifiers()), keyStroke.getKeyCode());
    }

    public static String hotkeyToString(boolean isCtrl, boolean isAlt, boolean isShift, Integer keyCode) {
        return "" + (isCtrl ? KeyEvent.getKeyModifiersText(SwingUtils.getSystemShortcutModifier()) + (isAlt || isShift || keyCode != null ? "+" : "") : "") + (isAlt ? KeyEvent.getKeyModifiersText(8) + (isShift || keyCode != null ? "+" : "") : "") + (isShift ? KeyEvent.getKeyModifiersText(1) + (keyCode != null ? "+" : "") : "") + (keyCode != null ? KeyEvent.getKeyText(keyCode) : "");
    }

    public static boolean isCtrl(InputEvent event) {
        return SwingUtils.isCtrl(event.getModifiers());
    }

    public static boolean isCtrl(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isAlt(InputEvent event) {
        return SwingUtils.isAlt(event.getModifiers());
    }

    public static boolean isAlt(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isShift(InputEvent event) {
        return SwingUtils.isShift(event.getModifiers());
    }

    public static boolean isShift(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static HotkeyData getHotkeyData(KeyStroke keyStroke) {
        int m = keyStroke.getModifiers();
        return new HotkeyData(SwingUtils.isCtrl(m), SwingUtils.isAlt(m), SwingUtils.isShift(m), keyStroke.getKeyCode());
    }

    public static Font getDefaultLabelFont() {
        if (label == null) {
            label = new JLabel();
        }
        return label.getFont();
    }

    public static JScrollPane getScrollPane(Component component) {
        if (component != null && component.getParent() != null && component.getParent() instanceof JViewport && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
            return (JScrollPane)component.getParent().getParent();
        }
        return null;
    }

    public static Component findFocusableComponent(Container container) {
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy.getFirstComponent(container);
        }
        for (Component component : container.getComponents()) {
            Component focusable;
            if (component.isFocusable()) {
                return component;
            }
            if (!(component instanceof Container) || (focusable = SwingUtils.findFocusableComponent((Container)component)) == null) continue;
            return focusable;
        }
        return null;
    }

    public static List<Component> findComponentsWithText(String text, Component component) {
        return SwingUtils.findComponentsWithText(text, component, new ArrayList<Component>());
    }

    public static List<Component> findComponentsWithText(String text, Component component, List<Component> components) {
        block34: {
            try {
                if (text == null || text.equals("")) {
                    return components;
                }
                if (component instanceof WebPathField || component instanceof WebFileChooserField || component instanceof WebDateField || component instanceof WebCalendar) {
                    for (Component child : ((Container)component).getComponents()) {
                        if (SwingUtils.findComponentsWithText(text, child).size() <= 0) continue;
                        components.add(component);
                        break block34;
                    }
                    break block34;
                }
                if (component instanceof WebCollapsiblePane) {
                    if (SwingUtils.findComponentsWithText(text, ((WebCollapsiblePane)component).getHeaderPanel()).size() > 0) {
                        components.add(component);
                    }
                } else if (component instanceof JComboBox) {
                    JComboBox comboBox = (JComboBox)component;
                    if (comboBox.getSelectedItem().toString().toLowerCase().contains(text.toLowerCase())) {
                        components.add(component);
                    } else if (comboBox.isEditable()) {
                        if (SwingUtils.findComponentsWithText(text, comboBox.getEditor().getEditorComponent()).size() > 0) {
                            components.add(component);
                        }
                    } else if (SwingUtils.findComponentsWithText(text, comboBox.getRenderer().getListCellRendererComponent(null, comboBox.getSelectedItem(), -1, true, true)).size() > 0) {
                        components.add(component);
                    }
                } else if (component instanceof JSpinner) {
                    if (((JSpinner)component).getValue().toString().toLowerCase().contains(text.toLowerCase())) {
                        components.add(component);
                    }
                } else if (component instanceof JLabel) {
                    if (((JLabel)component).getText().toLowerCase().contains(text.toLowerCase())) {
                        components.add(component);
                    }
                } else if (component instanceof AbstractButton) {
                    if (((AbstractButton)component).getText().toLowerCase().contains(text.toLowerCase())) {
                        components.add(component);
                    }
                } else if (component instanceof JTextComponent) {
                    if (((JTextComponent)component).getText().toLowerCase().contains(text.toLowerCase())) {
                        if (component.getParent() != null && component.getParent().getParent() != null && component.getParent().getParent() instanceof JScrollPane) {
                            components.add(component.getParent().getParent());
                        } else {
                            components.add(component);
                        }
                    }
                } else if (component instanceof JTabbedPane) {
                    JTabbedPane tp = (JTabbedPane)component;
                    for (int i = 0; i < tp.getTabCount(); ++i) {
                        if (!(tp.getComponentAt(i) instanceof Container)) continue;
                        SwingUtils.checkContent(text, (Container)tp.getComponentAt(i), components);
                    }
                } else if (component instanceof Container) {
                    SwingUtils.checkContent(text, (Container)component, components);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return components;
    }

    private static void checkContent(String text, Container container, List<Component> components) {
        for (Component child : container.getComponents()) {
            SwingUtils.findComponentsWithText(text, child, components);
        }
    }

    public static Rectangle getBoundsOnScreen(Component component) {
        return new Rectangle(component.getLocationOnScreen(), component.getSize());
    }

    public static Rectangle getBoundsInWindow(Component component) {
        return component instanceof Window || component instanceof JApplet ? SwingUtils.getRootPane(component).getBounds() : SwingUtils.getRelativeBounds(component, SwingUtils.getRootPane(component));
    }

    public static Rectangle getRelativeBounds(Component component, Component relativeTo) {
        return new Rectangle(SwingUtils.getRelativeLocation(component, relativeTo), component.getSize());
    }

    public static Point getRelativeLocation(Component component, Component relativeTo) {
        Point los = component.getLocationOnScreen();
        Point rt = relativeTo.getLocationOnScreen();
        return new Point(los.x - rt.x, los.y - rt.y);
    }

    public static boolean isSameAncestor(Component component1, Component component2) {
        return SwingUtils.getWindowAncestor(component1) == SwingUtils.getWindowAncestor(component2);
    }

    public static Map<Component, Dimension> getChildPreferredSizes(Container container) {
        int cc = container.getComponentCount();
        HashMap<Component, Dimension> cps = new HashMap<Component, Dimension>(cc);
        for (int i = 0; i < cc; ++i) {
            Component component = container.getComponent(i);
            cps.put(component, component.getPreferredSize());
        }
        return cps;
    }

    public static void equalizeComponentsSize(Component ... components) {
        Dimension maxSize = new Dimension(0, 0);
        for (Component c : components) {
            if (c == null) continue;
            Dimension ps = c.getPreferredSize();
            maxSize.width = Math.max(maxSize.width, ps.width);
            maxSize.height = Math.max(maxSize.height, ps.height);
        }
        for (Component c : components) {
            if (c == null) continue;
            c.setPreferredSize(maxSize);
        }
    }

    public static void equalizeComponentsWidths(Component ... components) {
        int maxWidth = 0;
        for (Component c : components) {
            if (c == null) continue;
            maxWidth = Math.max(maxWidth, c.getPreferredSize().width);
        }
        for (Component c : components) {
            if (c == null) continue;
            if (c instanceof SizeMethods) {
                ((SizeMethods)((Object)c)).setPreferredWidth(maxWidth);
                continue;
            }
            c.setPreferredSize(new Dimension(maxWidth, c.getPreferredSize().height));
        }
    }

    public static void equalizeComponentsHeights(Component ... components) {
        int maxHeight = 0;
        for (Component c : components) {
            if (c == null) continue;
            maxHeight = Math.max(maxHeight, c.getPreferredSize().height);
        }
        for (Component c : components) {
            if (c == null) continue;
            if (c instanceof SizeMethods) {
                ((SizeMethods)((Object)c)).setPreferredHeight(maxHeight);
                continue;
            }
            c.setPreferredSize(new Dimension(c.getPreferredSize().width, maxHeight));
        }
    }

    public static boolean isEqualOrChild(Component component1, Component component2) {
        if (component1 == component2) {
            return true;
        }
        if (component1 instanceof Container) {
            for (Component c : ((Container)component1).getComponents()) {
                if (!SwingUtils.isEqualOrChild(c, component2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean hasFocusOwner(Component component) {
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        return component == focusOwner || component instanceof Container && ((Container)component).isAncestorOf(focusOwner);
    }

    public static boolean hasFocusableComponent(Container container) {
        for (Component component : container.getComponents()) {
            if (component.isFocusable()) {
                return true;
            }
            if (!(component instanceof Container) || !SwingUtils.hasFocusableComponent((Container)component)) continue;
            return true;
        }
        return false;
    }

    public static String[] getFontNames() {
        if (fontNames == null) {
            fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return fontNames;
    }

    public static Font[] getFonts() {
        if (fonts == null) {
            fonts = SwingUtils.createFonts(SwingUtils.getFontNames());
        }
        return fonts;
    }

    public static Font[] createFonts(String[] fontNames) {
        Font[] fonts = new Font[fontNames.length];
        for (int i = 0; i < fontNames.length; ++i) {
            fonts[i] = new Font(fontNames[i], 0, 13);
        }
        return fonts;
    }

    public static void delayInvokeLater(long delay, final Runnable runnable) {
        WebTimer.delay("delayInvokeLater", delay, false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtils.invokeLater(runnable);
            }
        });
    }

    public static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeLater(final HotkeyRunnable runnable, final KeyEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run(e);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run(e);
                }
            });
        }
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static void invokeAndWaitSafely(Runnable runnable) {
        try {
            SwingUtils.invokeAndWait(runnable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Insets toRTL(Insets insets) {
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    public static Point getMousePoint(Component component) {
        Point p = MouseInfo.getPointerInfo().getLocation();
        Point los = component.getLocationOnScreen();
        return new Point(p.x - los.x, p.y - los.y);
    }

    public static void scrollSmoothly(JScrollPane scrollPane, int xValue, int yValue) {
        final JScrollBar hor = scrollPane.getHorizontalScrollBar();
        final JScrollBar ver = scrollPane.getVerticalScrollBar();
        Dimension viewportSize = scrollPane.getViewport().getSize();
        xValue = xValue > hor.getMaximum() - viewportSize.width ? hor.getMaximum() - viewportSize.width : xValue;
        yValue = yValue > ver.getMaximum() - viewportSize.height ? ver.getMaximum() - viewportSize.height : yValue;
        final int x = xValue < 0 ? 0 : xValue;
        final int y = yValue < 0 ? 0 : yValue;
        final int xSign = hor.getValue() > x ? -1 : 1;
        final int ySign = ver.getValue() > y ? -1 : 1;
        new Thread(new Runnable(){

            @Override
            public void run() {
                scrollThread1 = Thread.currentThread();
                int lastValue = hor.getValue();
                while (lastValue != x) {
                    if (scrollThread1 != Thread.currentThread()) {
                        Thread.currentThread().interrupt();
                    }
                    if (lastValue != x) {
                        int value;
                        lastValue = value = lastValue + xSign * Math.max(Math.abs(lastValue - x) / 4, 1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                hor.setValue(value);
                            }
                        });
                        if (xSign < 0 && value == hor.getMinimum() || xSign > 0 && value == hor.getMaximum()) break;
                    }
                    ThreadUtils.sleepSafely(25L);
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                scrollThread2 = Thread.currentThread();
                int lastValue = ver.getValue();
                while (lastValue != y) {
                    if (scrollThread2 != Thread.currentThread()) {
                        Thread.currentThread().interrupt();
                    }
                    if (lastValue != y) {
                        int value;
                        lastValue = value = lastValue + ySign * Math.max(Math.abs(lastValue - y) / 4, 1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ver.setValue(value);
                            }
                        });
                        if (ySign < 0 && value == ver.getMinimum() || ySign > 0 && value == ver.getMaximum()) break;
                    }
                    ThreadUtils.sleepSafely(25L);
                }
            }
        }).start();
    }

    public static void drawStringUnderlineCharAt(Graphics g, String text, int underlinedIndex, int x, int y) {
        SwingUtils.drawString(g, text, x, y);
        if (underlinedIndex >= 0 && underlinedIndex < text.length()) {
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(x + fm.stringWidth(text.substring(0, underlinedIndex)), y + fm.getDescent() - 1, fm.charWidth(text.charAt(underlinedIndex)), 1);
        }
    }

    public static void drawString(Graphics g, String text, int x, int y) {
        g.drawString(text, x, y);
    }

    public static Map setupTextAntialias(Graphics g) {
        return SwingUtils.setupTextAntialias((Graphics2D)g);
    }

    public static Map setupTextAntialias(Graphics2D g2d) {
        return SwingUtils.setupTextAntialias(g2d, StyleConstants.textRenderingHints);
    }

    public static Map setupTextAntialias(Graphics g, Map hints) {
        return SwingUtils.setupTextAntialias((Graphics2D)g, hints);
    }

    public static Map setupTextAntialias(Graphics2D g2d, Map hints) {
        if (hints != null) {
            Map oldHints = SwingUtils.getRenderingHints(g2d, hints, null);
            g2d.addRenderingHints(hints);
            return oldHints;
        }
        return null;
    }

    public static void restoreTextAntialias(Graphics g, Map hints) {
        SwingUtils.restoreTextAntialias((Graphics2D)g, hints);
    }

    public static void restoreTextAntialias(Graphics2D g2d, Map hints) {
        if (hints != null) {
            g2d.addRenderingHints(hints);
        }
    }

    private static Map getRenderingHints(Graphics2D g2d, Map hintsToSave, Map savedHints) {
        if (savedHints == null) {
            savedHints = new RenderingHints(null);
        } else {
            savedHints.clear();
        }
        if (hintsToSave == null || hintsToSave.size() == 0) {
            return savedHints;
        }
        Set objects = hintsToSave.keySet();
        for (Object o : objects) {
            RenderingHints.Key key = (RenderingHints.Key)o;
            Object value = g2d.getRenderingHint(key);
            if (value == null) continue;
            savedHints.put(key, value);
        }
        return savedHints;
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g) {
        return SwingUtils.getFontMetrics(c, g, g.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return g.getFontMetrics(font);
    }

    public static int stringWidth(FontMetrics fm, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fm.stringWidth(string);
    }

    public static int getLeftSideBearing(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return SwingUtils.getLeftSideBearing(c, fm, string.charAt(0));
    }

    public static int getLeftSideBearing(JComponent c, FontMetrics fm, char firstChar) {
        return SwingUtils.getBearing(c, fm, firstChar, true);
    }

    public static int getRightSideBearing(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return SwingUtils.getRightSideBearing(c, fm, string.charAt(string.length() - 1));
    }

    public static int getRightSideBearing(JComponent c, FontMetrics fm, char lastChar) {
        return SwingUtils.getBearing(c, fm, lastChar, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getBearing(JComponent comp, FontMetrics fm, char c, boolean isLeftBearing) {
        if (fm == null) {
            if (comp == null) {
                return 0;
            }
            fm = comp.getFontMetrics(comp.getFont());
        }
        Class<SwingUtils> clazz = SwingUtils.class;
        synchronized (SwingUtils.class) {
            BearingCacheEntry searchKey = new BearingCacheEntry(fm);
            BearingCacheEntry entry = null;
            for (BearingCacheEntry cacheEntry : strongBearingCache) {
                if (!searchKey.equals(cacheEntry)) continue;
                entry = cacheEntry;
                break;
            }
            if (entry == null) {
                Iterator<SoftReference<BearingCacheEntry>> iter = softBearingCache.iterator();
                while (iter.hasNext()) {
                    BearingCacheEntry cacheEntry = iter.next().get();
                    if (cacheEntry == null) {
                        iter.remove();
                        continue;
                    }
                    if (!searchKey.equals(cacheEntry)) continue;
                    entry = cacheEntry;
                    SwingUtils.putEntryInStrongCache(entry);
                    break;
                }
            }
            if (entry == null) {
                entry = searchKey;
                SwingUtils.cacheEntry(entry);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return isLeftBearing ? entry.getLeftSideBearing(c) : entry.getRightSideBearing(c);
        }
    }

    private static synchronized void cacheEntry(BearingCacheEntry entry) {
        BearingCacheEntry oldestEntry = strongBearingCache[strongBearingCacheNextIndex];
        if (oldestEntry != null) {
            softBearingCache.add(new SoftReference<BearingCacheEntry>(oldestEntry));
        }
        SwingUtils.putEntryInStrongCache(entry);
    }

    private static synchronized void putEntryInStrongCache(BearingCacheEntry entry) {
        SwingUtils.strongBearingCache[SwingUtils.strongBearingCacheNextIndex] = entry;
        strongBearingCacheNextIndex = (strongBearingCacheNextIndex + 1) % 10;
    }

    static {
        strongBearingCache = new BearingCacheEntry[10];
        strongBearingCacheNextIndex = 0;
        softBearingCache = new HashSet<SoftReference<BearingCacheEntry>>();
    }

    private static class BearingCacheEntry {
        private final FontMetrics fontMetrics;
        private final Font font;
        private final FontRenderContext frc;
        private final Map<Character, Short> cache;
        private static final char[] oneChar = new char[1];

        public BearingCacheEntry(FontMetrics fontMetrics) {
            this.fontMetrics = fontMetrics;
            this.font = fontMetrics.getFont();
            this.frc = fontMetrics.getFontRenderContext();
            this.cache = new HashMap<Character, Short>();
            assert (this.font != null && this.frc != null);
        }

        public int getLeftSideBearing(char aChar) {
            Short bearing = this.cache.get(Character.valueOf(aChar));
            if (bearing == null) {
                bearing = this.calcBearing(aChar);
                this.cache.put(Character.valueOf(aChar), bearing);
            }
            return ((0xFF00 & bearing) >>> 8) - 127;
        }

        public int getRightSideBearing(char aChar) {
            Short bearing = this.cache.get(Character.valueOf(aChar));
            if (bearing == null) {
                bearing = this.calcBearing(aChar);
                this.cache.put(Character.valueOf(aChar), bearing);
            }
            return (0xFF & bearing) - 127;
        }

        private short calcBearing(char aChar) {
            Object aaHint;
            BearingCacheEntry.oneChar[0] = aChar;
            GlyphVector gv = this.font.createGlyphVector(this.frc, oneChar);
            Rectangle pixelBounds = gv.getGlyphPixelBounds(0, this.frc, 0.0f, 0.0f);
            int lsb = pixelBounds.x;
            int rsb = pixelBounds.width - this.fontMetrics.charWidth(aChar);
            if (lsb < 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                ++lsb;
            }
            if (rsb > 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                --rsb;
            }
            if (lsb < -127 || lsb > 127) {
                lsb = 0;
            }
            if (rsb < -127 || rsb > 127) {
                rsb = 0;
            }
            int bearing = (lsb + 127 << 8) + (rsb + 127);
            return (short)bearing;
        }

        public boolean equals(Object entry) {
            if (entry == this) {
                return true;
            }
            if (!(entry instanceof BearingCacheEntry)) {
                return false;
            }
            BearingCacheEntry oEntry = (BearingCacheEntry)entry;
            return this.font.equals(oEntry.font) && this.frc.equals(oEntry.frc);
        }

        public int hashCode() {
            int result = 17;
            if (this.font != null) {
                result = 37 * result + this.font.hashCode();
            }
            if (this.frc != null) {
                result = 37 * result + this.frc.hashCode();
            }
            return result;
        }
    }
}

