/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import java.util.WeakHashMap;

public final class SizeUtils {
    private static final Map<Component, Dimension> preferredSizeCache = new WeakHashMap<Component, Dimension>();
    private static final Map<Component, Dimension> minimumSizeCache = new WeakHashMap<Component, Dimension>();

    public static <C extends Component> int getPreferredWidth(C component) {
        Dimension ps = preferredSizeCache.get(component);
        return ps != null ? ps.width : -1;
    }

    public static <C extends Component> C setPreferredWidth(C component, int preferredWidth) {
        Dimension ps = preferredSizeCache.get(component);
        if (ps == null) {
            ps = new Dimension(preferredWidth, -1);
            preferredSizeCache.put(component, ps);
        } else {
            ps.width = preferredWidth;
        }
        return component;
    }

    public static <C extends Component> int getPreferredHeight(C component) {
        Dimension ps = preferredSizeCache.get(component);
        return ps != null ? ps.height : -1;
    }

    public static <C extends Component> C setPreferredHeight(C component, int preferredHeight) {
        Dimension ps = preferredSizeCache.get(component);
        if (ps == null) {
            ps = new Dimension(-1, preferredHeight);
            preferredSizeCache.put(component, ps);
        } else {
            ps.height = preferredHeight;
        }
        return component;
    }

    public static <C extends Component> int getMinimumWidth(C component) {
        Dimension ms = minimumSizeCache.get(component);
        return ms != null ? ms.width : -1;
    }

    public static <C extends Component> C setMinimumWidth(C component, int minimumWidth) {
        Dimension ms = minimumSizeCache.get(component);
        if (ms == null) {
            ms = new Dimension(minimumWidth, -1);
            minimumSizeCache.put(component, ms);
        } else {
            ms.width = minimumWidth;
        }
        return component;
    }

    public static <C extends Component> int getMinimumHeight(C component) {
        Dimension ms = minimumSizeCache.get(component);
        return ms != null ? ms.height : -1;
    }

    public static <C extends Component> C setMinimumHeight(C component, int minimumHeight) {
        Dimension ms = minimumSizeCache.get(component);
        if (ms == null) {
            ms = new Dimension(-1, minimumHeight);
            minimumSizeCache.put(component, ms);
        } else {
            ms.height = minimumHeight;
        }
        return component;
    }

    public static <C extends Component> Dimension getPreferredSize(C component, Dimension actualPreferredSize) {
        Dimension ps = preferredSizeCache.get(component);
        Dimension ms = minimumSizeCache.get(component);
        Dimension preferredSize = new Dimension(actualPreferredSize);
        if (ps != null && ps.width != -1) {
            preferredSize.width = ps.width;
        } else if (ms != null && ms.width != -1) {
            preferredSize.width = Math.max(ms.width, preferredSize.width);
        }
        if (ps != null && ps.height != -1) {
            preferredSize.height = ps.height;
        } else if (ms != null && ms.height != -1) {
            preferredSize.height = Math.max(ms.height, preferredSize.height);
        }
        return preferredSize;
    }
}

