/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Tag;

public final class HtmlUtils {
    public static String getPlainText(String html) {
        Source source = new Source(html);
        Tag[] tags = source.fullSequentialParse();
        if (tags.length > 0) {
            Renderer renderer = source.getRenderer();
            renderer.setIncludeHyperlinkURLs(false);
            renderer.setIncludeAlternateText(false);
            renderer.setDecorateFontStyles(false);
            renderer.setMaxLineLength(Integer.MAX_VALUE);
            renderer.setBlockIndentSize(4);
            renderer.setConvertNonBreakingSpaces(false);
            renderer.setNewLine("\n");
            return renderer.toString();
        }
        return html;
    }

    public static String bold(String text) {
        return "<html><b>" + text + "</b></html>";
    }

    public static boolean hasTags(String text) {
        return text != null && text.trim().length() > 0 && new Source(text).fullSequentialParse().length > 0;
    }

    public static boolean hasHtml(String text) {
        return HtmlUtils.hasTag(text, "html");
    }

    public static boolean hasTag(String text, String tag) {
        if (text != null && text.trim().length() > 0) {
            Source source = new Source(text);
            source.fullSequentialParse();
            return source.getFirstElement(tag) != null;
        }
        return false;
    }

    public static String getContent(String text) {
        String lowerCaseText = text.toLowerCase();
        String bodyTag = "<body>";
        int body = lowerCaseText.indexOf("<body>");
        int bodyEnd = lowerCaseText.indexOf("</body>");
        if (body != -1 && bodyEnd != -1) {
            return text.substring(body + "<body>".length(), bodyEnd);
        }
        String htmlTag = "<html>";
        int html = lowerCaseText.indexOf("<body>");
        int htmlEnd = lowerCaseText.indexOf("</html>");
        if (html != -1 && htmlEnd != -1) {
            return text.substring(html + "<html>".length(), htmlEnd);
        }
        return text;
    }

    public static String convertToMultilineHtml(String text, String ... lineBreak) {
        String body = text;
        for (String divider : lineBreak) {
            body = body.replaceAll(divider, "<br>");
        }
        return "<html>" + body + "</html>";
    }
}

