/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public final class DragUtils {
    public static final String URI_LIST_MIME_TYPE = "text/uri-list;class=java.lang.String";
    public static final String uriListSeparator = "\r\n";
    private static DataFlavor uriListFlavor = null;

    public static Image getImportedImage(Transferable t) {
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Object data = t.getTransferData(DataFlavor.imageFlavor);
                if (data instanceof Image) {
                    return (Image)data;
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<File> getImportedFiles(Transferable t) {
        try {
            if (DragUtils.hasURIListFlavor(t.getTransferDataFlavors())) {
                return DragUtils.textURIListToFileList((String)t.getTransferData(DragUtils.getUriListDataFlavor()));
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (DragUtils.hasURIListFlavor(t.getTransferDataFlavors())) {
                String url = (String)t.getTransferData(DragUtils.getUriListDataFlavor());
                File file = new File(new URL(url).getPath());
                return Arrays.asList(file);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, uriListSeparator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                list.add(new File(new URI(s)));
            }
            catch (Throwable e) {}
        }
        return list;
    }

    public static String fileListToTextURIList(List<File> files) {
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            sb.append(file.toURI().toASCIIString());
            sb.append(uriListSeparator);
        }
        return sb.toString();
    }

    public static boolean hasURIListFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!DragUtils.getUriListDataFlavor().equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public static DataFlavor getUriListDataFlavor() {
        if (uriListFlavor == null) {
            try {
                uriListFlavor = new DataFlavor(URI_LIST_MIME_TYPE);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return uriListFlavor;
    }

    public static boolean canPassDrop(TransferHandler.TransferSupport info) {
        return DragUtils.canPassDrop(info.getComponent(), info);
    }

    public static boolean canPassDrop(Component component, TransferHandler.TransferSupport info) {
        Container parent = component.getParent();
        if (parent != null && parent instanceof JComponent) {
            TransferHandler th = ((JComponent)parent).getTransferHandler();
            return th != null ? th.canImport(info) : DragUtils.canPassDrop(parent, info);
        }
        return false;
    }

    public static boolean passDropAction(TransferHandler.TransferSupport info) {
        return DragUtils.passDropAction(info.getComponent(), info);
    }

    public static boolean passDropAction(Component component, TransferHandler.TransferSupport info) {
        Container parent = component.getParent();
        if (parent != null && parent instanceof JComponent) {
            TransferHandler th = ((JComponent)parent).getTransferHandler();
            return th != null ? th.importData(info) : DragUtils.passDropAction(parent, info);
        }
        return false;
    }
}

