/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.CompareUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class WindowSettingsProcessor
extends SettingsProcessor<Window, Rectangle> {
    private ComponentAdapter componentAdapter;

    public WindowSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    protected void doInit(Window window) {
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WindowSettingsProcessor.this.save();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WindowSettingsProcessor.this.save();
            }
        };
        window.addComponentListener(this.componentAdapter);
    }

    @Override
    protected void doDestroy(Window window) {
        window.removeComponentListener(this.componentAdapter);
        this.componentAdapter = null;
    }

    @Override
    protected void doLoad(Window window) {
        Rectangle bounds = (Rectangle)this.loadValue();
        if (bounds != null && !CompareUtils.equals(bounds, window.getBounds())) {
            Dimension size = bounds.getSize();
            if (size.width > 0 && size.height > 0) {
                window.setSize(size);
            } else {
                window.pack();
            }
            Point location = bounds.getLocation();
            if (location.x > 0 && location.y > 0) {
                window.setLocation(location);
            } else {
                window.setLocationRelativeTo(null);
            }
        }
    }

    @Override
    protected void doSave(Window window) {
        this.saveValue(window.getBounds());
    }
}

