/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.utils.xml.PasswordConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;

@XStreamAlias(value="ProxySettings")
public class ProxySettings
implements Serializable,
Cloneable {
    @XStreamAsAttribute
    private boolean useProxy = false;
    @XStreamAsAttribute
    private String proxyHost = null;
    @XStreamAsAttribute
    private String proxyPort = null;
    @XStreamAsAttribute
    private String nonProxyHosts = null;
    @XStreamAsAttribute
    private boolean useProxyAuthentification = false;
    @XStreamAsAttribute
    private String proxyLogin = null;
    @XStreamAsAttribute
    @XStreamConverter(value=PasswordConverter.class)
    private String proxyPassword = null;

    public ProxySettings() {
        this(null, null);
    }

    public ProxySettings(String proxyHost, String proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    public ProxySettings(String proxyHost, String proxyPort, String proxyLogin, String proxyPassword) {
        if (proxyHost != null && proxyPort != null) {
            this.useProxy = true;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            if (proxyLogin != null && proxyPassword != null) {
                this.useProxyAuthentification = true;
                this.proxyLogin = proxyLogin;
                this.proxyPassword = proxyPassword;
            } else {
                this.useProxyAuthentification = false;
            }
        } else {
            this.useProxy = false;
            this.useProxyAuthentification = false;
        }
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public int getProxyPortInt() {
        try {
            return Integer.parseInt(this.proxyPort);
        }
        catch (Throwable e) {
            return 80;
        }
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public boolean isUseProxyAuthentification() {
        return this.useProxyAuthentification;
    }

    public void setUseProxyAuthentification(boolean useProxyAuthentification) {
        this.useProxyAuthentification = useProxyAuthentification;
    }

    public String getProxyLogin() {
        return this.proxyLogin;
    }

    public void setProxyLogin(String proxyLogin) {
        this.proxyLogin = proxyLogin;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    protected ProxySettings clone() {
        ProxySettings proxySettings = new ProxySettings();
        proxySettings.setUseProxy(this.isUseProxy());
        proxySettings.setProxyHost(this.getProxyHost());
        proxySettings.setProxyPort(this.getProxyPort());
        proxySettings.setNonProxyHosts(this.getNonProxyHosts());
        proxySettings.setUseProxyAuthentification(this.isUseProxyAuthentification());
        proxySettings.setProxyLogin(this.getProxyLogin());
        proxySettings.setProxyPassword(this.getProxyPassword());
        return proxySettings;
    }
}

