/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.managers.proxy.ProxySettings;
import com.alee.managers.proxy.SystemProxyConfirmationSupport;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.CompareUtils;
import com.alee.utils.EncryptionUtils;
import com.alee.utils.XmlUtils;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;

public final class ProxyManager {
    public static String SETTINGS_GROUP = "ProxyManager";
    public static String PROXY_SETTINGS = "ProxySettings";
    public static String AUTO_SETTINGS_ON = "AutoSettingsOn";
    public static String ALWAYS_USE_SYSTEM_SETTINGS = "AlwaysUseSystemSettings";
    public static String SAVE_SETTINGS = "SaveSettings";
    private static boolean autoDetectionEnabled = false;
    private static Authenticator authenticator;
    private static boolean proxySet;
    private static SystemProxyConfirmationSupport systemProxyConfirmationSupport;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(ProxySettings.class);
            if (autoDetectionEnabled) {
                ProxySettings proxySettings = ProxyManager.getProxySettings();
                ProxySettings systemProxySettings = ProxyManager.getSystemProxySettings();
                if (proxySettings.isUseProxy() != systemProxySettings.isUseProxy() || !CompareUtils.equals(proxySettings.getProxyHost(), systemProxySettings.getProxyHost()) || !CompareUtils.equals(proxySettings.getProxyPort(), systemProxySettings.getProxyPort())) {
                    if (systemProxyConfirmationSupport == null || ProxyManager.isAutoSettingsInitialization()) {
                        if (ProxyManager.isAlwaysUseSystemSettings()) {
                            proxySettings = systemProxySettings;
                        }
                    } else {
                        boolean useSystemProxy = systemProxyConfirmationSupport.shouldUseSystemProxy();
                        if (useSystemProxy) {
                            proxySettings = systemProxySettings;
                        }
                        if (systemProxyConfirmationSupport.alwaysDoTheSame()) {
                            ProxyManager.setAutoSettingsInitialization(true);
                            ProxyManager.setAlwaysUseSystemSettings(useSystemProxy);
                        }
                    }
                }
                ProxyManager.setProxySettings(proxySettings);
            }
        }
    }

    public static boolean isAutoDetectionEnabled() {
        return autoDetectionEnabled;
    }

    public static void setAutoDetectionEnabled(boolean enabled) {
        autoDetectionEnabled = enabled;
    }

    public static Authenticator getAuthenticator() {
        return authenticator;
    }

    public static void setAuthenticator(Authenticator authenticator) {
        ProxyManager.authenticator = authenticator;
        if (initialized && ProxyManager.getProxySettings().isUseProxy()) {
            Authenticator.setDefault(authenticator);
        }
    }

    public static void setAutoSettingsInitialization(boolean enabled) {
        SettingsManager.set(SETTINGS_GROUP, AUTO_SETTINGS_ON, enabled);
    }

    public static boolean isAutoSettingsInitialization() {
        return SettingsManager.get(SETTINGS_GROUP, AUTO_SETTINGS_ON, false);
    }

    public static void setAlwaysUseSystemSettings(boolean useSystem) {
        SettingsManager.set(SETTINGS_GROUP, ALWAYS_USE_SYSTEM_SETTINGS, useSystem);
    }

    public static boolean isAlwaysUseSystemSettings() {
        return SettingsManager.get(SETTINGS_GROUP, ALWAYS_USE_SYSTEM_SETTINGS, false);
    }

    public static ProxySettings getProxySettings() {
        return SettingsManager.get(SETTINGS_GROUP, PROXY_SETTINGS, ProxyManager.getSystemProxySettings());
    }

    public static void setProxySettings() {
        if (!proxySet) {
            ProxyManager.setProxySettings(ProxyManager.getProxySettings());
        }
    }

    public static void setEmptyProxySettings() {
        ProxyManager.setProxySettings(new ProxySettings());
    }

    public static ProxySettings setSystemProxySettings() {
        ProxySettings proxySettings = ProxyManager.getSystemProxySettings();
        ProxyManager.setProxySettings(proxySettings);
        return proxySettings;
    }

    public static void setProxySettings(String host, String port) {
        ProxyManager.setProxySettings(new ProxySettings(host, port));
    }

    public static void setProxySettings(String host, String port, String login, String password) {
        ProxyManager.setProxySettings(new ProxySettings(host, port, login, password));
    }

    public static void setProxySettings(ProxySettings setttings) {
        ProxyManager.setProxySettings(setttings, true);
    }

    public static void setProxySettings(ProxySettings setttings, boolean save) {
        proxySet = true;
        if (save) {
            SettingsManager.set(SETTINGS_GROUP, PROXY_SETTINGS, setttings);
        }
        Properties systemSettings = System.getProperties();
        systemSettings.setProperty("proxySet", "" + setttings.isUseProxy());
        if (setttings.isUseProxy()) {
            systemSettings.setProperty("proxyHost", "" + setttings.getProxyHost());
            systemSettings.setProperty("proxyPort", "" + setttings.getProxyPort());
            systemSettings.setProperty("nonProxyHosts", "" + setttings.getNonProxyHosts());
            Authenticator.setDefault(authenticator);
        } else {
            systemSettings.setProperty("proxyHost", "");
            systemSettings.setProperty("proxyPort", "");
            systemSettings.setProperty("nonProxyHosts", "");
            Authenticator.setDefault(null);
        }
    }

    public static URLConnection getURLConnection(URL url) throws IOException {
        ProxyManager.setProxySettings();
        ProxySettings proxySettings = ProxyManager.getProxySettings();
        if (proxySettings.isUseProxy()) {
            URLConnection connection = url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.getProxyHost(), proxySettings.getProxyPortInt())));
            ProxyManager.setupProxy(connection);
            return connection;
        }
        return url.openConnection();
    }

    public static void setupProxy(URLConnection urlConnection) {
        ProxyManager.setProxySettings();
        ProxySettings proxySettings = ProxyManager.getProxySettings();
        if (proxySettings.isUseProxy() && proxySettings.isUseProxyAuthentification()) {
            String toEncode = proxySettings.getProxyLogin() + ":" + proxySettings.getProxyPassword();
            urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + EncryptionUtils.base64encode(toEncode));
        }
    }

    public static ProxySettings getSystemProxySettings() {
        InetSocketAddress addr;
        ProxySettings proxySettings = new ProxySettings();
        System.setProperty("java.net.useSystemProxies", "true");
        Proxy proxy = ProxyManager.getSystemHttpProxy();
        if (proxy != null && (addr = (InetSocketAddress)proxy.address()) != null && addr.getHostName() != null) {
            proxySettings.setUseProxy(true);
            proxySettings.setProxyHost(addr.getHostName());
            proxySettings.setProxyPort("" + addr.getPort());
        }
        System.setProperty("java.net.useSystemProxies", "false");
        return proxySettings;
    }

    private static Proxy getSystemHttpProxy() {
        try {
            ProxySelector def = ProxySelector.getDefault();
            List<Proxy> l = def.select(new URI("http://www.google.com"));
            for (Proxy proxy : l) {
                if (proxy == null || !proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
                return proxy;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static SystemProxyConfirmationSupport getSystemProxyConfirmationSupport() {
        return systemProxyConfirmationSupport;
    }

    public static void setSystemProxyConfirmationSupport(SystemProxyConfirmationSupport support) {
        systemProxyConfirmationSupport = support;
    }

    static {
        proxySet = false;
        systemProxyConfirmationSupport = null;
        initialized = false;
    }
}

