/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.plugin.data;

import com.alee.utils.CompareUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.Serializable;

@XStreamAlias(value="PluginVersion")
public class PluginVersion
implements Serializable {
    public static final PluginVersion DEFAULT = new PluginVersion(1, 0, 0);
    @XStreamAsAttribute
    private int major;
    @XStreamAsAttribute
    private int minor;
    @XStreamAsAttribute
    private Integer build;

    public PluginVersion() {
        this.major = PluginVersion.DEFAULT.major;
        this.minor = PluginVersion.DEFAULT.minor;
        this.build = PluginVersion.DEFAULT.build;
    }

    public PluginVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.build = null;
    }

    public PluginVersion(int major, int minor, Integer build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public Integer getBuild() {
        return this.build;
    }

    public void setBuild(Integer build) {
        this.build = build;
    }

    public boolean isNewerThan(PluginVersion ov) {
        return this.major > ov.major || this.major == ov.major && this.minor > ov.minor || this.major == ov.major && this.minor == ov.minor && this.build != null && ov.build == null || this.major == ov.major && this.minor == ov.minor && this.build == null && ov.build != null && this.build > ov.build;
    }

    public boolean isOlderThan(PluginVersion ov) {
        return ov.major > this.major || ov.major == this.major && ov.minor > this.minor || ov.major == this.major && ov.minor == this.minor && ov.build != null && this.build == null || ov.major == this.major && ov.minor == this.minor && ov.build != null && this.build != null && ov.build > this.build;
    }

    public boolean isSame(PluginVersion ov) {
        return ov.major == this.major && ov.minor == this.minor && CompareUtils.equals(ov.build, this.build);
    }

    public String toString() {
        return "v" + this.major + "." + this.minor + (this.build != null ? "." + this.build : "");
    }
}

