/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.language.data.ValueConverter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="value")
@XStreamConverter(value=ValueConverter.class)
public final class Value
implements Serializable,
Cloneable {
    private String lang;
    private Character mnemonic;
    private String hotkey;
    private List<Text> texts;
    private List<Tooltip> tooltips;

    public Value() {
    }

    public Value(String lang, String text) {
        this.lang = lang;
        this.texts = CollectionUtils.copy(new Text(text));
    }

    public Value(String lang, Character mnemonic, String text) {
        this.lang = lang;
        this.mnemonic = mnemonic;
        this.texts = CollectionUtils.copy(new Text(text));
    }

    public Value(String lang, String hotkey, String text) {
        this.lang = lang;
        this.hotkey = hotkey;
        this.texts = CollectionUtils.copy(new Text(text));
    }

    public Value(String lang, Character mnemonic, String hotkey, String text) {
        this.lang = lang;
        this.mnemonic = mnemonic;
        this.hotkey = hotkey;
        this.texts = CollectionUtils.copy(new Text(text));
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Character getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(Character mnemonic) {
        this.mnemonic = mnemonic;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String hotkey) {
        this.hotkey = hotkey;
    }

    public List<Text> getTexts() {
        return this.texts;
    }

    public void setTexts(List<Text> texts) {
        this.texts = texts;
    }

    public String getText() {
        return this.getText(null);
    }

    public String getText(String state) {
        return this.getText(state, false);
    }

    public String getText(String state, boolean defaultState) {
        Text text = this.getTextObject(state, defaultState);
        return text != null ? text.getText() : null;
    }

    public Text getTextObject() {
        return this.getTextObject(null);
    }

    public Text getTextObject(String state) {
        return this.getTextObject(state, false);
    }

    public Text getTextObject(String state, boolean defaultState) {
        if (this.texts != null) {
            for (Text text : this.texts) {
                if (!CompareUtils.equals(text.getState(), state) && (!defaultState || text.getState() != null)) continue;
                return text;
            }
        }
        return null;
    }

    public Text getTextObject(int index) {
        return this.texts.get(index);
    }

    public Text addText(String text) {
        return this.addText(new Text(text));
    }

    public Text addText(String text, String state) {
        return this.addText(new Text(text, state));
    }

    public Text addText(Text text) {
        if (this.texts == null) {
            this.texts = new ArrayList<Text>(1);
        }
        this.texts.add(text);
        return text;
    }

    public void removeText(Text text) {
        this.texts.remove(text);
    }

    public List<Tooltip> getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(List<Tooltip> tooltips) {
        this.tooltips = tooltips;
    }

    public Tooltip addTooltip(String text) {
        return this.addTooltip(new Tooltip(text));
    }

    public Tooltip addTooltip(Integer delay, String text) {
        return this.addTooltip(new Tooltip(delay, text));
    }

    public Tooltip addTooltip(TooltipWay way, String text) {
        return this.addTooltip(new Tooltip(way, text));
    }

    public Tooltip addTooltip(TooltipWay way, Integer delay, String text) {
        return this.addTooltip(new Tooltip(way, delay, text));
    }

    public Tooltip addTooltip(TooltipType type, String text) {
        return this.addTooltip(new Tooltip(type, text));
    }

    public Tooltip addTooltip(Tooltip tooltip) {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<Tooltip>(1);
        }
        this.tooltips.add(tooltip);
        return tooltip;
    }

    public void removeTooltip(Tooltip tooltip) {
        this.tooltips.remove(tooltip);
    }

    public Tooltip getTooltipObject(int index) {
        return this.tooltips.get(index);
    }

    private String langText() {
        return this.lang != null ? this.lang : "all";
    }

    private String listTexts() {
        if (this.texts == null || this.texts.size() == 0) {
            return "";
        }
        if (this.texts.size() == 1) {
            return this.texts.get(0).toString();
        }
        return "{" + TextUtils.listToString(this.texts, ";") + "}";
    }

    public Value clone() {
        Value value = new Value();
        value.setLang(this.lang);
        value.setMnemonic(this.mnemonic);
        value.setHotkey(this.hotkey);
        value.setTexts(this.texts != null ? CollectionUtils.clone(this.texts) : null);
        value.setTooltips(this.tooltips != null ? CollectionUtils.clone(this.tooltips) : null);
        return value;
    }

    public String toString() {
        return this.langText() + " -> " + this.listTexts() + (this.mnemonic != null ? " (" + this.mnemonic + ")" : "") + (this.hotkey != null ? " (" + this.hotkey + ")" : "") + (this.tooltips != null && this.tooltips.size() > 0 ? " (tooltips: " + this.tooltips.size() + ")" : "");
    }
}

