/*
 * Decompiled with CFR 0.152.
 */
package com.alee.log;

import com.alee.utils.ReflectUtils;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private static final Map<Class, Logger> loggers = new WeakHashMap<Class, Logger>();
    private static final Object logLock = new Object();
    private static boolean debugEnabled = false;
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            System.setProperty("org.slf4j.simpleLogger.logFile", "System.out");
            System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDebugEnabled(boolean debugEnabled) {
        Object object = logLock;
        synchronized (object) {
            Log.debugEnabled = debugEnabled;
        }
    }

    public static void info(String message, Object ... data) {
        Log.info(ReflectUtils.getCallerClass(), message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(Object logFor, String message, Object ... data) {
        Object object = logLock;
        synchronized (object) {
            String msg = data == null || data.length == 0 ? message : String.format(message, data);
            Log.getLogger(logFor).info(msg);
        }
    }

    public static void debug(String message, Object ... data) {
        Log.debug(ReflectUtils.getCallerClass(), message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(Object logFor, String message, Object ... data) {
        Object object = logLock;
        synchronized (object) {
            if (debugEnabled) {
                String msg = data == null || data.length == 0 ? message : String.format(message, data);
                Log.getLogger(logFor).debug(msg);
            }
        }
    }

    public static void warn(String message) {
        Log.warn(ReflectUtils.getCallerClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warn(Object logFor, String message) {
        Object object = logLock;
        synchronized (object) {
            Log.getLogger(logFor).warn(message);
        }
    }

    public static void warn(String message, Throwable throwable) {
        Log.warn(ReflectUtils.getCallerClass(), message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warn(Object logFor, String message, Throwable throwable) {
        Object object = logLock;
        synchronized (object) {
            Log.getLogger(logFor).warn(message, throwable);
        }
    }

    public static void error(Throwable throwable) {
        Log.error((Object)ReflectUtils.getCallerClass(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Object logFor, Throwable throwable) {
        Object object = logLock;
        synchronized (object) {
            Log.getLogger(logFor).error(throwable.toString(), throwable);
        }
    }

    public static void error(String message, Throwable throwable) {
        Log.error(ReflectUtils.getCallerClass(), message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Object logFor, String message, Throwable throwable) {
        Object object = logLock;
        synchronized (object) {
            Log.getLogger(logFor).error(message, throwable);
        }
    }

    public static void error(String message) {
        Log.error((Object)ReflectUtils.getCallerClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Object logFor, String message) {
        Object object = logLock;
        synchronized (object) {
            Log.getLogger(logFor).error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Object object) {
        Object object2 = logLock;
        synchronized (object2) {
            Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
            Logger logger = loggers.get(type);
            if (logger == null) {
                logger = LoggerFactory.getLogger(type);
                loggers.put(type, logger);
            }
            return logger;
        }
    }
}

