/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class TreeUtils {
    public static TreeState getTreeState(JTree tree) {
        return TreeUtils.getTreeState(tree, true);
    }

    public static TreeState getTreeState(JTree tree, boolean saveSelection) {
        Object root = tree.getModel().getRoot();
        if (!(root instanceof UniqueNode)) {
            throw new RuntimeException("To get tree state you must use UniqueNode or any class that extends it as tree elements!");
        }
        TreeState treeState = new TreeState();
        ArrayList<UniqueNode> elements = new ArrayList<UniqueNode>();
        elements.add((UniqueNode)root);
        while (elements.size() > 0) {
            UniqueNode element = (UniqueNode)elements.get(0);
            TreePath path = new TreePath(element.getPath());
            treeState.addState(element.getId(), tree.isExpanded(path), saveSelection && tree.isPathSelected(path));
            for (int i = 0; i < element.getChildCount(); ++i) {
                elements.add((UniqueNode)element.getChildAt(i));
            }
            elements.remove(element);
        }
        return treeState;
    }

    public static void setTreeState(JTree tree, TreeState treeState) {
        TreeUtils.setTreeState(tree, treeState, true);
    }

    public static void setTreeState(JTree tree, TreeState treeState, boolean restoreSelection) {
        Object root = tree.getModel().getRoot();
        if (!(root instanceof UniqueNode)) {
            throw new RuntimeException("To set tree state you must use UniqueNode or any class that extends it as tree elements!");
        }
        if (treeState == null) {
            return;
        }
        tree.clearSelection();
        ArrayList<UniqueNode> elements = new ArrayList<UniqueNode>();
        elements.add((UniqueNode)root);
        while (elements.size() > 0) {
            UniqueNode element = (UniqueNode)elements.get(0);
            TreePath path = new TreePath(element.getPath());
            if (treeState.isExpanded(element.getId())) {
                tree.expandPath(path);
                for (int i = 0; i < element.getChildCount(); ++i) {
                    elements.add((UniqueNode)tree.getModel().getChild(element, i));
                }
            } else {
                tree.collapsePath(path);
            }
            if (restoreSelection) {
                if (treeState.isSelected(element.getId())) {
                    tree.addSelectionPath(path);
                } else {
                    tree.removeSelectionPath(path);
                }
            }
            elements.remove(element);
        }
    }

    public static <E extends DefaultMutableTreeNode> void optimizeNodes(List<E> nodes) {
        block0: for (int i = nodes.size() - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.get(i);
            for (DefaultMutableTreeNode other : nodes) {
                if (other == node || !node.isNodeAncestor(other)) continue;
                nodes.remove(i);
                continue block0;
            }
        }
    }
}

