/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.text.WebTextAreaStyle;
import com.alee.managers.language.LM;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class WebTextAreaUI
extends BasicTextAreaUI
implements BorderMethods,
SwingConstants {
    private String inputPrompt = WebTextAreaStyle.inputPrompt;
    private Font inputPromptFont = WebTextAreaStyle.inputPromptFont;
    private Color inputPromptForeground = WebTextAreaStyle.inputPromptForeground;
    private int inputPromptHorizontalPosition = WebTextAreaStyle.inputPromptHorizontalPosition;
    private int inputPromptVerticalPosition = WebTextAreaStyle.inputPromptVerticalPosition;
    private boolean hideInputPromptOnFocus = WebTextAreaStyle.hideInputPromptOnFocus;
    private Painter painter = WebTextAreaStyle.painter;
    private boolean inputPromptSet = false;
    private FocusListener focusListener;
    private PropertyChangeListener marginChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebTextAreaUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        final JTextComponent textComponent = this.getComponent();
        SwingUtils.setOrientation(textComponent);
        LookAndFeel.installProperty(textComponent, "opaque", Boolean.TRUE);
        textComponent.setBackground(Color.WHITE);
        textComponent.setSelectionColor(StyleConstants.textSelectionColor);
        textComponent.setForeground(Color.BLACK);
        textComponent.setSelectedTextColor(Color.BLACK);
        textComponent.setCaretColor(Color.GRAY);
        textComponent.setMargin(WebTextAreaStyle.margin);
        PainterSupport.installPainter(textComponent, this.painter);
        this.updateBorder();
        this.focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }
        };
        textComponent.addFocusListener(this.focusListener);
        this.marginChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTextAreaUI.this.updateBorder();
            }
        };
        textComponent.addPropertyChangeListener("margin", this.marginChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        JTextComponent component = this.getComponent();
        PainterSupport.uninstallPainter(component, this.painter);
        component.removeFocusListener(this.focusListener);
        component.removePropertyChangeListener("margin", this.marginChangeListener);
        super.uninstallUI(c);
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String inputPrompt) {
        this.inputPrompt = inputPrompt;
        this.inputPromptSet = inputPrompt != null && !inputPrompt.trim().equals("");
        this.updateInputPromptView();
    }

    public Font getInputPromptFont() {
        return this.inputPromptFont;
    }

    public void setInputPromptFont(Font inputPromptFont) {
        this.inputPromptFont = inputPromptFont;
        this.updateInputPromptView();
    }

    public Color getInputPromptForeground() {
        return this.inputPromptForeground;
    }

    public void setInputPromptForeground(Color inputPromptForeground) {
        this.inputPromptForeground = inputPromptForeground;
        this.updateInputPromptView();
    }

    public int getInputPromptHorizontalPosition() {
        return this.inputPromptHorizontalPosition;
    }

    public void setInputPromptHorizontalPosition(int inputPromptHorizontalPosition) {
        this.inputPromptHorizontalPosition = inputPromptHorizontalPosition;
        this.updateInputPromptView();
    }

    public int getInputPromptVerticalPosition() {
        return this.inputPromptVerticalPosition;
    }

    public void setInputPromptVerticalPosition(int inputPromptVerticalPosition) {
        this.inputPromptVerticalPosition = inputPromptVerticalPosition;
        this.updateInputPromptView();
    }

    public boolean isHideInputPromptOnFocus() {
        return this.hideInputPromptOnFocus;
    }

    public void setHideInputPromptOnFocus(boolean hideInputPromptOnFocus) {
        this.hideInputPromptOnFocus = hideInputPromptOnFocus;
        this.updateInputPromptView();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        JTextComponent textComponent = this.getComponent();
        PainterSupport.uninstallPainter(textComponent, this.painter);
        this.painter = painter;
        textComponent.setOpaque(painter == null || painter.isOpaque(textComponent) != false);
        PainterSupport.installPainter(textComponent, this.painter);
        this.updateBorder();
    }

    private void updateInputPromptView() {
        if (this.isInputPromptVisible(this.getComponent())) {
            this.updateView();
        }
    }

    private boolean isInputPromptVisible(JTextComponent c) {
        return this.inputPromptSet && c.isEditable() && c.isEnabled() && (!this.hideInputPromptOnFocus || !c.isFocusOwner()) && c.getText().equals("");
    }

    private void updateView() {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }

    @Override
    public void updateBorder() {
        JTextComponent component = this.getComponent();
        if (component != null) {
            Insets m;
            if (SwingUtils.isPreserveBorders(component)) {
                return;
            }
            Insets margin = component.getMargin();
            boolean ltr = component.getComponentOrientation().isLeftToRight();
            Insets insets = margin == null ? new Insets(0, 0, 0, 0) : (m = new Insets(margin.top, ltr ? margin.left : margin.right, margin.bottom, ltr ? margin.right : margin.left));
            if (this.painter != null) {
                Insets pi = this.painter.getMargin(component);
                m.top += pi.top;
                m.bottom += pi.bottom;
                m.left = m.left + (ltr ? pi.left : pi.right);
                m.right = m.right + (ltr ? pi.right : pi.left);
            }
            component.setBorder(LafUtils.createWebBorder(m));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    protected void paintSafely(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        JTextComponent c = this.getComponent();
        if (c.isOpaque() && (this.painter == null || !this.painter.isOpaque(c).booleanValue())) {
            g2d.setPaint(c.getBackground());
            g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.painter != null) {
            this.painter.paint(g2d, SwingUtils.size(c), c);
        }
        Map hints = SwingUtils.setupTextAntialias(g2d);
        super.paintSafely(g);
        if (this.isInputPromptVisible(c)) {
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            Rectangle b = this.getVisibleEditorRect();
            Shape oc = GraphicsUtils.intersectClip(g2d, b);
            g2d.setFont(this.inputPromptFont != null ? this.inputPromptFont : c.getFont());
            g2d.setPaint(this.inputPromptForeground != null ? this.inputPromptForeground : c.getForeground());
            String text = LM.get(this.inputPrompt);
            FontMetrics fm = g2d.getFontMetrics();
            int x = this.inputPromptHorizontalPosition == 0 ? b.x + b.width / 2 - fm.stringWidth(text) / 2 : (ltr && this.inputPromptHorizontalPosition == 10 || !ltr && this.inputPromptHorizontalPosition == 11 || this.inputPromptHorizontalPosition == 2 ? b.x : b.x + b.width - fm.stringWidth(text));
            int y = this.inputPromptVerticalPosition == 0 ? b.y + b.height / 2 + LafUtils.getTextCenterShearY(fm) : this.getBaseline(c, c.getWidth(), c.getHeight());
            g2d.drawString(text, x, y);
            GraphicsUtils.restoreClip(g2d, oc);
        }
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        if (this.painter != null) {
            if (c.getLayout() != null) {
                ps = SwingUtils.max(ps, c.getLayout().preferredLayoutSize(c));
            }
            ps = SwingUtils.max(ps, this.painter.getPreferredSize(c));
        }
        return ps;
    }
}

