/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.menu.WebMenuItemStyle;
import com.alee.laf.menu.WebMenuItemUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;

public class WebCheckBoxMenuItemUI
extends WebMenuItemUI {
    protected static final ImageIcon boxIcon = new ImageIcon(WebCheckBoxMenuItemUI.class.getResource("icons/box.png"));
    protected static final ImageIcon boxCheckIcon = new ImageIcon(WebCheckBoxMenuItemUI.class.getResource("icons/boxCheck.png"));
    protected Color checkColor = WebMenuItemStyle.checkColor;

    public static ComponentUI createUI(JComponent c) {
        return new WebCheckBoxMenuItemUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "CheckBoxMenuItem";
    }

    public Color getCheckColor() {
        return this.checkColor;
    }

    public void setCheckColor(Color color) {
        this.checkColor = color;
    }

    @Override
    public Paint getNorthCornerFill() {
        boolean selected = this.menuItem.isEnabled() && this.menuItem.getModel().isArmed();
        return !selected && this.menuItem.isSelected() ? this.checkColor : super.getNorthCornerFill();
    }

    @Override
    public Paint getSouthCornerFill() {
        boolean selected = this.menuItem.isEnabled() && this.menuItem.getModel().isArmed();
        return !selected && this.menuItem.isSelected() ? this.checkColor : super.getSouthCornerFill();
    }

    @Override
    protected void paintBackground(Graphics2D g2d, JMenuItem menuItem, int x, int y, int w, int h, boolean selected, boolean ltr) {
        super.paintBackground(g2d, menuItem, x, y, w, h, selected, ltr);
        if (this.painter == null && !selected && menuItem.isSelected() && this.checkColor != null) {
            g2d.setPaint(this.checkColor);
            g2d.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        }
    }

    @Override
    protected void paintIcon(Graphics2D g2d, JMenuItem menuItem, int x, int y, int w, int h, boolean selected, boolean ltr) {
        super.paintIcon(g2d, menuItem, x, y, w, h, selected, ltr);
        if (menuItem.getIcon() == null) {
            int ix = x + w / 2 - boxIcon.getIconWidth() / 2;
            int iy = y + h / 2 - boxIcon.getIconHeight() / 2;
            g2d.drawImage(menuItem.isSelected() ? boxCheckIcon.getImage() : boxIcon.getImage(), ix, iy, null);
        }
    }
}

