/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.global.StyleConstants;
import com.alee.laf.list.WebListStyle;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class WebListUI
extends BasicListUI {
    private boolean decorateSelection = WebListStyle.decorateSelection;
    private boolean highlightRolloverCell = WebListStyle.highlightRolloverCell;
    private int selectionRound = WebListStyle.selectionRound;
    private int selectionShadeWidth = WebListStyle.selectionShadeWidth;
    private boolean autoScrollToSelection = WebListStyle.autoScrollToSelection;
    private MouseAdapter mouseoverAdapter;
    private ListSelectionListener selectionListener;
    private int rolloverIndex = -1;

    public static ComponentUI createUI(JComponent c) {
        return new WebListUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.list);
        LookAndFeel.installProperty(this.list, "opaque", Boolean.TRUE);
        this.list.setBackground(new ColorUIResource(WebListStyle.background));
        this.list.setForeground(new ColorUIResource(WebListStyle.foreground));
        this.mouseoverAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.updateMouseover(e);
            }

            private void updateMouseover(MouseEvent e) {
                if (!WebListUI.this.decorateSelection || !WebListUI.this.highlightRolloverCell) {
                    return;
                }
                int index = WebListUI.this.list.locationToIndex(e.getPoint());
                Rectangle bounds = WebListUI.this.list.getCellBounds(index, index);
                if (bounds == null || !bounds.contains(e.getPoint()) || !WebListUI.this.list.isEnabled()) {
                    index = -1;
                }
                if (WebListUI.this.rolloverIndex != index) {
                    int oldIndex = WebListUI.this.rolloverIndex;
                    WebListUI.this.rolloverIndex = index;
                    this.repaintChange(oldIndex, WebListUI.this.rolloverIndex);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (WebListUI.this.rolloverIndex != -1) {
                    int oldIndex = WebListUI.this.rolloverIndex;
                    WebListUI.this.rolloverIndex = -1;
                    this.repaintChange(oldIndex, WebListUI.this.rolloverIndex);
                }
            }

            private void repaintChange(int oldIndex, int newIndex) {
                Rectangle newBounds;
                Rectangle oldBounds = WebListUI.this.list.getCellBounds(oldIndex, oldIndex);
                Rectangle rect = GeometryUtils.getContainingRect(oldBounds, newBounds = WebListUI.this.list.getCellBounds(newIndex, newIndex));
                if (rect != null) {
                    WebListUI.this.list.repaint(rect);
                }
            }
        };
        this.list.addMouseListener(this.mouseoverAdapter);
        this.list.addMouseMotionListener(this.mouseoverAdapter);
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (WebListUI.this.autoScrollToSelection && WebListUI.this.list.getSelectedIndex() != -1) {
                    int index = WebListUI.this.list.getLeadSelectionIndex();
                    Rectangle selection = WebListUI.this.getCellBounds(WebListUI.this.list, index, index);
                    if (selection != null && !selection.intersects(WebListUI.this.list.getVisibleRect())) {
                        WebListUI.this.list.scrollRectToVisible(selection);
                    }
                }
            }
        };
        this.list.addListSelectionListener(this.selectionListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.list.removeMouseListener(this.mouseoverAdapter);
        this.list.removeMouseMotionListener(this.mouseoverAdapter);
        this.list.removeListSelectionListener(this.selectionListener);
        super.uninstallUI(c);
    }

    public boolean isDecorateSelection() {
        return this.decorateSelection;
    }

    public void setDecorateSelection(boolean decorateSelection) {
        this.decorateSelection = decorateSelection;
    }

    public boolean isHighlightRolloverCell() {
        return this.highlightRolloverCell;
    }

    public void setHighlightRolloverCell(boolean highlightRolloverCell) {
        this.highlightRolloverCell = highlightRolloverCell;
    }

    public int getSelectionRound() {
        return this.selectionRound;
    }

    public void setSelectionRound(int selectionRound) {
        this.selectionRound = selectionRound;
    }

    public int getSelectionShadeWidth() {
        return this.selectionShadeWidth;
    }

    public void setSelectionShadeWidth(int selectionShadeWidth) {
        this.selectionShadeWidth = selectionShadeWidth;
    }

    public boolean isAutoScrollToSelection() {
        return this.autoScrollToSelection;
    }

    public void setAutoScrollToSelection(boolean autoScrollToSelection) {
        this.autoScrollToSelection = autoScrollToSelection;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int index, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(index);
        boolean isSelected = selModel.isSelectedIndex(index);
        if (this.decorateSelection && (isSelected || index == this.rolloverIndex)) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(0.35f), !isSelected);
            LafUtils.drawCustomWebBorder(g2d, this.list, new RoundRectangle2D.Double(rowBounds.x + this.selectionShadeWidth, rowBounds.y + this.selectionShadeWidth, rowBounds.width - this.selectionShadeWidth * 2 - 1, rowBounds.height - this.selectionShadeWidth * 2 - 1, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, true);
            GraphicsUtils.restoreComposite(g2d, oc, !isSelected);
        }
        boolean cellHasFocus = this.list.hasFocus() && index == leadIndex;
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, index, isSelected, cellHasFocus);
        this.rendererPane.paintComponent(g, rendererComponent, this.list, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
    }
}

