/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.image.gif;

import com.alee.graphics.image.gif.GifDecoder;
import com.alee.graphics.image.gif.RepaintListener;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class GifIcon
implements Icon {
    private RepaintListener repaintListener;
    private final Map<Integer, GifDecoder.GifFrame> frames = new HashMap<Integer, GifDecoder.GifFrame>();
    private int status = 0;
    private int frameCount = 0;
    private int displayedFrame = -1;
    private Thread gifAnimator;
    private boolean stopAnimation = false;

    public GifIcon(Class nearClass, String imgSrc) throws IOException {
        this(new BufferedInputStream(nearClass.getResource(imgSrc).openStream()));
    }

    public GifIcon(String imgSrc) throws FileNotFoundException {
        this(new BufferedInputStream(new FileInputStream(imgSrc)));
    }

    public GifIcon(BufferedInputStream stream) {
        GifDecoder gifDecoder = new GifDecoder();
        this.status = gifDecoder.read(stream);
        if (this.status == 0) {
            this.frameCount = gifDecoder.getFrameCount();
            this.displayedFrame = 0;
            for (int i = 0; i < this.frameCount; ++i) {
                this.frames.put(i, new GifDecoder.GifFrame(gifDecoder.getFrame(i), gifDecoder.getDelay(i)));
            }
            this.startAnimation();
        }
    }

    public void startAnimation() {
        if (this.frameCount > 1) {
            this.displayedFrame = 0;
            this.gifAnimator = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!GifIcon.this.stopAnimation) {
                        int delay = ((GifDecoder.GifFrame)((GifIcon)GifIcon.this).frames.get((Object)Integer.valueOf((int)((GifIcon)GifIcon.this).displayedFrame))).delay;
                        try {
                            Thread.sleep(delay == 0 ? 100L : (long)delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (GifIcon.this.displayedFrame == GifIcon.this.frameCount - 1) {
                            GifIcon.this.displayedFrame = 0;
                        } else {
                            GifIcon.this.displayedFrame++;
                        }
                        if (GifIcon.this.repaintListener == null) continue;
                        GifIcon.this.repaintListener.imageRepaintOccured();
                    }
                }
            });
            this.gifAnimator.start();
        }
    }

    public void stopAnimation() {
        if (this.gifAnimator.isAlive()) {
            this.stopAnimation = true;
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.frameCount > 0) {
            g.drawImage(this.frames.get((Object)Integer.valueOf((int)this.displayedFrame)).bufferedImage, x, y, c);
        }
    }

    @Override
    public int getIconWidth() {
        return this.frames.get((Object)Integer.valueOf((int)this.displayedFrame)).bufferedImage.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.frames.get((Object)Integer.valueOf((int)this.displayedFrame)).bufferedImage.getHeight();
    }

    public BufferedImage getImage() {
        return this.frames.get((Object)Integer.valueOf((int)this.displayedFrame)).bufferedImage;
    }

    public int getStatus() {
        return this.status;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getDisplayedFrame() {
        return this.displayedFrame;
    }

    public Map<Integer, GifDecoder.GifFrame> getFrames() {
        return this.frames;
    }

    public RepaintListener getRepaintListener() {
        return this.repaintListener;
    }

    public void setRepaintListener(RepaintListener repaintListener) {
        this.repaintListener = repaintListener;
    }
}

