/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.FileTreeDataProvider;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeNodeFilter;
import com.alee.extended.tree.FileTreeRootType;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebFileTreeCellEditor;
import com.alee.extended.tree.WebFileTreeCellRenderer;
import com.alee.extended.tree.WebFileTreeStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.compare.Filter;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebFileTree
extends WebAsyncTree<FileTreeNode> {
    protected boolean filesDropSearchEnabled = WebFileTreeStyle.filesDropSearchEnabled;
    protected FileDragAndDropHandler fileLookupDropHandler = null;
    protected final Object delayedSelectionLock = new Object();
    protected int delayedSelectionId = 0;

    public WebFileTree() {
        this(FileTreeRootType.drives);
    }

    public WebFileTree(FileTreeRootType rootType) {
        this(rootType.getRoots());
    }

    public WebFileTree(String rootPath) {
        this(new File(rootPath));
    }

    public WebFileTree(File ... rootFiles) {
        this(CollectionUtils.copy(rootFiles));
    }

    public WebFileTree(List<File> rootFiles) {
        super(new FileTreeDataProvider(rootFiles));
        this.setEditable(false);
        this.setRootVisible(rootFiles != null && rootFiles.size() == 1);
        this.setCellRenderer(new WebFileTreeCellRenderer());
        this.setCellEditor(new WebFileTreeCellEditor());
        this.setFilesDropSearchEnabled(WebFileTreeStyle.filesDropSearchEnabled);
    }

    public FileTreeDataProvider getDataProvider() {
        return (FileTreeDataProvider)super.getDataProvider();
    }

    @Override
    public void setModel(TreeModel newModel) {
        boolean async = this.isAsyncLoading();
        this.setAsyncLoading(false);
        super.setModel(newModel);
        this.setAsyncLoading(async);
    }

    protected FileDragAndDropHandler getFileLookupDropHandler() {
        if (this.fileLookupDropHandler == null) {
            this.fileLookupDropHandler = new FileDragAndDropHandler(){

                @Override
                public boolean isDropEnabled() {
                    return WebFileTree.this.filesDropSearchEnabled;
                }

                @Override
                public boolean filesDropped(List<File> files) {
                    if (files.size() > 0) {
                        WebFileTree.this.setSelectedFile(files.get(0), true);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.fileLookupDropHandler;
    }

    public boolean isFilesDropSearchEnabled() {
        return this.filesDropSearchEnabled;
    }

    public void setFilesDropSearchEnabled(boolean filesDropSearchEnabled) {
        this.filesDropSearchEnabled = filesDropSearchEnabled;
        FileDragAndDropHandler lookupDropHandler = this.getFileLookupDropHandler();
        if (filesDropSearchEnabled) {
            this.setTransferHandler(lookupDropHandler);
        } else if (this.getTransferHandler() == lookupDropHandler) {
            this.setTransferHandler(null);
        }
    }

    public Filter<File> getFileFilter() {
        Filter filter = this.getFilter();
        return filter instanceof FileTreeNodeFilter ? ((FileTreeNodeFilter)filter).getFilter() : null;
    }

    public void setFileFilter(Filter<File> filter) {
        this.setFilter(filter != null ? new FileTreeNodeFilter(filter) : null);
    }

    public void setRootName(String rootName) {
        FileTreeNode rootNode = (FileTreeNode)this.getRootNode();
        rootNode.setName(rootName);
        this.getAsyncModel().updateNode(rootNode);
    }

    public void setSelectedFile(File file) {
        this.setSelectedFile(file, false);
    }

    public void setSelectedFile(File file, boolean expand) {
        this.expandToFile(file, true, expand);
    }

    public void expandFile(File file) {
        this.expandToFile(file, false, true);
    }

    public void expandToFile(File file) {
        this.expandToFile(file, false, false);
    }

    public void expandToFile(File file, boolean select) {
        this.expandToFile(file, select, false);
    }

    public void expandToFile(File file, boolean select, boolean expand) {
        this.expandToFile(file, select, expand, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandToFile(File file, final boolean select, final boolean expand, final Runnable finalAction) {
        if (file != null) {
            int selectionId;
            Object object = this.delayedSelectionLock;
            synchronized (object) {
                ++this.delayedSelectionId;
                selectionId = this.delayedSelectionId;
            }
            final FileTreeNode node = this.getClosestNode(file);
            if (node != null) {
                if (FileUtils.equals(node.getFile(), file)) {
                    if (select && selectionId == this.delayedSelectionId) {
                        this.performFileSelection(node, expand);
                    } else {
                        if (expand) {
                            this.expandNode(node);
                        }
                        this.scrollToNode(node);
                    }
                    if (finalAction != null) {
                        finalAction.run();
                    }
                } else {
                    int index;
                    final List<File> path = FileUtils.getFilePath(file);
                    for (int i = index = path.indexOf(node.getFile()); i >= 0; --i) {
                        path.remove(i);
                    }
                    this.addAsyncTreeListener(new AsyncTreeAdapter<FileTreeNode>(){
                        private FileTreeNode lastNode;
                        {
                            this.lastNode = node;
                        }

                        @Override
                        public void childsLoadCompleted(FileTreeNode parent, List<FileTreeNode> childs) {
                            if (parent == this.lastNode) {
                                boolean found = false;
                                for (FileTreeNode child : childs) {
                                    if (!child.getFile().equals(path.get(0))) continue;
                                    found = true;
                                    if (path.size() == 1) {
                                        WebFileTree.this.removeAsyncTreeListener(this);
                                        if (select && selectionId == WebFileTree.this.delayedSelectionId) {
                                            WebFileTree.this.performFileSelection(child, expand);
                                        } else {
                                            if (expand) {
                                                WebFileTree.this.expandNode(child);
                                            }
                                            WebFileTree.this.scrollToNode(child);
                                        }
                                        if (finalAction == null) break;
                                        finalAction.run();
                                        break;
                                    }
                                    this.lastNode = child;
                                    path.remove(0);
                                    WebFileTree.this.reloadNode(child);
                                    break;
                                }
                                if (!found) {
                                    WebFileTree.this.removeAsyncTreeListener(this);
                                    if (select && selectionId == WebFileTree.this.delayedSelectionId) {
                                        WebFileTree.this.performFileSelection(parent, false);
                                    } else {
                                        WebFileTree.this.scrollToNode(parent);
                                    }
                                    if (finalAction != null) {
                                        finalAction.run();
                                    }
                                }
                            }
                        }

                        @Override
                        public void childsLoadFailed(FileTreeNode parent, Throwable cause) {
                            if (parent == this.lastNode) {
                                WebFileTree.this.removeAsyncTreeListener(this);
                                if (select && selectionId == WebFileTree.this.delayedSelectionId) {
                                    WebFileTree.this.performFileSelection(parent, false);
                                } else {
                                    WebFileTree.this.scrollToNode(parent);
                                }
                                if (finalAction != null) {
                                    finalAction.run();
                                }
                            }
                        }
                    });
                    this.reloadNode(node);
                }
            }
        } else if (select) {
            this.clearSelection();
        }
    }

    protected void performFileSelection(FileTreeNode node, boolean expand) {
        try {
            TreePath path = node.getTreePath();
            this.setSelectionPath(path);
            if (expand) {
                Rectangle pathBounds;
                if (!this.isAutoExpandSelectedNode()) {
                    this.expandPath(path);
                }
                if ((pathBounds = this.getPathBounds(path)) != null) {
                    Rectangle vr = this.getVisibleRect();
                    Rectangle rect = new Rectangle(vr.x, pathBounds.y, vr.width, vr.height);
                    this.scrollRectToVisible(rect);
                }
            } else {
                this.scrollPathToVisible(path);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public File getSelectedFile() {
        FileTreeNode selectedNode = (FileTreeNode)this.getSelectedNode();
        return selectedNode != null ? selectedNode.getFile() : null;
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> selectedFiles = new ArrayList<File>();
        if (this.getSelectionPaths() != null) {
            for (TreePath path : this.getSelectionPaths()) {
                selectedFiles.add(((FileTreeNode)this.getNodeForPath(path)).getFile());
            }
        }
        return selectedFiles;
    }

    @Override
    public List<FileTreeNode> getSelectedNodes() {
        ArrayList<FileTreeNode> selectedNodes = new ArrayList<FileTreeNode>();
        if (this.getSelectionPaths() != null) {
            for (TreePath path : this.getSelectionPaths()) {
                selectedNodes.add((FileTreeNode)this.getNodeForPath(path));
            }
        }
        return selectedNodes;
    }

    public boolean addFile(File parent, File file) {
        return this.addFiles(parent, file);
    }

    public boolean addFile(FileTreeNode parentNode, File file) {
        return this.addFiles(parentNode, file);
    }

    public boolean addFiles(File parent, File ... files) {
        return this.addFiles(parent, CollectionUtils.copy(files));
    }

    public boolean addFiles(FileTreeNode parentNode, File ... files) {
        return this.addFiles(parentNode, CollectionUtils.copy(files));
    }

    public boolean addFiles(File parent, List<File> files) {
        FileTreeNode parentNode = this.getNode(parent);
        return parentNode != null && this.addFiles(parentNode, files);
    }

    public boolean addFiles(FileTreeNode parentNode, List<File> files) {
        if (this.hasBeenExpanded(this.getPathForNode(parentNode))) {
            ArrayList<FileTreeNode> childNodes = new ArrayList<FileTreeNode>(files.size());
            for (File file : files) {
                childNodes.add(new FileTreeNode(file));
            }
            this.addChildNodes(parentNode, childNodes);
            return true;
        }
        return false;
    }

    public boolean removeFile(File file) {
        return this.removeNode(this.getNode(file));
    }

    public boolean removeFiles(File ... files) {
        boolean changed = false;
        for (File file : files) {
            changed |= this.removeFile(file);
        }
        return changed;
    }

    public boolean removeFiles(List<File> files) {
        boolean changed = false;
        for (File file : files) {
            changed |= this.removeFile(file);
        }
        return changed;
    }

    public void startEditingFile(final File file) {
        FileTreeNode node = this.getNode(file);
        if (node != null) {
            this.startEditingNode(node);
        } else {
            this.expandToFile(file, false, false, new Runnable(){

                @Override
                public void run() {
                    FileTreeNode node = WebFileTree.this.getNode(file);
                    if (node != null) {
                        WebFileTree.this.startEditingNode(node);
                    }
                }
            });
        }
    }

    public List<File> getFileChilds(FileTreeNode node) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            files.add(node.getChildAt(i).getFile());
        }
        return files;
    }

    public FileTreeNode getNode(File file) {
        FileTreeNode node = this.getClosestNode(file);
        return node != null && FileUtils.equals(file, node.getFile()) ? node : null;
    }

    public FileTreeNode getClosestNode(File file) {
        return this.getClosestNode((FileTreeNode)this.getModel().getRoot(), FileUtils.getFilePath(file));
    }

    protected FileTreeNode getClosestNode(FileTreeNode node, List<File> path) {
        File file = node.getFile();
        if (file != null && path.contains(file)) {
            int index;
            for (int i = index = path.indexOf(file); i >= 0; --i) {
                path.remove(i);
            }
            return this.getDeepestPathNode(node, path);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            FileTreeNode found = this.getClosestNode(node.getChildAt(i), path);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected FileTreeNode getDeepestPathNode(FileTreeNode pathNode, List<File> path) {
        if (path.size() > 0) {
            for (int i = 0; i < pathNode.getChildCount(); ++i) {
                FileTreeNode child = pathNode.getChildAt(i);
                if (!child.getFile().equals(path.get(0))) continue;
                path.remove(0);
                return this.getDeepestPathNode(child, path);
            }
        }
        return pathNode;
    }

    public void reloadChildsSync(File folder) {
        this.reloadChildsSync(folder, false);
    }

    public void reloadChildsSync(File folder, boolean select) {
        FileTreeNode node = this.getNode(folder);
        if (node != null) {
            this.reloadNodeSync(node, select);
        }
    }

    public void reloadChilds(File folder) {
        this.reloadChilds(folder, false);
    }

    public void reloadChilds(File folder, boolean select) {
        FileTreeNode node = this.getNode(folder);
        if (node != null) {
            this.reloadNode(node, select);
        }
    }
}

