/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncTreeQueue;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.log.Log;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AsyncTreeTransferHandler<N extends AsyncUniqueNode, T extends WebAsyncTree<N>>
extends TransferHandler {
    protected boolean allowUncheckedDrop = false;
    protected DataFlavor nodesFlavor;
    protected DataFlavor[] flavors = new DataFlavor[1];
    protected List<N> nodesToRemove;
    protected Map<String, List<Integer>> removedUnder;

    public AsyncTreeTransferHandler() {
        try {
            this.flavors[0] = this.nodesFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + List.class.getName() + "\"");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean isAllowUncheckedDrop() {
        return this.allowUncheckedDrop;
    }

    public void setAllowUncheckedDrop(boolean allowUncheckedDrop) {
        this.allowUncheckedDrop = allowUncheckedDrop;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath path = dl.getPath();
        if (path == null) {
            return false;
        }
        AsyncUniqueNode target = (AsyncUniqueNode)path.getLastPathComponent();
        if (target.isLoading() || target.isFailed()) {
            return false;
        }
        try {
            if (this.nodesToRemove != null) {
                for (AsyncUniqueNode node : this.nodesToRemove) {
                    if (target != node && !target.isNodeAncestor(node)) continue;
                    return false;
                }
            }
            List nodes = (List)support.getTransferable().getTransferData(this.nodesFlavor);
            boolean canBeDropped = this.canBeDropped(nodes, target, dl.getChildIndex());
            support.setShowDropLocation(canBeDropped);
            return canBeDropped;
        }
        catch (UnsupportedFlavorException ufe) {
            Log.warn(this, "UnsupportedFlavor: " + ufe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            Log.error((Object)this, "I/O error: " + ioe.getMessage());
            return false;
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        WebAsyncTree tree = (WebAsyncTree)c;
        List nodes = tree.getSelectedNodes();
        if (!nodes.isEmpty()) {
            if (nodes.contains(tree.getRootNode())) {
                return null;
            }
            TreeUtils.optimizeNodes(nodes);
            if (!this.canBeDragged(nodes)) {
                return null;
            }
            ArrayList<AsyncUniqueNode> copies = new ArrayList<AsyncUniqueNode>();
            for (AsyncUniqueNode node : nodes) {
                copies.add(this.copy(node));
            }
            this.nodesToRemove = nodes;
            this.removedUnder = new HashMap<String, List<Integer>>(1);
            for (AsyncUniqueNode node : this.nodesToRemove) {
                AsyncUniqueNode parent = node.getParent();
                List<Integer> indices = this.removedUnder.get(parent.getId());
                if (indices == null) {
                    indices = new ArrayList<Integer>(1);
                    this.removedUnder.put(parent.getId(), indices);
                }
                indices.add(parent.getIndex(node));
            }
            return new NodesTransferable(copies);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) == 2) {
            WebAsyncTree tree = (WebAsyncTree)source;
            tree.removeNodes(this.nodesToRemove);
            this.nodesToRemove = null;
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List nodes;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            nodes = (List)support.getTransferable().getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            Log.warn(this, "UnsupportedFlavor: " + ufe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            Log.error((Object)this, "I/O error: " + ioe.getMessage());
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        int dropIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        final AsyncUniqueNode parent = (AsyncUniqueNode)dest.getLastPathComponent();
        final WebAsyncTree tree = (WebAsyncTree)support.getComponent();
        final AsyncTreeModel model = (AsyncTreeModel)tree.getModel();
        if (this.allowUncheckedDrop) {
            if (parent.isLoaded()) {
                this.performDropOperation(nodes, parent, tree, model, this.getAdjustedDropIndex(dropIndex, parent));
            } else {
                tree.addAsyncTreeListener(new AsyncTreeAdapter(){

                    @Override
                    public void childsLoadCompleted(AsyncUniqueNode loadedFor, List childs) {
                        if (loadedFor == parent) {
                            AsyncTreeTransferHandler.this.performDropOperation(nodes, parent, tree, model, parent.getChildCount());
                            tree.removeAsyncTreeListener(this);
                        }
                    }

                    @Override
                    public void childsLoadFailed(AsyncUniqueNode loadedFor, Throwable cause) {
                        if (loadedFor == parent) {
                            tree.removeAsyncTreeListener(this);
                        }
                    }
                });
                tree.reloadNode(parent);
            }
            return true;
        }
        if (!parent.isLoaded()) {
            tree.reloadNodeSync(parent);
        }
        if (parent.isLoaded()) {
            this.performDropOperation(nodes, parent, tree, model, this.getAdjustedDropIndex(dropIndex, parent));
            return true;
        }
        return false;
    }

    protected int getAdjustedDropIndex(int dropIndex, N parent) {
        int adjustedDropIndex;
        int n = adjustedDropIndex = dropIndex == -1 ? ((DefaultMutableTreeNode)parent).getChildCount() : dropIndex;
        if (this.removedUnder.containsKey(((UniqueNode)parent).getId())) {
            for (Integer index : this.removedUnder.get(((UniqueNode)parent).getId())) {
                if (index >= adjustedDropIndex) continue;
                --adjustedDropIndex;
            }
        }
        return adjustedDropIndex;
    }

    protected void performDropOperation(final List<N> nodes, N parent, T tree, final AsyncTreeModel<N> model, int index) {
        SwingUtilities.invokeLater(new Runnable((AsyncUniqueNode)parent, index, (WebAsyncTree)tree){
            final /* synthetic */ AsyncUniqueNode val$parent;
            final /* synthetic */ int val$index;
            final /* synthetic */ WebAsyncTree val$tree;
            {
                this.val$parent = asyncUniqueNode;
                this.val$index = n;
                this.val$tree = webAsyncTree;
            }

            @Override
            public void run() {
                model.insertNodesInto(nodes, this.val$parent, this.val$index);
                this.val$tree.setSelectedNodes(nodes);
                AsyncTreeQueue.execute(this.val$tree, new Runnable(){

                    @Override
                    public void run() {
                        AsyncTreeTransferHandler.this.nodesDropped(nodes, val$parent, val$tree, model, val$index);
                    }
                });
            }
        });
    }

    protected abstract boolean canBeDragged(List<N> var1);

    protected abstract boolean canBeDropped(List<N> var1, N var2, int var3);

    protected abstract N copy(N var1);

    public abstract void nodesDropped(List<N> var1, N var2, T var3, AsyncTreeModel<N> var4, int var5);

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable,
    Serializable {
        protected final List<N> nodes;

        public NodesTransferable(List<N> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return AsyncTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return AsyncTreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

