/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.curtain;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.curtain.CurtainSlideDirection;
import com.alee.extended.transition.effects.curtain.CurtainType;
import com.alee.utils.GraphicsUtils;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class CurtainTransitionEffect
extends DefaultTransitionEffect {
    private static final String CURTAIN_SIZE = "CURTAIN_SIZE";
    private static final String CURTAIN_MINIMUM_SPEED = "CURTAIN_MINIMUM_SPEED";
    private static final String CURTAIN_SPEED = "CURTAIN_SPEED";
    private static final String CURTAIN_FADE = "CURTAIN_FADE";
    private static final String CURTAIN_TYPE = "CURTAIN_TYPE";
    private static final String CURTAIN_SLIDE_DIRECTION = "CURTAIN_SLIDE_DIRECTION";
    private int size;
    private int minimumSpeed;
    private int speed;
    private boolean fade;
    private CurtainType type;
    private Direction direction;
    private CurtainSlideDirection slideDirection;
    private int[] progress;
    private Shape clip;

    public int getSize() {
        return this.get(CURTAIN_SIZE, 80);
    }

    public void setSize(int size) {
        this.put(CURTAIN_SIZE, size);
    }

    public int getMinimumSpeed() {
        return this.get(CURTAIN_MINIMUM_SPEED, 1);
    }

    public void setMinimumSpeed(int speed) {
        this.put(CURTAIN_MINIMUM_SPEED, speed);
    }

    public int getSpeed() {
        return this.get(CURTAIN_SPEED, 4);
    }

    public void setSpeed(int speed) {
        this.put(CURTAIN_SPEED, speed);
    }

    public boolean isFade() {
        return this.get(CURTAIN_FADE, true);
    }

    public void setFade(boolean transparent) {
        this.put(CURTAIN_FADE, transparent);
    }

    public CurtainType getType() {
        return this.get(CURTAIN_TYPE, CurtainType.random);
    }

    public void setType(CurtainType type) {
        this.put(CURTAIN_TYPE, (Object)type);
    }

    public CurtainSlideDirection getSlideDirection() {
        return this.get(CURTAIN_SLIDE_DIRECTION, CurtainSlideDirection.random);
    }

    public void setSlideDirection(CurtainSlideDirection direction) {
        this.put(CURTAIN_SLIDE_DIRECTION, (Object)direction);
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.size = this.getSize();
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.fade = this.isFade();
        this.type = TransitionUtils.getActualValue(this.getType());
        this.direction = TransitionUtils.getActualValue(this.getDirection());
        this.slideDirection = TransitionUtils.getActualValue(this.getSlideDirection());
        int h = this.direction.isVertical() ? imageTransition.getHeight() : imageTransition.getWidth();
        int rows = (h % this.size == 0 ? h : h / this.size * this.size + this.size) / this.size;
        this.progress = new int[rows];
        for (int i = 0; i < rows; ++i) {
            this.progress[i] = 0;
        }
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            this.progress[0] = this.increaseProgress(imageTransition, 0);
        } else {
            this.progress[rows - 1] = this.increaseProgress(imageTransition, 0);
        }
        if (this.type.equals((Object)CurtainType.fill)) {
            this.clip = this.getCurtainProgressShape(this.progress, imageTransition);
        }
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        int max = this.getMaxProgress(imageTransition);
        boolean allMax = true;
        int rows = this.progress.length;
        for (int i = 0; i < rows; ++i) {
            if (this.progress[i] >= max) continue;
            if (this.progress[i] > 0) {
                this.progress[i] = this.increaseProgress(imageTransition, this.progress[i]);
            } else if (this.canStartGrow(i, this.progress, max)) {
                this.progress[i] = this.increaseProgress(imageTransition, this.progress[i]);
            }
            if (!allMax || this.progress[i] >= max) continue;
            allMax = false;
        }
        if (this.type.equals((Object)CurtainType.fill)) {
            this.clip = this.getCurtainProgressShape(this.progress, imageTransition);
        }
        if (!allMax) {
            imageTransition.repaint();
            return false;
        }
        this.clip = null;
        this.type = null;
        return true;
    }

    private int increaseProgress(ImageTransition imageTransition, int progress) {
        int max = this.getMaxProgress(imageTransition);
        return Math.min(progress + this.getCurrentSpeed(progress, max), max);
    }

    private int getMaxProgress(ImageTransition imageTransition) {
        if (this.type.equals((Object)CurtainType.slide)) {
            return this.direction.isHorizontal() ? imageTransition.getHeight() : imageTransition.getWidth();
        }
        return this.size;
    }

    private int getCurrentSpeed(int progress, int maxProgress) {
        if (this.type.equals((Object)CurtainType.slide)) {
            return Math.max(this.minimumSpeed, Math.round((float)this.speed * (float)Math.sqrt((float)(maxProgress - progress) / (float)maxProgress)));
        }
        return this.speed;
    }

    private boolean canStartGrow(int i, int[] curtainProgress, int max) {
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            return i > 0 && curtainProgress[i - 1] > max / 4 || i > 1 && curtainProgress[i - 2] > max * 2 / 4 || i > 2 && curtainProgress[i - 3] > max * 3 / 4;
        }
        return i < curtainProgress.length - 1 && curtainProgress[i + 1] > max / 4 || i < curtainProgress.length - 2 && curtainProgress[i + 2] > max * 2 / 4 || i < curtainProgress.length - 3 && curtainProgress[i + 3] > max * 3 / 4;
    }

    private Shape getCurtainProgressShape(int[] curtainProgress, ImageTransition imageTransition) {
        GeneralPath gp = new GeneralPath(0);
        for (int i = 0; i < curtainProgress.length; ++i) {
            if (this.direction.isVertical()) {
                gp.append(new Rectangle(0, i * this.size, imageTransition.getWidth(), curtainProgress[i]), false);
                continue;
            }
            gp.append(new Rectangle(i * this.size, 0, curtainProgress[i], imageTransition.getHeight()), false);
        }
        return gp;
    }

    @Override
    public void paint(Graphics2D g2d, ImageTransition transition) {
        block5: {
            BufferedImage otherImage;
            int max;
            int height;
            int width;
            block6: {
                block4: {
                    width = transition.getWidth();
                    height = transition.getHeight();
                    max = this.getMaxProgress(transition);
                    g2d.drawImage(transition.getCurrentImage(), 0, 0, width, height, null);
                    otherImage = transition.getOtherImage();
                    if (!this.type.equals((Object)CurtainType.fade) && (!this.type.equals((Object)CurtainType.fill) || !this.fade)) break block4;
                    int rows = this.progress.length;
                    for (int i = 0; i < rows; ++i) {
                        Composite old;
                        int dy2;
                        int dx2;
                        int dy1;
                        int dx1;
                        int curtain = this.progress[i];
                        if (curtain <= 0) continue;
                        if (this.direction.isVertical()) {
                            dx1 = 0;
                            dy1 = i * this.size;
                            int h = Math.min(height - i * this.size, this.type.equals((Object)CurtainType.fill) && this.fade ? curtain : this.size);
                            dx2 = 0 + width;
                            dy2 = dy1 + h;
                            old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf((float)curtain / (float)this.size), curtain < this.size);
                            g2d.drawImage(otherImage, 0, dy1, dx2, dy2, 0, dy1, dx2, dy2, null);
                            GraphicsUtils.restoreComposite(g2d, old, curtain < this.size);
                            continue;
                        }
                        dx1 = i * this.size;
                        dy1 = 0;
                        int w = Math.min(width - i * this.size, this.type.equals((Object)CurtainType.fill) && this.fade ? curtain : this.size);
                        dx2 = dx1 + w;
                        dy2 = 0 + height;
                        old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf((float)curtain / (float)this.size), curtain < this.size);
                        g2d.drawImage(otherImage, dx1, 0, dx2, dy2, dx1, 0, dx2, dy2, null);
                        GraphicsUtils.restoreComposite(g2d, old, curtain < this.size);
                    }
                    break block5;
                }
                if (!this.type.equals((Object)CurtainType.fill)) break block6;
                Shape old = GraphicsUtils.intersectClip(g2d, this.clip);
                g2d.drawImage(otherImage, 0, 0, width, height, null);
                GraphicsUtils.restoreClip(g2d, old);
                break block5;
            }
            if (!this.type.equals((Object)CurtainType.slide)) break block5;
            int rows = this.progress.length;
            for (int i = 0; i < rows; ++i) {
                Composite old;
                int dy2;
                int dy1;
                int dx2;
                int dx1;
                int curtain = this.progress[i];
                if (curtain <= 0) continue;
                if (this.direction.isVertical()) {
                    int xMark = this.slideDirection.equals((Object)CurtainSlideDirection.left) ? (this.direction.equals((Object)Direction.up) ? -1 : 1) : (this.slideDirection.equals((Object)CurtainSlideDirection.right) ? (this.direction.equals((Object)Direction.up) ? 1 : -1) : (i % 2 == 0 ? 1 : -1));
                    dx1 = xMark * Math.round((float)width * ((float)curtain / (float)max)) - xMark * width;
                    dx2 = dx1 + width;
                    dy1 = i * this.size;
                    dy2 = dy1 + Math.min(height - i * this.size, this.size);
                    old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf((float)curtain / (float)max), this.fade && curtain < max);
                    g2d.drawImage(otherImage, dx1, dy1, dx2, dy2, 0, dy1, width, dy2, null);
                    GraphicsUtils.restoreComposite(g2d, old, this.fade && curtain < max);
                    continue;
                }
                int yMark = this.slideDirection.equals((Object)CurtainSlideDirection.left) ? (this.direction.equals((Object)Direction.left) ? -1 : 1) : (this.slideDirection.equals((Object)CurtainSlideDirection.right) ? (this.direction.equals((Object)Direction.left) ? 1 : -1) : (i % 2 == 0 ? 1 : -1));
                dx1 = i * this.size;
                dx2 = dx1 + Math.min(width - i * this.size, this.size);
                dy1 = yMark * Math.round((float)height * ((float)curtain / (float)max)) - yMark * height;
                dy2 = dy1 + height;
                old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf((float)curtain / (float)max), this.fade && curtain < max);
                g2d.drawImage(otherImage, dx1, dy1, dx2, dy2, dx1, 0, dx2, height, null);
                GraphicsUtils.restoreComposite(g2d, old, this.fade && curtain < max);
            }
        }
    }
}

