/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentDragViewHandler;
import com.alee.extended.tab.DocumentListener;
import com.alee.extended.tab.PaneData;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.managers.drag.DragManager;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.Customizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingConstants;
import javax.swing.event.AncestorEvent;

public class WebDocumentPane<T extends DocumentData>
extends WebPanel
implements SwingConstants {
    protected static final String DATA_KEY = "document.pane.data";
    protected List<DocumentListener<T>> listeners = new ArrayList<DocumentListener<T>>(1);
    protected final String id;
    protected StructureData root;
    protected PaneData<T> activePane;
    protected Customizer<WebTabbedPane> tabbedPaneCustomizer;
    protected Customizer<WebSplitPane> splitPaneCustomizer;
    protected boolean closeable = true;
    protected boolean dragEnabled = true;
    protected boolean dragBetweenPanesEnabled = false;
    protected boolean splitEnabled = true;
    protected boolean tabMenuEnabled = true;

    public WebDocumentPane() {
        this((Customizer<WebTabbedPane>)null, (Customizer<WebSplitPane>)null);
    }

    public WebDocumentPane(Customizer<WebTabbedPane> tabbedPaneCustomizer, Customizer<WebSplitPane> splitPaneCustomizer) {
        super("document-pane");
        this.tabbedPaneCustomizer = tabbedPaneCustomizer;
        this.splitPaneCustomizer = splitPaneCustomizer;
        this.id = TextUtils.generateId("WDP");
        this.init();
        final DocumentDragViewHandler dragViewHandler = new DocumentDragViewHandler(this);
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DragManager.registerViewHandler(dragViewHandler);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                DragManager.unregisterViewHandler(dragViewHandler);
            }
        });
    }

    public String getId() {
        return this.id;
    }

    public Customizer<WebTabbedPane> getTabbedPaneCustomizer() {
        return this.tabbedPaneCustomizer;
    }

    public void setTabbedPaneCustomizer(Customizer<WebTabbedPane> customizer) {
        this.tabbedPaneCustomizer = customizer;
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.updateTabbedPaneCustomizer(this);
        }
    }

    public Customizer<WebSplitPane> getSplitPaneCustomizer() {
        return this.splitPaneCustomizer;
    }

    public void setSplitPaneCustomizer(Customizer<WebSplitPane> customizer) {
        this.splitPaneCustomizer = customizer;
        for (SplitData<T> paneData : this.getAllSplitPanes()) {
            paneData.updateSplitPaneCustomizer(this);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public boolean isDragBetweenPanesEnabled() {
        return this.dragBetweenPanesEnabled;
    }

    public void setDragBetweenPanesEnabled(boolean dragBetweenPanesEnabled) {
        this.dragBetweenPanesEnabled = dragBetweenPanesEnabled;
    }

    public boolean isSplitEnabled() {
        return this.splitEnabled;
    }

    public void setSplitEnabled(boolean splitEnabled) {
        this.splitEnabled = splitEnabled;
    }

    public boolean isTabMenuEnabled() {
        return this.tabMenuEnabled;
    }

    public void setTabMenuEnabled(boolean tabMenuEnabled) {
        this.tabMenuEnabled = tabMenuEnabled;
    }

    public StructureData getStructureRoot() {
        return this.root;
    }

    public void setStructureRoot(StructureData root) {
        if (this.root != null) {
            this.remove(this.root.getComponent());
        }
        if (root != null) {
            this.add(root.getComponent(), (Object)"Center");
            this.root = root;
            this.activePane = root.findClosestPane();
            this.revalidate();
            this.repaint();
        } else {
            this.init();
        }
    }

    protected void init() {
        PaneData rootPane = new PaneData(this);
        this.add((Component)rootPane.getTabbedPane(), (Object)"Center");
        this.root = rootPane;
        this.activePane = rootPane;
    }

    public void split(T movedDocument, int direction) {
        PaneData<T> pane = this.getPane(movedDocument);
        if (pane != null) {
            this.split(pane, movedDocument, direction);
        }
    }

    protected PaneData<T> split(PaneData<T> splittedPane, T movedDocument, int direction) {
        PaneData otherPane;
        if (splittedPane != null) {
            int orientation;
            boolean ltr = direction == 4 || direction == 3;
            int n = orientation = direction == 2 || direction == 4 ? 1 : 0;
            if (splittedPane.getTabbedPane().getParent() == this) {
                otherPane = new PaneData(this);
                Dimension size = splittedPane.getTabbedPane().getSize();
                PaneData first = ltr ? splittedPane : otherPane;
                PaneData last = ltr ? otherPane : splittedPane;
                SplitData splitData = new SplitData(this, orientation, first, last);
                this.remove(splittedPane.getTabbedPane());
                this.add((Component)splitData.getSplitPane(), (Object)"Center");
                splitData.getSplitPane().setDividerLocation(orientation == 1 ? size.width / 2 : size.height / 2);
                this.root = splitData;
            } else {
                WebSplitPane parentSplit = (WebSplitPane)splittedPane.getTabbedPane().getParent();
                SplitData<T> parentSplitData = WebDocumentPane.getData(parentSplit);
                if (parentSplitData.getOrientation() == orientation && ltr && parentSplitData.getFirst() == splittedPane && parentSplitData.getLast() instanceof PaneData) {
                    otherPane = (PaneData)parentSplitData.getLast();
                } else if (parentSplitData.getOrientation() == orientation && !ltr && parentSplitData.getLast() == splittedPane && parentSplitData.getFirst() instanceof PaneData) {
                    otherPane = (PaneData)parentSplitData.getFirst();
                } else {
                    otherPane = new PaneData(this);
                    int parentSplitLocation = parentSplitData.getSplitPane().getDividerLocation();
                    Dimension size = splittedPane.getTabbedPane().getSize();
                    PaneData first = ltr ? splittedPane : otherPane;
                    PaneData last = ltr ? otherPane : splittedPane;
                    SplitData splitData = new SplitData(this, orientation, first, last);
                    parentSplitData.replace(splittedPane, splitData);
                    splitData.getSplitPane().setDividerLocation(orientation == 1 ? size.width / 2 : size.height / 2);
                    parentSplitData.getSplitPane().setDividerLocation(parentSplitLocation);
                }
            }
            if (movedDocument != null) {
                splittedPane.remove(movedDocument);
                otherPane.add(movedDocument);
            }
            this.revalidate();
            this.repaint();
        } else {
            otherPane = null;
        }
        return otherPane;
    }

    public void merge(StructureData toMerge) {
        if (toMerge instanceof PaneData) {
            PaneData mergedPane = (PaneData)toMerge;
            Container parent = mergedPane.getTabbedPane().getParent();
            if (parent instanceof WebSplitPane) {
                WebSplitPane splitPane = (WebSplitPane)parent;
                this.mergeImpl(WebDocumentPane.getData(splitPane));
                this.revalidate();
                this.repaint();
            }
        } else {
            this.mergeImpl((SplitData)toMerge);
            this.revalidate();
            this.repaint();
        }
    }

    protected void mergeImpl(SplitData<T> splitData) {
        WebSplitPane splitPane;
        StructureData result;
        StructureData first = splitData.getFirst();
        StructureData last = splitData.getLast();
        if (WebDocumentPane.isEmptyPane(first) || WebDocumentPane.isEmptyPane(last)) {
            result = WebDocumentPane.isEmptyPane(first) ? last : first;
        } else {
            if (first instanceof SplitData) {
                this.mergeImpl((SplitData)first);
            }
            if (last instanceof SplitData) {
                this.mergeImpl((SplitData)last);
            }
            PaneData firstPane = (PaneData)first;
            PaneData lastPane = (PaneData)last;
            PaneData toPane = firstPane.count() > lastPane.count() ? firstPane : lastPane;
            PaneData fromPane = firstPane.count() > lastPane.count() ? lastPane : firstPane;
            for (DocumentData document : CollectionUtils.copy(fromPane.getData())) {
                fromPane.remove(document);
                toPane.add(document);
            }
            result = toPane;
        }
        if (this.activePane == first || this.activePane == last) {
            this.activePane = result.findClosestPane();
        }
        if ((splitPane = splitData.getSplitPane()).getParent() == this) {
            this.remove(splitPane);
            this.add(result.getComponent(), (Object)"Center");
            this.root = result;
        } else {
            WebSplitPane parentSplit = (WebSplitPane)splitPane.getParent();
            SplitData<T> parentSplitData = WebDocumentPane.getData(parentSplit);
            int dividerLocation = parentSplit.getDividerLocation();
            if (parentSplit.getLeftComponent() == splitPane) {
                parentSplitData.setFirst(result);
            } else {
                parentSplitData.setLast(result);
            }
            parentSplit.setDividerLocation(dividerLocation);
        }
    }

    public PaneData<T> getActivePane() {
        return this.activePane;
    }

    protected void activate(PaneData<T> paneData) {
        if (paneData != null) {
            this.activePane = paneData;
        }
    }

    protected void activate(T document) {
        this.activate((T)this.getPane(document));
        this.setSelected((DocumentData)document);
    }

    public T getSelectedDocument() {
        return this.activePane != null ? (T)this.activePane.getSelected() : null;
    }

    public T getDocument(int index) {
        return this.activePane != null ? (T)this.activePane.get(index) : null;
    }

    public T getDocument(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            T document = paneData.get(id);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    public List<T> getDocuments() {
        ArrayList<T> documents = new ArrayList<T>();
        for (PaneData<T> paneData : this.getAllPanes()) {
            documents.addAll(paneData.getData());
        }
        return documents;
    }

    public int getDocumentsCount() {
        int count = 0;
        for (PaneData<T> paneData : this.getAllPanes()) {
            count += paneData.count();
        }
        return count;
    }

    public List<PaneData<T>> getAllPanes() {
        ArrayList<PaneData<T>> panes = new ArrayList<PaneData<T>>();
        this.collectPanes(this.root, panes);
        return panes;
    }

    protected void collectPanes(StructureData structureData, List<PaneData<T>> panes) {
        if (structureData instanceof PaneData) {
            panes.add((PaneData)structureData);
        } else {
            SplitData splitData = (SplitData)structureData;
            this.collectPanes(splitData.getFirst(), panes);
            this.collectPanes(splitData.getLast(), panes);
        }
    }

    public List<SplitData<T>> getAllSplitPanes() {
        ArrayList<SplitData<T>> panes = new ArrayList<SplitData<T>>();
        this.collectSplitPanes(this.root, panes);
        return panes;
    }

    protected void collectSplitPanes(StructureData structureData, List<SplitData<T>> splits) {
        if (structureData instanceof SplitData) {
            SplitData splitData = (SplitData)structureData;
            splits.add(splitData);
            this.collectSplitPanes(splitData.getFirst(), splits);
            this.collectSplitPanes(splitData.getLast(), splits);
        }
    }

    public PaneData<T> getPane(T document) {
        return this.getPane(((DocumentData)document).getId());
    }

    public PaneData<T> getPane(String documentId) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.contains(documentId)) continue;
            return paneData;
        }
        return null;
    }

    public void setSelected(int index) {
        if (this.activePane != null) {
            this.activePane.setSelected(index);
        }
    }

    public void setSelected(DocumentData document) {
        this.setSelected(document.getId());
    }

    public void setSelected(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            T document = paneData.get(id);
            if (document == null) continue;
            paneData.setSelected(document);
            paneData.activate();
        }
    }

    public boolean isDocumentOpened(T document) {
        return this.isDocumentOpened(((DocumentData)document).getId());
    }

    public boolean isDocumentOpened(String documentId) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (!paneData.contains(documentId)) continue;
            return true;
        }
        return false;
    }

    public void openDocument(T document) {
        if (this.isDocumentOpened(document)) {
            this.setSelected((DocumentData)document);
        } else if (this.activePane != null) {
            this.activePane.open(document);
        }
    }

    public void closeDocument(int index) {
        if (this.activePane != null) {
            this.activePane.close(index);
        }
    }

    public void closeDocument(String id) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.close(id);
        }
    }

    public void closeDocument(T document) {
        for (PaneData<T> paneData : this.getAllPanes()) {
            if (paneData.close(document)) break;
        }
    }

    public void closeAll() {
        for (PaneData<T> paneData : this.getAllPanes()) {
            paneData.closeAll();
        }
    }

    public void addDocumentListener(DocumentListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void fireDocumentOpened(T document, PaneData<T> pane, int index) {
        for (DocumentListener<T> listener : CollectionUtils.copy(this.listeners)) {
            listener.opened(document, pane, index);
        }
    }

    public boolean fireDocumentClosing(T document, PaneData<T> pane, int index) {
        boolean allow = true;
        for (DocumentListener<T> listener : CollectionUtils.copy(this.listeners)) {
            allow = allow && listener.closing(document, pane, index);
        }
        return allow;
    }

    public void fireDocumentClosed(T document, PaneData<T> pane, int index) {
        for (DocumentListener<T> listener : CollectionUtils.copy(this.listeners)) {
            listener.closed(document, pane, index);
        }
    }

    public static <T extends DocumentData> PaneData<T> getData(WebTabbedPane tabbedPane) {
        return (PaneData)tabbedPane.getClientProperty(DATA_KEY);
    }

    public static <T extends DocumentData> SplitData<T> getData(WebSplitPane splitPane) {
        return (SplitData)splitPane.getClientProperty(DATA_KEY);
    }

    public static boolean isEmptyPane(StructureData data) {
        return data instanceof PaneData && ((PaneData)data).count() == 0;
    }
}

