/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentTransferable;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.managers.drag.DragViewHandler;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class DocumentDragViewHandler<T extends DocumentData>
implements DragViewHandler<T> {
    protected static final Insets margin = new Insets(6, 6, 6, 6);
    protected final WebDocumentPane documentPane;

    public DocumentDragViewHandler(WebDocumentPane documentPane) {
        this.documentPane = documentPane;
    }

    @Override
    public DataFlavor getObjectFlavor() {
        return DocumentTransferable.flavor;
    }

    @Override
    public BufferedImage getView(T document) {
        Icon icon = ((DocumentData)document).getIcon();
        String title = ((DocumentData)document).getActualTitle();
        FontMetrics fm = this.documentPane.getFontMetrics(this.documentPane.getFont());
        int tm = DocumentDragViewHandler.margin.left + (icon != null ? icon.getIconWidth() + 4 : 5);
        int em = DocumentDragViewHandler.margin.right + 5;
        int w = tm + fm.stringWidth(title) + em;
        int h = DocumentDragViewHandler.margin.top + Math.max(icon != null ? icon.getIconHeight() : 0, fm.getHeight()) + DocumentDragViewHandler.margin.bottom;
        BufferedImage image = ImageUtils.createCompatibleImage(w, h, 3);
        Graphics2D g2d = image.createGraphics();
        GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(0.8f));
        GraphicsUtils.setupFont(g2d, this.documentPane.getFont());
        GraphicsUtils.setupSystemTextHints(g2d);
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, w, h);
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.drawRect(0, 0, w - 1, h - 1);
        if (icon != null) {
            icon.paintIcon(null, g2d, DocumentDragViewHandler.margin.left, DocumentDragViewHandler.margin.top);
        }
        g2d.setPaint(Color.BLACK);
        g2d.drawString(title, tm, DocumentDragViewHandler.margin.top + (h - DocumentDragViewHandler.margin.top - DocumentDragViewHandler.margin.bottom) / 2 + LafUtils.getTextCenterShearY(fm));
        g2d.dispose();
        return image;
    }

    @Override
    public Point getViewRelativeLocation(T document) {
        return new Point(25, 5);
    }
}

