/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.style;

import com.alee.extended.window.PopOverDirection;
import com.alee.extended.window.WebPopOver;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.laf.combobox.WebComboBoxCellRenderer;
import com.alee.laf.combobox.WebComboBoxElement;
import com.alee.laf.combobox.WebComboBoxStyle;
import com.alee.laf.list.WebList;
import com.alee.laf.scroll.WebScrollBar;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.slider.WebSlider;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.style.SupportedComponent;
import com.alee.utils.CompareUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.InsetsConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class CodeLinkGenerator
implements LinkGenerator {
    private static final List<String> propertyNodes = Arrays.asList("component", "ui", "painter");
    private static final String trueString = "true";
    private static final String falseString = "false";
    private static final List<String> booleanContent = Arrays.asList("true", "false");
    private static final List<String> colorContent = Arrays.asList("foreground", "fg", "background", "bg", "color");
    private static final List<String> insetsContent = Arrays.asList("insets", "margin");
    private static final List<String> transparencyContent = Arrays.asList("opacity", "transparency");
    private static final ColorConverter colorConverter = new ColorConverter();
    private static final InsetsConverter insetsConverter = new InsetsConverter();
    private static final FloatConverter floatConverter = new FloatConverter();
    protected final Component parentComponent;
    protected Source src = null;
    protected String text = null;

    public CodeLinkGenerator(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public LinkGeneratorResult isLinkAtOffset(final RSyntaxTextArea source, int pos) {
        Element element;
        String code = source.getText();
        if (this.src == null || !CompareUtils.equals(this.src, code)) {
            this.text = code;
            this.src = new Source(code);
            this.src.fullSequentialParse();
        }
        if ((element = this.src.getEnclosingElement(pos)) == null) {
            return null;
        }
        Element parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        String name = element.getName();
        String parentName = parent.getName();
        if ("style".equals(name)) {
            Attributes attributes = element.getAttributes();
            for (Attribute attribute : attributes) {
                String attributeName;
                if (attribute.getBegin() >= pos || pos >= attribute.getEnd() || !(attributeName = attribute.getName()).equals("type")) continue;
                final Segment content = attribute.getValueSegment();
                String type = element.getAttributeValue("type");
                final SupportedComponent selectedType = SupportedComponent.valueOf(type);
                return new LinkGeneratorResult(){

                    @Override
                    public HyperlinkEvent execute() {
                        try {
                            final WebPopOver typeChooser = new WebPopOver(CodeLinkGenerator.this.parentComponent);
                            typeChooser.setCloseOnFocusLoss(true);
                            typeChooser.setStyleId("editor-pop-over");
                            typeChooser.setMargin(5, 0, 5, 0);
                            List<SupportedComponent> supportedComponents = SupportedComponent.getPainterSupportedComponents();
                            final WebList historyList = new WebList(supportedComponents);
                            historyList.setOpaque(false);
                            historyList.setVisibleRowCount(Math.min(10, supportedComponents.size()));
                            historyList.setRolloverSelectionEnabled(true);
                            historyList.setSelectedValue((Object)selectedType);
                            historyList.setCellRenderer(new WebComboBoxCellRenderer(){

                                @Override
                                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                    WebComboBoxElement renderer = (WebComboBoxElement)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                                    SupportedComponent type = (SupportedComponent)((Object)value);
                                    if (type != null) {
                                        renderer.setIcon(type.getIcon());
                                        renderer.setText(type.toString());
                                    }
                                    return renderer;
                                }
                            });
                            final Runnable commitChanges = new Runnable(){

                                @Override
                                public void run() {
                                    String typeString = historyList.getSelectedValue().toString();
                                    source.replaceRange(typeString, content.getBegin(), content.getEnd());
                                    typeChooser.dispose();
                                }
                            };
                            historyList.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseReleased(MouseEvent e) {
                                    commitChanges.run();
                                }
                            });
                            historyList.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyReleased(KeyEvent e) {
                                    if (Hotkey.ENTER.isKeyTriggered(e)) {
                                        commitChanges.run();
                                    }
                                }
                            });
                            WebScrollPane scrollPane = new WebScrollPane((Component)historyList, false, false);
                            scrollPane.setOpaque(false);
                            scrollPane.getViewport().setOpaque(false);
                            scrollPane.setShadeWidth(0);
                            WebScrollBar vsb = scrollPane.getWebVerticalScrollBar();
                            vsb.setMargin(WebComboBoxStyle.scrollBarMargin);
                            vsb.setPaintButtons(WebComboBoxStyle.scrollBarButtonsVisible);
                            vsb.setPaintTrack(WebComboBoxStyle.scrollBarTrackVisible);
                            LafUtils.setScrollBarStyleId(scrollPane, "combo-box");
                            typeChooser.add(scrollPane);
                            Rectangle wb = source.getUI().modelToView(source, (content.getBegin() + content.getEnd()) / 2);
                            typeChooser.show(source, wb.x, wb.y, wb.width, wb.height, PopOverDirection.down);
                            return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }

                    @Override
                    public int getSourceOffset() {
                        return content.getBegin();
                    }
                };
            }
        } else if (propertyNodes.contains(parentName)) {
            Insets insets;
            final Segment content = element.getContent();
            final String contentString = content.toString();
            if (booleanContent.contains(contentString)) {
                return new LinkGeneratorResult(){

                    @Override
                    public HyperlinkEvent execute() {
                        source.replaceRange(contentString.equals(CodeLinkGenerator.trueString) ? CodeLinkGenerator.falseString : CodeLinkGenerator.trueString, content.getBegin(), content.getEnd());
                        return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                    }

                    @Override
                    public int getSourceOffset() {
                        return content.getBegin();
                    }
                };
            }
            if (CompareUtils.contains(name.toLowerCase(), colorContent)) {
                final Color color = (Color)colorConverter.fromString(contentString);
                if (color != null || contentString.equals("null")) {
                    return new LinkGeneratorResult(){

                        @Override
                        public HyperlinkEvent execute() {
                            try {
                                WebPopOver colorChooser = new WebPopOver(CodeLinkGenerator.this.parentComponent);
                                colorChooser.setCloseOnFocusLoss(true);
                                colorChooser.setStyleId("editor-pop-over");
                                final WebColorChooserPanel colorChooserPanel = new WebColorChooserPanel(false);
                                colorChooserPanel.setColor(color != null ? color : Color.WHITE);
                                colorChooserPanel.addChangeListener(new ChangeListener(){
                                    private int length;
                                    {
                                        this.length = content.getEnd() - content.getBegin();
                                    }

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        Color newColor = colorChooserPanel.getColor();
                                        if (color == null || newColor != null && !newColor.equals(color)) {
                                            String colorString = colorConverter.toString(newColor);
                                            source.replaceRange(colorString, content.getBegin(), content.getBegin() + this.length);
                                            this.length = colorString.length();
                                        }
                                    }
                                });
                                colorChooser.add(colorChooserPanel);
                                Rectangle wb = source.getUI().modelToView(source, (content.getBegin() + content.getEnd()) / 2);
                                colorChooser.show(source, wb.x, wb.y, wb.width, wb.height, PopOverDirection.down);
                                return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                                return null;
                            }
                        }

                        @Override
                        public int getSourceOffset() {
                            return content.getBegin();
                        }
                    };
                }
            } else if (CompareUtils.contains(name.toLowerCase(), transparencyContent)) {
                final Float f = (Float)floatConverter.fromString(contentString);
                if (f != null) {
                    return new LinkGeneratorResult(){

                        @Override
                        public HyperlinkEvent execute() {
                            try {
                                WebPopOver transparencyChooser = new WebPopOver(CodeLinkGenerator.this.parentComponent);
                                transparencyChooser.setCloseOnFocusLoss(true);
                                transparencyChooser.setStyleId("editor-pop-over");
                                int value = MathUtils.limit(Math.round(1000.0f * f.floatValue()), 0, 1000);
                                final WebSlider slider = new WebSlider(0, 0, 1000, value);
                                slider.setPaintTicks(true);
                                slider.setMajorTickSpacing(50);
                                slider.setMinorTickSpacing(10);
                                slider.setPaintLabels(false);
                                slider.setSnapToTicks(true);
                                slider.setMargin(10);
                                slider.setPreferredWidth(500);
                                slider.addChangeListener(new ChangeListener(){
                                    private int length;
                                    {
                                        this.length = content.getEnd() - content.getBegin();
                                    }

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        String floatString = floatConverter.toString(Float.valueOf((float)slider.getValue() / 1000.0f));
                                        source.replaceRange(floatString, content.getBegin(), content.getBegin() + this.length);
                                        this.length = floatString.length();
                                    }
                                });
                                transparencyChooser.add(slider);
                                Rectangle wb = source.getUI().modelToView(source, (content.getBegin() + content.getEnd()) / 2);
                                transparencyChooser.show(source, wb.x, wb.y, wb.width, wb.height, PopOverDirection.down);
                                return new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, null);
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                                return null;
                            }
                        }

                        @Override
                        public int getSourceOffset() {
                            return content.getBegin();
                        }
                    };
                }
            } else if (CompareUtils.contains(name.toLowerCase(), insetsContent) && (insets = (Insets)insetsConverter.fromString(contentString)) != null) {
                return null;
            }
        }
        return null;
    }
}

