/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.progress;

import com.alee.extended.progress.StepData;
import com.alee.extended.progress.WebStepProgressStyle;
import com.alee.global.StyleConstants;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebStepProgress
extends JComponent
implements SwingConstants,
ShapeProvider,
SizeMethods<WebStepProgress> {
    public static final int STEP_SELECTION = 1;
    public static final int PROGRESS_SELECTION = 2;
    private Insets margin = WebStepProgressStyle.margin;
    private int shadeWidth = WebStepProgressStyle.shadeWidth;
    private int stepControlSize = WebStepProgressStyle.stepControlSize;
    private int stepControlRound = WebStepProgressStyle.stepControlRound;
    private int stepControlFillSize = WebStepProgressStyle.stepControlFillSize;
    private int stepControlFillRound = WebStepProgressStyle.stepControlFillRound;
    private int pathSize = WebStepProgressStyle.pathSize;
    private int fillPathSize = WebStepProgressStyle.fillPathSize;
    private Color progressColor = WebStepProgressStyle.progressColor;
    private Color disabledProgressColor = WebStepProgressStyle.disabledProgressColor;
    private boolean showLabels = WebStepProgressStyle.showLabels;
    private int orientation = WebStepProgressStyle.orientation;
    private int labelsPosition = WebStepProgressStyle.labelsPosition;
    private int spacing = WebStepProgressStyle.spacing;
    private boolean selectionEnabled = WebStepProgressStyle.selectionEnabled;
    private int selectionMode = WebStepProgressStyle.selectionMode;
    private List<StepData> steps = new ArrayList<StepData>();
    private int selectedStep = 0;
    private float progress = 0.0f;
    private boolean selecting = false;
    private int sideWidth = 0;
    private Shape borderShape;
    private LinearGradientPaint fillPaint;
    private Shape fillShape;

    public WebStepProgress() {
        this(3);
    }

    public WebStepProgress(int steps) {
        this(WebStepProgress.createDefaultData(steps));
    }

    public WebStepProgress(String ... steps) {
        this(WebStepProgress.createSteps(steps));
    }

    public WebStepProgress(Component ... steps) {
        this(WebStepProgress.createSteps(steps));
    }

    public WebStepProgress(StepData ... steps) {
        this(CollectionUtils.copy(steps));
    }

    public WebStepProgress(List<StepData> steps) {
        this.setSteps(steps);
        this.setLayout(new ProgressLayout());
        ProgressMouseAdapter pma = new ProgressMouseAdapter();
        this.addMouseListener(pma);
        this.addMouseMotionListener(pma);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebStepProgress.this.updateShapes();
            }
        });
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.revalidate();
        this.repaint();
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.revalidate();
        this.repaint();
    }

    public int getStepControlSize() {
        return this.stepControlSize;
    }

    public void setStepControlSize(int stepControlSize) {
        this.stepControlSize = stepControlSize;
        this.revalidate();
        this.repaint();
    }

    public int getStepControlRound() {
        return this.stepControlRound;
    }

    public void setStepControlRound(int stepControlRound) {
        this.stepControlRound = stepControlRound;
        this.repaint();
    }

    public int getStepControlFillSize() {
        return this.stepControlFillSize;
    }

    public void setStepControlFillSize(int stepControlFillSize) {
        this.stepControlFillSize = stepControlFillSize;
        this.revalidate();
        this.repaint();
    }

    public int getStepControlFillRound() {
        return this.stepControlFillRound;
    }

    public void setStepControlFillRound(int stepControlFillRound) {
        this.stepControlFillRound = stepControlFillRound;
        this.repaint();
    }

    public int getPathSize() {
        return this.pathSize;
    }

    public void setPathSize(int pathSize) {
        this.pathSize = pathSize;
        this.revalidate();
        this.repaint();
    }

    public int getFillPathSize() {
        return this.fillPathSize;
    }

    public void setFillPathSize(int fillPathSize) {
        this.fillPathSize = fillPathSize;
        this.revalidate();
        this.repaint();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        if (this.showLabels != showLabels) {
            this.showLabels = showLabels;
            if (showLabels) {
                for (StepData step : this.steps) {
                    if (step.getLabel() == null) continue;
                    this.add(step.getLabel());
                }
            } else {
                for (StepData step : this.steps) {
                    if (step.getLabel() == null) continue;
                    this.remove(step.getLabel());
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.revalidate();
        this.repaint();
    }

    public int getLabelsPosition() {
        return this.labelsPosition;
    }

    public void setLabelsPosition(int labelsPosition) {
        this.labelsPosition = labelsPosition;
        this.revalidate();
        this.repaint();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.revalidate();
        this.repaint();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.selectionEnabled = selectionEnabled;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getStepsAmount() {
        return this.steps.size();
    }

    public List<StepData> getSteps() {
        return this.steps;
    }

    public StepData getStep(int index) {
        return this.steps.get(index);
    }

    public void setSteps(String ... steps) {
        this.setSteps(WebStepProgress.createSteps(steps));
    }

    public void setSteps(Component ... steps) {
        this.setSteps(WebStepProgress.createSteps(steps));
    }

    public void setSteps(List<StepData> steps) {
        this.clearSteps();
        this.addSteps(steps);
        this.validateSelectedStep();
    }

    public void addSteps(String ... steps) {
        if (steps != null) {
            this.addSteps(WebStepProgress.createSteps(steps));
        }
    }

    public void addSteps(Component ... steps) {
        if (steps != null) {
            this.addSteps(WebStepProgress.createSteps(steps));
        }
    }

    public void addSteps(List<StepData> steps) {
        if (steps != null) {
            this.steps.addAll(steps);
            if (this.showLabels) {
                for (StepData step : steps) {
                    if (step.getLabel() == null) continue;
                    this.add(step.getLabel());
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void removeStep(int index) {
        this.removeStep(this.getStep(index));
    }

    public void removeStep(StepData stepData) {
        this.clearStep(stepData);
        this.validateSelectedStep();
        this.revalidate();
        this.repaint();
    }

    public void setStepsAmount(int stepsAmount) {
        this.clearSteps();
        this.addSteps(WebStepProgress.createDefaultData(stepsAmount));
        this.validateSelectedStep();
        this.revalidate();
        this.repaint();
    }

    private void clearSteps() {
        if (this.steps.size() > 0) {
            for (StepData step : CollectionUtils.copy(this.steps)) {
                this.clearStep(step);
            }
        }
    }

    private void clearStep(StepData step) {
        Component label;
        if (this.showLabels && (label = step.getLabel()) != null) {
            label.getParent().remove(label);
        }
        this.steps.remove(step);
    }

    public int getSelectedStep() {
        return this.selectedStep;
    }

    public void setSelectedStep(int selectedStep) {
        if (selectedStep == this.selectedStep) {
            return;
        }
        if (selectedStep < 0) {
            selectedStep = 0;
        }
        if (selectedStep >= this.steps.size()) {
            selectedStep = this.steps.size() - 1;
        }
        this.selectedStep = selectedStep;
        this.progress = 0.0f;
        this.updateFillShape();
    }

    private void validateSelectedStep() {
        if (this.selectedStep < this.getStepsAmount()) {
            this.setSelectedStep(0);
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        if (progress == this.progress) {
            return;
        }
        if (progress < 0.0f) {
            float p = Math.abs(progress);
            int s = this.selectedStep - Math.round(p - p % 1.0f) - 1;
            progress = s < 0 ? 0.0f : 1.0f - p % 1.0f;
            this.setSelectedStep(s);
        } else if (progress >= 1.0f) {
            int s = this.selectedStep + Math.round(progress - progress % 1.0f);
            progress = s >= this.steps.size() ? 0.0f : progress % 1.0f;
            this.setSelectedStep(s);
        }
        this.progress = progress;
        this.updateFillShape();
    }

    public float getTotalProgress() {
        return ((float)this.selectedStep + this.progress) / (float)(this.steps.size() - 1);
    }

    public float getTotalProgressAt(Point point) {
        boolean hor = this.orientation == 0;
        Point p1 = this.getPathStart();
        Point p2 = this.getPathEnd();
        float pw = this.getPathWidth();
        if (hor) {
            if (this.getComponentOrientation().isLeftToRight()) {
                if (point.x < p1.x) {
                    return 0.0f;
                }
                if (point.x > p2.x) {
                    return this.steps.size() - 1;
                }
                return (float)((this.steps.size() - 1) * (point.x - p1.x)) / pw;
            }
            if (point.x > p1.x) {
                return 0.0f;
            }
            if (point.x < p2.x) {
                return this.steps.size() - 1;
            }
            return (float)(this.steps.size() - 1) * (pw - (float)(point.x - p2.x)) / pw;
        }
        if (point.y < p1.y) {
            return 0.0f;
        }
        if (point.y > p2.y) {
            return this.steps.size() - 1;
        }
        return (float)((this.steps.size() - 1) * (point.y - p1.y)) / pw;
    }

    public void setTotalProgress(float totalProgress) {
        totalProgress = (float)(this.steps.size() - 1) * totalProgress;
        this.setSelectedStep(Math.round(totalProgress - totalProgress % 1.0f));
        this.setProgress(totalProgress % 1.0f);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        LafUtils.drawCustomWebBorder(g2d, this, this.getBorderShape(), StyleConstants.shadeColor, this.shadeWidth, true, true);
        g2d.setPaint(this.getFillPaint());
        g2d.fill(this.getProgressShape());
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    @Override
    public Shape provideShape() {
        return this.getBorderShape();
    }

    protected void updateBorderShape() {
        this.borderShape = null;
        this.repaint();
    }

    protected void updateFillShape() {
        this.fillPaint = null;
        this.fillShape = null;
        this.repaint();
    }

    protected void updateShapes() {
        this.borderShape = null;
        this.fillPaint = null;
        this.fillShape = null;
        this.repaint();
    }

    private Shape getBorderShape() {
        if (this.borderShape == null) {
            this.borderShape = this.createBorderShape();
        }
        return this.borderShape;
    }

    private Shape createBorderShape() {
        Area border = new Area(this.getPathShape());
        for (int i = 0; i < this.steps.size(); ++i) {
            border.add(new Area(this.getStepBorderCircle(i)));
        }
        return border;
    }

    private Shape getStepBorderCircle(int step) {
        Point center = this.getStepCenter(step);
        if (this.stepControlRound * 2 >= this.stepControlSize) {
            return new Ellipse2D.Double(center.x - this.stepControlSize / 2, center.y - this.stepControlSize / 2, this.stepControlSize, this.stepControlSize);
        }
        return new RoundRectangle2D.Double(center.x - this.stepControlSize / 2, center.y - this.stepControlSize / 2, this.stepControlSize, this.stepControlSize, this.stepControlRound * 2, this.stepControlRound * 2);
    }

    private LinearGradientPaint getFillPaint() {
        if (this.fillPaint == null) {
            this.fillPaint = this.createFillPaint();
        }
        return this.fillPaint;
    }

    private LinearGradientPaint createFillPaint() {
        Color color;
        Point p1 = this.getPathStart();
        float tss = (float)this.selectedStep + this.progress;
        int sw = this.getPathWidth() / (this.steps.size() - 1);
        float pw = (float)this.stepControlFillSize * 1.5f + (float)sw * tss;
        Color color2 = color = this.isEnabled() ? this.progressColor : this.disabledProgressColor;
        if (this.orientation == 0) {
            Color[] colorArray;
            float[] fArray;
            float px;
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            float f = px = ltr ? (float)(p1.x - this.stepControlFillSize / 2) : (float)(p1.x + this.stepControlFillSize / 2) - pw;
            if (ltr) {
                float[] fArray2 = new float[3];
                fArray2[0] = 0.0f;
                fArray2[1] = ((float)this.stepControlFillSize + (float)sw * tss) / pw;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = 0.0f;
                fArray3[1] = 1.0f - ((float)this.stepControlFillSize + (float)sw * tss) / pw;
                fArray = fArray3;
                fArray3[2] = 1.0f;
            }
            float[] fractions = fArray;
            if (ltr) {
                Color[] colorArray2 = new Color[3];
                colorArray2[0] = color;
                colorArray2[1] = color;
                colorArray = colorArray2;
                colorArray2[2] = StyleConstants.transparent;
            } else {
                Color[] colorArray3 = new Color[3];
                colorArray3[0] = StyleConstants.transparent;
                colorArray3[1] = color;
                colorArray = colorArray3;
                colorArray3[2] = color;
            }
            Color[] colors = colorArray;
            return new LinearGradientPaint(px, 0.0f, px + pw, 0.0f, fractions, colors);
        }
        float py = p1.y - this.stepControlFillSize / 2;
        return new LinearGradientPaint(0.0f, py, 0.0f, py + pw, new float[]{0.0f, ((float)this.stepControlFillSize + (float)sw * tss) / pw, 1.0f}, new Color[]{color, color, StyleConstants.transparent});
    }

    private Shape getProgressShape() {
        if (this.fillShape == null) {
            this.fillShape = this.createFillShape();
        }
        return this.fillShape;
    }

    private Shape createFillShape() {
        Area border = new Area(this.getPathFillShape());
        for (int i = 0; i < this.steps.size(); ++i) {
            border.add(new Area(this.getStepFillCircle(i)));
        }
        return border;
    }

    private Shape getStepFillCircle(int step) {
        Point center = this.getStepCenter(step);
        if (this.stepControlFillRound * 2 >= this.stepControlFillSize) {
            return new Ellipse2D.Double(center.x - this.stepControlFillSize / 2, center.y - this.stepControlFillSize / 2, this.stepControlFillSize, this.stepControlFillSize);
        }
        return new RoundRectangle2D.Double(center.x - this.stepControlFillSize / 2, center.y - this.stepControlFillSize / 2, this.stepControlFillSize, this.stepControlFillSize, this.stepControlFillRound * 2, this.stepControlFillRound * 2);
    }

    private Shape getPathShape() {
        Point p1 = this.getPathStart();
        Point p2 = this.getPathEnd();
        if (this.orientation == 0) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            return new Rectangle2D.Double(ltr ? (double)p1.x : (double)p2.x, (float)p1.y - (float)this.pathSize / 2.0f, ltr ? (double)(p2.x - p1.x) : (double)(p1.x - p2.x), this.pathSize);
        }
        return new Rectangle2D.Double((float)p1.x - (float)this.pathSize / 2.0f, p1.y, this.pathSize, p2.y - p1.y);
    }

    private Shape getPathFillShape() {
        Point p1 = this.getPathStart();
        Point p2 = this.getPathEnd();
        if (this.orientation == 0) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            return new Rectangle2D.Double(ltr ? (double)p1.x : (double)p2.x, (float)p1.y + 0.5f - (float)this.fillPathSize / 2.0f, ltr ? (double)(p2.x - p1.x) : (double)(p1.x - p2.x), this.fillPathSize);
        }
        return new Rectangle2D.Double((float)p1.x + 0.5f - (float)this.fillPathSize / 2.0f, p1.y, this.fillPathSize, p2.y - p1.y);
    }

    private Point getPathStart() {
        return this.getStepCenter(0);
    }

    private Point getPathEnd() {
        return this.getStepCenter(this.steps.size() - 1);
    }

    private Point getStepCenter(int step) {
        Dimension max = this.getMaximumComponentSize();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (this.orientation == 0) {
            int x = this.margin.left + this.sideWidth + this.getPathWidth() * (ltr ? step : this.steps.size() - 1 - step) / (this.steps.size() - 1);
            int wh = this.getHeight() - this.margin.top - this.margin.bottom;
            int sh = max.height + (max.height > 0 ? this.spacing : 0);
            int ch = sh + this.stepControlSize + this.shadeWidth * 2;
            int y = this.margin.top + wh / 2 - ch / 2 + (this.labelsPosition == 10 ? sh : 0) + this.shadeWidth + this.stepControlSize / 2;
            return new Point(x, y);
        }
        int y = this.margin.top + this.sideWidth + this.getPathWidth() * step / (this.steps.size() - 1);
        int ww = this.getWidth() - this.margin.left - this.margin.right;
        int sw = max.width + (max.width > 0 ? this.spacing : 0);
        int cw = sw + this.stepControlSize + this.shadeWidth * 2;
        int x = this.margin.left + ww / 2 - cw / 2 + ((ltr ? this.labelsPosition == 10 : this.labelsPosition == 11) ? sw : 0) + this.shadeWidth + this.stepControlSize / 2;
        return new Point(x, y);
    }

    private int getPathWidth() {
        if (this.orientation == 0) {
            return this.getWidth() - this.sideWidth * 2 - this.margin.left - this.margin.right - 1;
        }
        return this.getHeight() - this.sideWidth * 2 - this.margin.top - this.margin.bottom - 1;
    }

    public int getStepCircleAt(Point point) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.getStepBorderCircle(i).contains(point)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebStepProgress setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebStepProgress setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebStepProgress setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebStepProgress setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps;
        if (this.isPreferredSizeSet()) {
            ps = super.getPreferredSize();
        } else {
            Dimension max = this.getMaximumComponentSize();
            Dimension maxSide = this.getMaximumSideComponentSize();
            if (this.orientation == 0) {
                this.sideWidth = Math.max(maxSide.width / 2, this.stepControlSize / 2 + this.shadeWidth);
                int w = this.margin.left + this.shadeWidth * (this.steps.size() - 1) * 2 + this.stepControlSize * (this.steps.size() - 1) + this.sideWidth * 2 + this.margin.right + 1;
                int h = this.margin.top + this.shadeWidth * 2 + this.stepControlSize + max.height + (max.height > 0 ? this.spacing : 0) + this.margin.bottom + 1;
                ps = new Dimension(w, h);
            } else {
                this.sideWidth = Math.max(maxSide.height / 2, this.stepControlSize / 2 + this.shadeWidth);
                int w = this.margin.left + this.shadeWidth * 2 + this.stepControlSize + max.width + (max.width > 0 ? this.spacing : 0) + this.margin.right + 1;
                int h = this.margin.top + this.shadeWidth * (this.steps.size() - 1) * 2 + this.stepControlSize * (this.steps.size() - 1) + this.sideWidth * 2 + this.margin.bottom + 1;
                ps = new Dimension(w, h);
            }
        }
        return SizeUtils.getPreferredSize(this, ps);
    }

    private Dimension getMaximumComponentSize() {
        Dimension max = new Dimension(0, 0);
        if (this.showLabels && this.steps.size() > 0) {
            for (StepData step : this.steps) {
                if (step.getLabel() == null) continue;
                max = SwingUtils.max(max, step.getLabel().getPreferredSize());
            }
        }
        return max;
    }

    private Dimension getMaximumSideComponentSize() {
        if (this.showLabels && this.steps.size() > 0) {
            Component l1 = this.steps.get(0).getLabel();
            Component l2 = this.steps.get(this.steps.size() - 1).getLabel();
            if (l1 != null && l2 != null) {
                return SwingUtils.max(l1.getPreferredSize(), l2.getPreferredSize());
            }
            if (l1 != null) {
                return l1.getPreferredSize();
            }
            if (l2 != null) {
                return l2.getPreferredSize();
            }
            return new Dimension(0, 0);
        }
        return new Dimension(0, 0);
    }

    public static List<StepData> createSteps(String[] steps) {
        ArrayList<StepData> s = new ArrayList<StepData>();
        for (String step : steps) {
            s.add(new StepData(step));
        }
        return s;
    }

    public static List<StepData> createSteps(Component[] steps) {
        ArrayList<StepData> s = new ArrayList<StepData>();
        for (Component step : steps) {
            s.add(new StepData(step));
        }
        return s;
    }

    public static List<StepData> createDefaultData(int stepsAmount) {
        ArrayList<StepData> s = new ArrayList<StepData>(stepsAmount);
        for (int i = 0; i < stepsAmount; ++i) {
            s.add(new StepData());
        }
        return s;
    }

    private class ProgressMouseAdapter
    extends MouseAdapter {
        private ProgressMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (WebStepProgress.this.isEnabled() && WebStepProgress.this.isSelectionEnabled() && SwingUtils.isLeftMouseButton(e)) {
                WebStepProgress.this.selecting = true;
                this.updateProgress(e.getPoint());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (WebStepProgress.this.selecting && SwingUtils.isLeftMouseButton(e)) {
                this.updateProgress(e.getPoint());
            }
        }

        private void updateProgress(Point p) {
            float tp = WebStepProgress.this.getTotalProgressAt(p);
            if (WebStepProgress.this.selectionMode == 2) {
                WebStepProgress.this.setSelectedStep(Math.round(tp - tp % 1.0f));
                WebStepProgress.this.setProgress(tp % 1.0f);
            } else {
                WebStepProgress.this.setSelectedStep(Math.round(tp));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (WebStepProgress.this.selecting && SwingUtils.isLeftMouseButton(e)) {
                WebStepProgress.this.selecting = false;
            }
        }
    }

    private class ProgressLayout
    implements LayoutManager {
        private ProgressLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean ltr = WebStepProgress.this.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < WebStepProgress.this.steps.size(); ++i) {
                Component label = WebStepProgress.this.getStep(i).getLabel();
                if (label == null) continue;
                Point sc = WebStepProgress.this.getStepCenter(i);
                Dimension ps = label.getPreferredSize();
                if (WebStepProgress.this.orientation == 0) {
                    if (WebStepProgress.this.labelsPosition == 10) {
                        label.setBounds(sc.x - ps.width / 2, sc.y - WebStepProgress.this.stepControlSize / 2 - WebStepProgress.this.shadeWidth - WebStepProgress.this.spacing - ps.height, ps.width, ps.height);
                        continue;
                    }
                    label.setBounds(sc.x - ps.width / 2, sc.y + WebStepProgress.this.stepControlSize / 2 + WebStepProgress.this.shadeWidth + WebStepProgress.this.spacing, ps.width, ps.height);
                    continue;
                }
                if (ltr ? WebStepProgress.this.labelsPosition == 10 : WebStepProgress.this.labelsPosition == 11) {
                    label.setBounds(sc.x - WebStepProgress.this.stepControlSize / 2 - WebStepProgress.this.shadeWidth - WebStepProgress.this.spacing - ps.width, sc.y - ps.height / 2, ps.width, ps.height);
                    continue;
                }
                label.setBounds(sc.x + WebStepProgress.this.stepControlSize / 2 + WebStepProgress.this.shadeWidth + WebStepProgress.this.spacing, sc.y - ps.height / 2, ps.width, ps.height);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }
    }
}

